/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.sunlight;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.TimeUtil;
import su.nightexpress.sunlight.config.Config;
import su.nightexpress.sunlight.utils.Direction;

public class SLUtils {
    public static final String CONSOLE_NAME = Bukkit.getServer().getConsoleSender().getName();
    private static DateTimeFormatter dateFormatter;
    private static DateTimeFormatter timeFormatter;
    private static final Direction[] DIRECTIONS;

    public static void setDateFormatter(@NotNull String pattern) {
        dateFormatter = DateTimeFormatter.ofPattern(pattern);
    }

    public static void setTimeFormatter(@NotNull String pattern) {
        timeFormatter = DateTimeFormatter.ofPattern(pattern);
    }

    public static boolean hasPacketLibrary() {
        return Plugins.isInstalled((String)"packetevents") || Plugins.isInstalled((String)"ProtocolLib");
    }

    @Deprecated
    @NotNull
    public static String createIdentifier(@NotNull Player player) {
        String uuid = player.getUniqueId().toString();
        if (Players.isBedrock((Player)player)) {
            uuid = new StringBuilder(uuid).reverse().toString();
        }
        return uuid;
    }

    public static boolean isVanished(@NotNull Player player) {
        return player.hasMetadata("vanished");
    }

    @NotNull
    public static Direction getDirection(@NotNull Location from, @NotNull Location to) {
        int dx = to.getBlockX() - from.getBlockX();
        int dz = to.getBlockZ() - from.getBlockZ();
        if (Math.abs(dx) == 0 && Math.abs(dz) == 0) {
            return Direction.HERE;
        }
        double angle = Math.toDegrees(Math.atan2(-dz, dx));
        double angleNormalized = (angle + 360.0) % 360.0;
        int slices = DIRECTIONS.length;
        double sliceAngle = 360.0 / (double)slices;
        double halfSlice = sliceAngle / 2.0;
        int index = (int)((angleNormalized + halfSlice) / sliceAngle);
        int finalIndex = index % slices;
        return DIRECTIONS[finalIndex];
    }

    @Deprecated
    public static int clamp(long value, long min, long max) {
        if (min > max) {
            throw new IllegalArgumentException(min + " > " + max);
        }
        return (int)Math.min(max, Math.max(value, min));
    }

    @NotNull
    public static String formatDate(long timestamp) {
        return dateFormatter.format(TimeUtil.getLocalDateTimeOf((long)timestamp));
    }

    @NotNull
    public static String formatTime(@NotNull LocalTime localTime) {
        return timeFormatter.format(localTime);
    }

    @Deprecated
    @NotNull
    public static String getSenderName(@NotNull String name) {
        if (name.equalsIgnoreCase(CONSOLE_NAME)) {
            return (String)Config.CONSOLE_NAME.get();
        }
        Player player = Players.getPlayer((String)name);
        if (player != null) {
            return player.getDisplayName();
        }
        return name;
    }

    @Deprecated
    @NotNull
    public static String getSenderName(@NotNull CommandSender sender) {
        if (sender instanceof ConsoleCommandSender) {
            return (String)Config.CONSOLE_NAME.get();
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            return player.getDisplayName();
        }
        return sender.getName();
    }

    @NotNull
    public static Optional<InetAddress> getInetAddress(@NotNull Player player) {
        return Optional.ofNullable(player.getAddress()).map(InetSocketAddress::getAddress);
    }

    static {
        DIRECTIONS = new Direction[]{Direction.EAST, Direction.NORTH_EAST, Direction.NORTH, Direction.NORTH_WEST, Direction.WEST, Direction.SOUTH_WEST, Direction.SOUTH, Direction.SOUTH_EAST};
    }
}

