/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.tooltip;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentenchants.tooltip.format.ChargesFormat;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.AbstractConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class TooltipSettings
extends AbstractConfig {
    private static final ConfigType<ChargesFormat> CHARGES_FORMAT_CONFIG_TYPE = ConfigType.of(ChargesFormat::read, FileConfig::set);
    private final ConfigProperty<Boolean> booksOnly = this.addProperty(ConfigTypes.BOOLEAN, "EnchantTooltip.Books_Only", false, new String[]{"Sets whether or not only enchanted books will have enchantment descriptions."});
    private final ConfigProperty<String> formatDefault = this.addProperty(ConfigTypes.STRING, "EnchantTooltip.Format.Default", TagWrappers.GRAY.wrap("\u2022 %description%"), new String[]{"Sets description format for enchantments without charges."});
    private final ConfigProperty<String> formatWithCharges = this.addProperty(ConfigTypes.STRING, "EnchantTooltip.Format.WithCharges", TagWrappers.GRAY.wrap("\u2022 %description% %charges%"), new String[]{"Sets description format for enchantments with charges enabled."});
    private final ConfigProperty<Map<String, ChargesFormat>> chargesByAmountFormat = this.addProperty(ConfigTypes.forMapWithLowerKeys(CHARGES_FORMAT_CONFIG_TYPE), "EnchantTooltip.Format.Charges-By-Percent", TooltipSettings.getDefaultChargesFormat(), new String[]{"Sets charges format based on percent of max. charges amount."});

    public void load(@NotNull FileConfig config) {
        if (config.contains("Description")) {
            config.set("EnchantTooltip.Books_Only", (Object)config.getBoolean("Description.Books_Only"));
            config.set("EnchantTooltip.Format.Default", (Object)config.getString("Description.Format.Default"));
            config.set("EnchantTooltip.Format.WithCharges", (Object)config.getString("Description.Format.WithCharges"));
            config.remove("Description");
        }
        super.load(config);
    }

    public boolean isForBooksOnly() {
        return (Boolean)this.booksOnly.get();
    }

    @NotNull
    public String getTooltipFormat() {
        return (String)this.formatDefault.get();
    }

    @NotNull
    public String getTooltipFormatWithCharges() {
        return (String)this.formatWithCharges.get();
    }

    @Nullable
    public ChargesFormat getTooltipChargesFormat(int percent) {
        return ((Map)this.chargesByAmountFormat.get()).values().stream().filter(other -> other.isAboveThreshold(percent)).max(Comparator.comparingInt(ChargesFormat::getThreshold)).orElse(null);
    }

    @NotNull
    private static Map<String, ChargesFormat> getDefaultChargesFormat() {
        LinkedHashMap<String, ChargesFormat> map = new LinkedHashMap<String, ChargesFormat>();
        map.put("zero", new ChargesFormat(0, TagWrappers.SOFT_RED.wrap("(%amount%\u26a1)")));
        map.put("low", new ChargesFormat(25, TagWrappers.SOFT_ORANGE.wrap("(%amount%\u26a1)")));
        map.put("medium", new ChargesFormat(50, TagWrappers.SOFT_YELLOW.wrap("(%amount%\u26a1)")));
        map.put("high", new ChargesFormat(75, TagWrappers.SOFT_GREEN.wrap("(%amount%\u26a1)")));
        return map;
    }
}

