/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.placeholder;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.enchantment.CustomEnchantment;
import su.nightexpress.excellentenchants.enchantment.EnchantRegistry;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.Numbers;

public class PlaceholderHook {
    private static EnchantsExpansion expansion;

    public static void setup(@NotNull EnchantsPlugin plugin) {
        if (expansion == null) {
            expansion = new EnchantsExpansion(plugin);
            expansion.register();
        }
    }

    public static void shutdown() {
        if (expansion != null) {
            expansion.unregister();
            expansion = null;
        }
    }

    static class EnchantsExpansion
    extends PlaceholderExpansion {
        private final EnchantsPlugin plugin;

        public EnchantsExpansion(@NotNull EnchantsPlugin plugin) {
            this.plugin = plugin;
        }

        @NotNull
        public String getIdentifier() {
            return LowerCase.INTERNAL.apply(this.plugin.getName());
        }

        @NotNull
        public String getAuthor() {
            return (String)this.plugin.getDescription().getAuthors().getFirst();
        }

        @NotNull
        public String getVersion() {
            return this.plugin.getDescription().getVersion();
        }

        public boolean persist() {
            return true;
        }

        @Nullable
        public String onPlaceholderRequest(Player player, @NotNull String params) {
            if (params.startsWith("charges_remaining_")) {
                String[] chargesSplit = params.substring("charges_remaining_".length()).split(":");
                if (chargesSplit.length < 2) {
                    return null;
                }
                EquipmentSlot slot = (EquipmentSlot)Enums.get((String)chargesSplit[0], EquipmentSlot.class);
                if (slot == null) {
                    return null;
                }
                ItemStack itemStack = player.getInventory().getItem(slot);
                if (itemStack == null || itemStack.getType().isAir()) {
                    return "-";
                }
                CustomEnchantment enchant = EnchantRegistry.getById(chargesSplit[1]);
                if (enchant == null) {
                    return null;
                }
                return String.valueOf(enchant.getCharges(itemStack));
            }
            if (params.startsWith("charges_maximum_")) {
                String[] chargesSplit = params.substring("charges_maximum_".length()).split(":");
                if (chargesSplit.length < 2) {
                    return null;
                }
                CustomEnchantment enchant = EnchantRegistry.getById(chargesSplit[0]);
                if (enchant == null) {
                    return null;
                }
                int level = Numbers.getIntegerAbs((String)chargesSplit[1], (int)1);
                return String.valueOf(enchant.getCharges().getMaxAmount(level));
            }
            return super.onPlaceholderRequest(player, params);
        }
    }
}

