/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.manager.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.enchantment.CustomEnchantment;
import su.nightexpress.excellentenchants.enchantment.EnchantRegistry;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.bridge.common.NightKey;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.ConfigBased;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.data.MenuLoader;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.NormalMenu;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.LangUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.bridge.RegistryType;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.placeholder.Replacer;
import su.nightexpress.nightcore.util.text.night.NightMessage;
import su.nightexpress.nightcore.util.text.tag.Tags;

public class EnchantsMenu
extends NormalMenu<EnchantsPlugin>
implements ConfigBased,
Filled<CustomEnchantment> {
    private static final String FILE_NAME = "enchants.yml";
    private static final String CONFLICTS = "%conflicts%";
    private static final String CHARGES = "%charges%";
    private final NamespacedKey levelKey;
    private NightItem enchantIcon;
    private String enchantName;
    private List<String> enchantLoreMain;
    private List<String> enchantLoreConflicts;
    private List<String> enchantLoreCharges;
    private int[] enchantSlots;

    public EnchantsMenu(@NotNull EnchantsPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X4, Tags.BLACK.wrap("Custom Enchantments"));
        this.levelKey = new NamespacedKey((Plugin)plugin, "list_display_level");
        this.load(FileConfig.loadOrExtract((NightCorePlugin)plugin, (String)"/menu/", (String)FILE_NAME));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    @NotNull
    public MenuFiller<CustomEnchantment> createFiller(@NotNull MenuViewer viewer) {
        MenuFiller.Builder autoFill = MenuFiller.builder((Filled)this);
        autoFill.setSlots(this.enchantSlots);
        autoFill.setItems(EnchantRegistry.getRegistered().stream().filter(Predicate.not(CustomEnchantment::isHiddenFromList)).sorted(Comparator.comparing(data -> NightMessage.stripTags((String)data.getDisplayName()))).toList());
        autoFill.setItemCreator(enchantmentData -> this.buildEnchantIcon((CustomEnchantment)enchantmentData, 1));
        autoFill.setItemClick(enchantmentData -> (viewer1, event) -> {
            if (!event.isLeftClick()) {
                return;
            }
            ItemStack currentItem = event.getCurrentItem();
            if (currentItem == null) {
                return;
            }
            int levelHas = PDCUtil.getInt((ItemStack)currentItem, (NamespacedKey)this.levelKey).orElse(1);
            if (++levelHas > enchantmentData.getDefinition().getMaxLevel()) {
                levelHas = 1;
            }
            ItemStack item = this.buildEnchantIcon((CustomEnchantment)enchantmentData, levelHas).getItemStack();
            PDCUtil.set((ItemStack)item, (NamespacedKey)this.levelKey, (int)levelHas);
            event.setCurrentItem(item);
        });
        return autoFill.build();
    }

    @NotNull
    private NightItem buildEnchantIcon(@NotNull CustomEnchantment enchant, int level) {
        ArrayList<String> conflicts = new ArrayList<String>();
        if (enchant.getDefinition().hasConflicts()) {
            for (String line : this.enchantLoreConflicts) {
                if (line.contains("%name%")) {
                    enchant.getDefinition().getExclusiveSet().stream().map(NightKey::key).map(NightKey::toBukkit).map(key -> (Enchantment)BukkitThing.getByKey((RegistryType)RegistryType.ENCHANTMENT, (NamespacedKey)key)).filter(Objects::nonNull).map(LangUtil::getSerializedName).forEach(conf -> conflicts.add(line.replace("%name%", (CharSequence)conf)));
                    continue;
                }
                conflicts.add(line);
            }
        }
        List charges = Replacer.create().replace("%amount%", () -> NumberUtil.format((double)enchant.getCharges().getMaxAmount(level))).replace("%item%", () -> ItemUtil.getNameSerialized((ItemStack)enchant.getFuel())).apply(enchant.isChargeable() ? this.enchantLoreCharges : Collections.emptyList());
        return this.enchantIcon.copy().hideAllComponents().setDisplayName(this.enchantName).setLore(this.enchantLoreMain).replacement(replacer -> replacer.replace(CHARGES, charges).replace(CONFLICTS, conflicts).replace(enchant.replacePlaceholders(level)));
    }

    public void loadConfiguration(@NotNull FileConfig config, @NotNull MenuLoader loader) {
        this.enchantIcon = (NightItem)ConfigValue.create((String)"Enchantment.Icon", (NightItem)new NightItem(Material.ENCHANTED_BOOK), (String[])new String[0]).read(config);
        this.enchantName = (String)ConfigValue.create((String)"Enchantment.Name", (String)Tags.LIGHT_YELLOW.wrap(Tags.BOLD.wrap("%enchantment_name% %enchantment_level%")), (String[])new String[0]).read(config);
        this.enchantLoreMain = (List)ConfigValue.create((String)"Enchantment.Lore.Main", (List)Lists.newList((Object[])new String[]{"%enchantment_description_replaced%", Tags.DARK_GRAY.wrap("(click to switch levels)"), "%empty-if-above%", Tags.LIGHT_YELLOW.wrap(Tags.BOLD.wrap("Info:")), Tags.LIGHT_YELLOW.wrap("\u25aa " + Tags.LIGHT_GRAY.wrap("Applies to: ") + "%enchantment_fit_item_types%"), Tags.LIGHT_YELLOW.wrap("\u25aa " + Tags.LIGHT_GRAY.wrap("Levels: ") + "%enchantment_level_min%" + Tags.LIGHT_GRAY.wrap(" - ") + "%enchantment_level_max%"), "%empty-if-below%", CHARGES, "%empty-if-below%", CONFLICTS}), (String[])new String[0]).read(config);
        this.enchantLoreConflicts = (List)ConfigValue.create((String)"Enchantment.Lore.Conflicts", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_RED.wrap(Tags.BOLD.wrap("Conflicts:")), Tags.LIGHT_RED.wrap("\u2718 ") + Tags.LIGHT_GRAY.wrap("%name%")}), (String[])new String[0]).read(config);
        this.enchantLoreCharges = (List)ConfigValue.create((String)"Enchantment.Lore.Charges", (List)Lists.newList((Object[])new String[]{Tags.LIGHT_YELLOW.wrap("\u25aa " + Tags.LIGHT_GRAY.wrap("Charges: ") + "%amount%\u26a1" + Tags.LIGHT_GRAY.wrap(" (" + Tags.WHITE.wrap("%item%") + ")"))}), (String[])new String[0]).read(config);
        this.enchantSlots = (int[])ConfigValue.create((String)"Enchantment.Slots", (int[])IntStream.range(0, 27).toArray(), (String[])new String[0]).read(config);
        loader.addDefaultItem(MenuItem.buildNextPage((Menu)this, (int)35));
        loader.addDefaultItem(MenuItem.buildPreviousPage((Menu)this, (int)27));
    }
}

