/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.manager.listener;

import java.util.HashMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.api.enchantment.CustomEnchantment;
import su.nightexpress.excellentenchants.config.Config;
import su.nightexpress.excellentenchants.enchantment.EnchantSettings;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.sound.VanillaSound;

public class AnvilListener
extends AbstractListener<EnchantsPlugin> {
    private final EnchantSettings settings;
    private final NamespacedKey rechargedKey;

    public AnvilListener(@NotNull EnchantsPlugin plugin, @NotNull EnchantSettings settings) {
        super((NightCorePlugin)plugin);
        this.settings = settings;
        this.rechargedKey = new NamespacedKey((Plugin)plugin, "item.recharged");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onAnvilRename(PrepareAnvilEvent event) {
        AnvilInventory inventory = event.getInventory();
        ItemStack first = inventory.getItem(0);
        ItemStack second = inventory.getItem(1);
        ItemStack result = event.getResult();
        if (first == null) {
            first = new ItemStack(Material.AIR);
        }
        if (second == null) {
            second = new ItemStack(Material.AIR);
        }
        if (result == null) {
            result = new ItemStack(Material.AIR);
        }
        if (this.handleRecharge(event, first, second)) {
            return;
        }
        this.anvilCombine(event, first, second, result);
    }

    private boolean anvilCombine(@NotNull PrepareAnvilEvent event, @NotNull ItemStack first, @NotNull ItemStack second, @NotNull ItemStack result) {
        int countItem;
        ItemStack merged = new ItemStack(result.getType().isAir() ? first : result);
        int countResult = EnchantsUtils.countCustomEnchantments(result);
        if (EnchantsUtils.isEnchantedBook(second)) {
            countItem = EnchantsUtils.countCustomEnchantments(first);
        } else if (first.getType() == second.getType()) {
            int countFirst = EnchantsUtils.countCustomEnchantments(first);
            int countSecond = EnchantsUtils.countCustomEnchantments(second);
            countItem = Math.max(countFirst, countSecond);
        } else {
            return false;
        }
        int limit = this.settings.getAnvilEnchantsLimit();
        if (countResult > countItem && (countItem >= limit || countResult > limit)) {
            event.setResult(null);
            return false;
        }
        HashMap chargesMap = new HashMap();
        EnchantsUtils.getCustomEnchantments(result).forEach((enchantment, level) -> {
            int chargesFirst = enchantment.getCharges(first);
            int chargesSecond = enchantment.getCharges(second);
            chargesMap.put(enchantment, chargesFirst + chargesSecond);
            enchantment.setCharges(merged, (int)level, chargesFirst + chargesSecond);
        });
        if (!chargesMap.isEmpty()) {
            event.setResult(merged);
            return true;
        }
        return false;
    }

    private boolean handleRecharge(@NotNull PrepareAnvilEvent event, @NotNull ItemStack first, @NotNull ItemStack second) {
        int count;
        if (!Config.isChargesEnabled()) {
            return false;
        }
        if (second.getType().isAir()) {
            return false;
        }
        HashMap<CustomEnchantment, Integer> chargable = new HashMap<CustomEnchantment, Integer>();
        EnchantsUtils.getCustomEnchantments(first).forEach((data, level) -> {
            if (data.isChargesFuel(second) && !data.isFullOfCharges(first)) {
                chargable.put((CustomEnchantment)data, (Integer)level);
            }
        });
        if (chargable.isEmpty()) {
            return false;
        }
        ItemStack recharged = new ItemStack(first);
        for (count = 0; count < second.getAmount() && !chargable.keySet().stream().allMatch(data -> data.isFullOfCharges(recharged)); ++count) {
            chargable.forEach((enchant, level) -> enchant.fuelCharges(recharged, (int)level));
        }
        PDCUtil.set((ItemStack)recharged, (NamespacedKey)this.rechargedKey, (int)count);
        event.setResult(recharged);
        ((EnchantsPlugin)this.plugin).runTask(() -> event.getView().setRepairCost(chargable.size()));
        return true;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onClickAnvil(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof AnvilInventory)) {
            return;
        }
        AnvilInventory anvilInventory = (AnvilInventory)inventory;
        InventoryView inventoryView = event.getView();
        if (!(inventoryView instanceof AnvilView)) {
            return;
        }
        AnvilView anvilView = (AnvilView)inventoryView;
        if (event.getRawSlot() != 2) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        int count = PDCUtil.getInt((ItemStack)item, (NamespacedKey)this.rechargedKey).orElse(0);
        if (count == 0) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (player.getLevel() < anvilView.getRepairCost()) {
            return;
        }
        player.setLevel(player.getLevel() - anvilView.getRepairCost());
        PDCUtil.remove((ItemStack)item, (NamespacedKey)this.rechargedKey);
        event.getView().setCursor(item);
        event.setCancelled(false);
        VanillaSound.of((Sound)Sound.BLOCK_ENCHANTMENT_TABLE_USE).play(player);
        ItemStack second = anvilInventory.getItem(1);
        if (second != null && !second.getType().isAir()) {
            second.setAmount(second.getAmount() - count);
        }
        anvilInventory.setItem(0, null);
        anvilInventory.setItem(2, null);
    }
}

