/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.manager;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.enchantment.CustomEnchantment;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.type.BlockEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.ProjectileEnchant;
import su.nightexpress.excellentenchants.api.item.ItemSetDefaults;
import su.nightexpress.excellentenchants.enchantment.EnchantCatalog;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.EnchantHolder;
import su.nightexpress.excellentenchants.enchantment.EnchantRegistry;
import su.nightexpress.excellentenchants.enchantment.EnchantSettings;
import su.nightexpress.excellentenchants.enchantment.EnchantedItem;
import su.nightexpress.excellentenchants.manager.EnchantUsage;
import su.nightexpress.excellentenchants.manager.block.TickedBlock;
import su.nightexpress.excellentenchants.manager.damage.Explosion;
import su.nightexpress.excellentenchants.manager.listener.AnvilListener;
import su.nightexpress.excellentenchants.manager.listener.EnchantListener;
import su.nightexpress.excellentenchants.manager.listener.GenericListener;
import su.nightexpress.excellentenchants.manager.listener.SlotListener;
import su.nightexpress.excellentenchants.manager.menu.EnchantsMenu;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.manager.AbstractManager;
import su.nightexpress.nightcore.manager.SimpeListener;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.Enums;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.Version;
import su.nightexpress.nightcore.util.bridge.RegistryType;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class EnchantManager
extends AbstractManager<EnchantsPlugin> {
    private final Map<AbstractArrow, Set<UniParticle>> arrowEffects = new ConcurrentHashMap<AbstractArrow, Set<UniParticle>>();
    private final Map<Location, TickedBlock> tickedBlocks = new HashMap<Location, TickedBlock>();
    private final Map<UUID, Explosion> explosions = new HashMap<UUID, Explosion>();
    private final EnchantSettings settings = new EnchantSettings();
    private final NamespacedKey entitySpawnKey;
    private final NamespacedKey blockEnchantKey;
    private EnchantsMenu enchantsMenu;

    public EnchantManager(@NotNull EnchantsPlugin plugin) {
        super((NightCorePlugin)plugin);
        this.entitySpawnKey = new NamespacedKey((Plugin)plugin, "entity.spawn_reason");
        this.blockEnchantKey = new NamespacedKey((Plugin)plugin, "block.enchant");
    }

    protected void onLoad() {
        this.settings.load(((EnchantsPlugin)this.plugin).getConfig());
        this.loadEnchants();
        this.enchantsMenu = new EnchantsMenu((EnchantsPlugin)this.plugin);
        this.addListener((SimpeListener)new GenericListener((EnchantsPlugin)this.plugin, this));
        this.addListener((SimpeListener)new AnvilListener((EnchantsPlugin)this.plugin, this.settings));
        this.addListener((SimpeListener)new EnchantListener((EnchantsPlugin)this.plugin, this));
        if (Version.isPaper()) {
            this.addListener((SimpeListener)new SlotListener((EnchantsPlugin)this.plugin, this));
        }
        this.addAsyncTask(this::tickArrowEffects, this.settings.getArrowEffectsTickInterval());
        if (!EnchantRegistry.PASSIVE.isEmpty()) {
            this.addTask(this::tickPassiveEnchants, this.settings.getPassiveEnchantsTickInterval());
        }
        this.addTask(this::tickBlocks, 1L);
    }

    protected void onShutdown() {
        this.restoreBlocks();
        if (this.enchantsMenu != null) {
            this.enchantsMenu.clear();
        }
        this.arrowEffects.clear();
        this.tickedBlocks.clear();
        this.explosions.clear();
    }

    private void loadEnchants() {
        EnchantCatalog.enabled().forEach(this::loadEnchant);
        ItemSetDefaults.clearAll();
        ((EnchantsPlugin)this.plugin).info("Loaded " + EnchantRegistry.getRegistered().size() + " enchantments.");
    }

    private boolean loadEnchant(@NotNull EnchantCatalog catalog) {
        String id = catalog.getId();
        CustomEnchantment registered = EnchantRegistry.getById(id);
        if (registered != null) {
            registered.load();
            return true;
        }
        Path file = Path.of(String.valueOf(((EnchantsPlugin)this.plugin).getDataFolder()) + "/enchants/", FileConfig.withExtension((String)id));
        if (!Files.exists(file, new LinkOption[0])) {
            ((EnchantsPlugin)this.plugin).error("No config file present for the '%s' enchantment.".formatted(id));
            return false;
        }
        Enchantment bukkitEnchant = (Enchantment)BukkitThing.getByKey((RegistryType)RegistryType.ENCHANTMENT, (NamespacedKey)catalog.getKey());
        if (bukkitEnchant == null) {
            ((EnchantsPlugin)this.plugin).error("No registered bukkit enchant found for '%s'.".formatted(id));
            return false;
        }
        EnchantContext context = new EnchantContext(id, bukkitEnchant, catalog.getDefinition(), catalog.getDistribution(), catalog.isCurse());
        CustomEnchantment enchantment = catalog.createEnchantment((EnchantsPlugin)this.plugin, this, file, context);
        enchantment.load();
        EnchantRegistry.registerEnchant(enchantment);
        return true;
    }

    public void updateCache(@NotNull LivingEntity entity, @NotNull EquipmentSlot slot, @Nullable ItemStack itemStack) {
        EnchantRegistry.getHolders().forEach(holder -> {
            if (!holder.isCacheable()) {
                return;
            }
            if (itemStack == null || itemStack.getType().isAir() || !EnchantsUtils.hasEnchantsAndNotABook(itemStack) || !EnchantsUtils.isValidSlotForEnchantEffects(itemStack, slot)) {
                holder.removeCache(entity, slot);
                return;
            }
            Map<CustomEnchantment, Integer> allEnchants = EnchantsUtils.getCustomEnchantments(itemStack);
            holder.updateCache(entity, slot, itemStack, allEnchants);
        });
    }

    public void clearCache(@NotNull LivingEntity entity) {
        EnchantRegistry.getHolders().forEach(holder -> {
            if (!holder.isCacheable()) {
                return;
            }
            holder.clearCache(entity);
        });
    }

    public void reCache(@NotNull LivingEntity entity) {
        this.clearCache(entity);
        EntityUtil.getEquippedItems((LivingEntity)entity).forEach((slot, itemStack) -> this.updateCache(entity, (EquipmentSlot)slot, (ItemStack)itemStack));
    }

    @NotNull
    public EnchantSettings getSettings() {
        return this.settings;
    }

    public void openEnchantsMenu(@NotNull Player player) {
        this.enchantsMenu.open(player);
    }

    public void addArrowEffect(@NotNull AbstractArrow arrow, @NotNull UniParticle particle) {
        this.arrowEffects.computeIfAbsent(arrow, k -> new HashSet()).add(particle);
    }

    public void removeArrowEffects(@NotNull AbstractArrow arrow) {
        this.arrowEffects.remove(arrow);
    }

    private void tickArrowEffects() {
        this.arrowEffects.keySet().removeIf(arrow -> !arrow.isValid() || arrow.isDead());
        this.arrowEffects.forEach((arrow, effects) -> effects.forEach(particle -> particle.play(arrow.getLocation(), 0.0, 0.0, 10)));
    }

    private void tickBlocks() {
        this.tickedBlocks.values().removeIf(tickedBlock -> {
            tickedBlock.tick();
            return tickedBlock.isDead();
        });
    }

    private void restoreBlocks() {
        this.tickedBlocks.values().forEach(TickedBlock::restore);
    }

    private void tickPassiveEnchants() {
        this.getPassiveEnchantEntities().forEach(entity -> this.handleInSlots((LivingEntity)entity, EntityUtil.EQUIPMENT_SLOTS, EnchantRegistry.PASSIVE, (item, enchant, level) -> enchant.onTrigger((LivingEntity)entity, item, level)));
    }

    @NotNull
    private Set<LivingEntity> getPassiveEnchantEntities() {
        HashSet<LivingEntity> entities = new HashSet<LivingEntity>(Players.getOnline());
        if (this.settings.isPassiveEnchantsAllowedForMobs()) {
            ((EnchantsPlugin)this.plugin).getServer().getWorlds().forEach(world -> entities.addAll(world.getLivingEntities()));
        }
        entities.removeIf(Entity::isDead);
        return entities;
    }

    public void addTickedBlock(@NotNull Block block, @NotNull Material origin, @NotNull Material transform, int lifeTime) {
        Location location = block.getLocation();
        TickedBlock tickedBlock = new TickedBlock(location, origin, lifeTime);
        this.tickedBlocks.put(location, tickedBlock);
        block.setType(transform);
    }

    public boolean removeTickedBlock(@NotNull Block block) {
        return this.removeTickedBlock(block.getLocation());
    }

    public boolean removeTickedBlock(@NotNull Location location) {
        TickedBlock tickedBlock = this.tickedBlocks.remove(location);
        if (tickedBlock == null) {
            return false;
        }
        tickedBlock.restore();
        return true;
    }

    public void setBlockEnchant(@NotNull ItemStack itemStack, @NotNull BlockEnchant enchant) {
        PDCUtil.set((ItemStack)itemStack, (NamespacedKey)this.blockEnchantKey, (String)enchant.getId());
    }

    @Nullable
    public BlockEnchant getBlockEnchant(@NotNull ItemStack itemStack) {
        String enchantId = PDCUtil.getString((ItemStack)itemStack, (NamespacedKey)this.blockEnchantKey).orElse(null);
        if (enchantId == null) {
            return null;
        }
        return EnchantRegistry.BLOCK.getEnchant(enchantId);
    }

    public void setSpawnReason(@NotNull Entity entity, @NotNull CreatureSpawnEvent.SpawnReason reason) {
        PDCUtil.set((PersistentDataHolder)entity, (NamespacedKey)this.entitySpawnKey, (String)reason.name());
    }

    @Nullable
    public CreatureSpawnEvent.SpawnReason getSpawnReason(@NotNull Entity entity) {
        String name = PDCUtil.getString((PersistentDataHolder)entity, (NamespacedKey)this.entitySpawnKey).orElse(null);
        return name == null ? null : (CreatureSpawnEvent.SpawnReason)Enums.get((String)name, CreatureSpawnEvent.SpawnReason.class);
    }

    public boolean createExplosion(@NotNull LivingEntity entity, @NotNull Location location, float power, boolean fire, boolean destroy, @NotNull Consumer<Explosion> consumer) {
        Explosion explosion = new Explosion(entity);
        consumer.accept(explosion);
        this.explosions.put(entity.getUniqueId(), explosion);
        return entity.getWorld().createExplosion(location, power, fire, destroy, (Entity)entity);
    }

    public void handleEnchantExplosion(@NotNull EntityExplodeEvent event, @NotNull LivingEntity entity) {
        Explosion explosion = this.explosions.get(entity.getUniqueId());
        if (explosion == null) {
            return;
        }
        explosion.handleExplosion(event);
        ((EnchantsPlugin)this.plugin).runTask(() -> this.explosions.remove(entity.getUniqueId()));
    }

    public void handleEnchantExplosionDamage(@NotNull EntityDamageByEntityEvent event, @NotNull LivingEntity entity) {
        Explosion explosion = this.explosions.get(entity.getUniqueId());
        if (explosion == null) {
            return;
        }
        explosion.handleDamage(event);
    }

    public <T extends CustomEnchantment> void handleInventoryEnchants(@NotNull Player player, @NotNull EnchantHolder<T> holder, @NotNull EnchantUsage<T> usage) {
        this.handleFully((LivingEntity)player, EnchantsUtils.getAll(player, holder), holder::getPriority, usage);
    }

    public <T extends CustomEnchantment> void handleItemEnchants(@NotNull LivingEntity entity, @NotNull ItemStack itemStack, @NotNull EnchantHolder<T> holder, @NotNull EnchantUsage<T> usage) {
        HashMap<ItemStack, Map<T, Integer>> enchants = new HashMap<ItemStack, Map<T, Integer>>();
        enchants.put(itemStack, EnchantsUtils.getCustomEnchantments(itemStack, holder));
        this.handleFully(entity, enchants, holder::getPriority, usage);
    }

    public <P extends AbstractArrow, T extends ProjectileEnchant<P>> void handleArrowEnchants(@NotNull P projectile, @NotNull EnchantHolder<T> holder, @NotNull EnchantUsage<T> usage) {
        ItemStack bow = projectile.getWeapon();
        if (bow == null || !EnchantsUtils.hasEnchantsAndNotABook(bow)) {
            return;
        }
        HashMap<ItemStack, Map<T, Integer>> enchants = new HashMap<ItemStack, Map<T, Integer>>();
        enchants.put(bow, EnchantsUtils.getArrowEnchants(projectile, holder));
        this.handleDirect(enchants, holder::getPriority, usage);
    }

    public <T extends CustomEnchantment> void handleInSlot(@NotNull LivingEntity entity, @NotNull EquipmentSlot slot, @NotNull EnchantHolder<T> holder, @NotNull EnchantUsage<T> usage) {
        this.handleInSlots(entity, new EquipmentSlot[]{slot}, holder, usage);
    }

    public <T extends CustomEnchantment> void handleInSlots(@NotNull LivingEntity entity, @NotNull EquipmentSlot[] slots, @NotNull EnchantHolder<T> holder, @NotNull EnchantUsage<T> usage) {
        HashMap<ItemStack, Map<T, Integer>> enchantMap = new HashMap<ItemStack, Map<T, Integer>>();
        boolean noCache = entity.getType() != EntityType.PLAYER || !holder.isCacheable() || Version.isSpigot();
        for (EquipmentSlot slot : slots) {
            if (noCache || slot == EquipmentSlot.HAND) {
                ItemStack itemStack = EntityUtil.getItemInSlot((LivingEntity)entity, (EquipmentSlot)slot);
                if (itemStack == null || itemStack.getType().isAir() || !EnchantsUtils.hasEnchantsAndNotABook(itemStack) || !EnchantsUtils.isValidSlotForEnchantEffects(itemStack, slot)) continue;
                enchantMap.put(itemStack, EnchantsUtils.getCustomEnchantments(itemStack, holder));
                continue;
            }
            EnchantedItem<T> enchantedItem = holder.getCached(entity, slot);
            if (enchantedItem == null) continue;
            enchantMap.put(enchantedItem.getItemStack(), enchantedItem.getEnchants());
        }
        this.handleFully(entity, enchantMap, holder::getPriority, usage);
    }

    public <T extends CustomEnchantment> void handleFully(@NotNull LivingEntity entity, @NotNull Map<ItemStack, Map<T, Integer>> enchantMap, @NotNull Function<T, EnchantPriority> priority, @NotNull EnchantUsage<T> usage) {
        this.handleDirect(enchantMap, priority, (itemStack, enchant, level) -> {
            if (this.settings.isEnchantDisabledInWorld(entity.getWorld(), enchant)) {
                return false;
            }
            if (enchant.isOutOfCharges(itemStack)) {
                return false;
            }
            if (enchant.hasComponent(EnchantComponent.PERIODIC) && !enchant.isTriggerTime(entity)) {
                return false;
            }
            if (enchant.hasComponent(EnchantComponent.PROBABILITY) && !enchant.testTriggerChance(level)) {
                return false;
            }
            if (!usage.useEnchant(itemStack, enchant, level)) {
                return false;
            }
            enchant.consumeCharges(itemStack, level);
            return true;
        });
    }

    public <T extends CustomEnchantment> void handleDirect(@NotNull Map<ItemStack, Map<T, Integer>> enchantMap, @NotNull Function<T, EnchantPriority> priority, @NotNull EnchantUsage<T> usage) {
        enchantMap.forEach((itemStack, enchants) -> enchants.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((EnchantPriority)((Object)((Object)((Object)priority.apply((CustomEnchantment)entry.getKey()))))).ordinal())).forEach(entry -> {
            CustomEnchantment enchant = (CustomEnchantment)entry.getKey();
            int level = (Integer)entry.getValue();
            usage.useEnchant((ItemStack)itemStack, (Object)enchant, level);
        }));
    }
}

