/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.weapon;

import java.nio.file.Path;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.AttackEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class ThunderEnchant
extends GameEnchantment
implements AttackEnchant {
    private boolean thunderstormOnly;
    private Modifier damageModifier;

    public ThunderEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(5.0, 2.0));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.thunderstormOnly = (Boolean)ConfigValue.create((String)"Thunder.During_Thunderstorm_Only", (boolean)false, (String[])new String[]{"Sets whether or not enchantment will have effect only during thunderstorm in the world."}).read(config);
        this.damageModifier = Modifier.load(config, "Thunder.Damage_Modifier", Modifier.addictive(1.25).perLevel(0.25).capacity(1000.0), "Sets additional damage caused by enchantment's effect.");
        this.addPlaceholder("%damage%", level -> NumberUtil.format((double)this.getDamage((int)level)));
    }

    public boolean isDuringThunderstormOnly() {
        return this.thunderstormOnly;
    }

    public double getDamage(int level) {
        return this.damageModifier.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getAttackPriority() {
        return EnchantPriority.LOW;
    }

    @Override
    public boolean onAttack(@NotNull EntityDamageByEntityEvent event, @NotNull LivingEntity damager, @NotNull LivingEntity victim, @NotNull ItemStack weapon, int level) {
        if (this.isDuringThunderstormOnly() && !victim.getWorld().isThundering()) {
            return false;
        }
        if (victim.getLocation().getBlock().getLightFromSky() != 15) {
            return false;
        }
        Location location = victim.getLocation();
        victim.getWorld().strikeLightningEffect(location);
        if (this.hasVisualEffects()) {
            Block block = location.getBlock().getRelative(BlockFace.DOWN);
            Location center = LocationUtil.setCenter3D((Location)location.clone());
            UniParticle.blockCrack((Material)block.getType()).play(center, 0.5, 0.1, 100);
            UniParticle.of((Particle)Particle.ELECTRIC_SPARK).play(center, 0.75, 0.05, 120);
        }
        event.setDamage(event.getDamage() + this.getDamage(level));
        return true;
    }
}

