/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.weapon;

import java.nio.file.Path;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.type.AttackEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.NumberUtil;

public class TemperEnchant
extends GameEnchantment
implements AttackEnchant {
    private Modifier damageAmount;
    private Modifier damageStep;

    public TemperEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.damageAmount = Modifier.load(config, "Temper.Damage_Amount", Modifier.addictive(0.0).perLevel(5.0).capacity(100.0), "Extra damage (in %)");
        this.damageStep = Modifier.load(config, "Settings.Damage.Step", Modifier.addictive(0.5), "Damage will be increased for every X entity's health points missing. Where X is this value.", "By default increases damage by 5% for every 0.5 HP missing.");
        this.addPlaceholder("%amount%", level -> NumberUtil.format((double)this.getDamageAmount((int)level)));
        this.addPlaceholder("%radius%", level -> NumberUtil.format((double)this.getDamageStep((int)level)));
    }

    public double getDamageAmount(int level) {
        return this.damageAmount.getValue(level);
    }

    public double getDamageStep(int level) {
        return this.damageStep.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getAttackPriority() {
        return EnchantPriority.LOWEST;
    }

    @Override
    public boolean onAttack(@NotNull EntityDamageByEntityEvent event, @NotNull LivingEntity damager, @NotNull LivingEntity victim, @NotNull ItemStack weapon, int level) {
        double maxHealth;
        double health = damager.getHealth();
        if (health >= (maxHealth = EntityUtil.getAttributeValue((LivingEntity)damager, (Attribute)Attribute.MAX_HEALTH))) {
            return false;
        }
        double missingHealth = maxHealth - health;
        double step = this.getDamageStep(level);
        if (step == 0.0 || missingHealth < step) {
            return false;
        }
        double steps = Math.floor(missingHealth / step);
        if (steps == 0.0) {
            return false;
        }
        double percent = 1.0 + this.getDamageAmount(level) * steps / 100.0;
        event.setDamage(event.getDamage() * percent);
        return true;
    }
}

