/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.weapon;

import java.nio.file.Path;
import org.bukkit.Particle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Trident;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.entity.ProjectileLaunchEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.ArrowEffects;
import su.nightexpress.excellentenchants.api.enchantment.type.TridentEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.NumberUtil;

public class InfernusEnchant
extends GameEnchantment
implements TridentEnchant {
    private Modifier fireTicks;

    public InfernusEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.ARROW, ArrowEffects.basic(Particle.FLAME));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.fireTicks = Modifier.load(config, "Infernus.Fire_Ticks", Modifier.addictive(60.0).perLevel(20.0).capacity(120.0), "Sets for how long (in ticks) entity will be ignited on hit. 20 ticks = 1 second.");
        this.addPlaceholder("%time%", level -> NumberUtil.format((double)((double)this.getFireTicks((int)level) / 20.0)));
    }

    public int getFireTicks(int level) {
        return (int)this.fireTicks.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getLaunchPriority() {
        return EnchantPriority.NORMAL;
    }

    @Override
    public boolean onLaunch(@NotNull ProjectileLaunchEvent event, @NotNull LivingEntity shooter, @NotNull ItemStack trident, int level) {
        event.getEntity().setFireTicks(Integer.MAX_VALUE);
        return true;
    }

    @Override
    public void onHit(@NotNull ProjectileHitEvent event, @NotNull LivingEntity shooter, @NotNull Trident projectile, int level) {
        Entity entity = event.getHitEntity();
        if (entity == null) {
            return;
        }
        int ticks = this.getFireTicks(level);
        entity.setFireTicks(ticks);
    }

    @Override
    public void onDamage(@NotNull EntityDamageByEntityEvent event, @NotNull LivingEntity shooter, @NotNull LivingEntity victim, @NotNull Trident projectile, int level) {
    }
}

