/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.weapon;

import java.nio.file.Path;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.AttackEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigType;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.Randomizer;
import su.nightexpress.nightcore.util.sound.VanillaSound;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class CutterEnchant
extends GameEnchantment
implements AttackEnchant {
    private final ConfigProperty<Boolean> ignoreMythicMobs = ConfigProperty.of((ConfigType)ConfigTypes.BOOLEAN, (String)"Cutter.Ignore-MythicMobs", (Object)false, (String[])new String[]{"Whether enchantment has effect on mobs from the MythicMobs plugin."});
    private Modifier durabilityReduction;
    private boolean allowPlayers;
    private boolean allowMobs;

    public CutterEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(2.0, 1.0));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.durabilityReduction = Modifier.load(config, "Cutter.Durability_Reduction", Modifier.addictive(0.0).perLevel(0.01).capacity(1.0), "Amount (in percent) of how much item durability will be reduced.");
        this.allowPlayers = (Boolean)ConfigValue.create((String)"Cutter.Allow_Players", (boolean)true, (String[])new String[]{"Sets whether or not this enchantment will have effect on players."}).read(config);
        this.allowMobs = (Boolean)ConfigValue.create((String)"Cutter.Allow_Mobs", (boolean)true, (String[])new String[]{"Sets whether or not this enchantment will have effect on mobs."}).read(config);
        this.ignoreMythicMobs.loadWithDefaults(config);
        this.addPlaceholder("%damage%", level -> NumberUtil.format((double)(this.getDurabilityReduction((int)level) * 100.0)));
    }

    public final double getDurabilityReduction(int level) {
        return this.durabilityReduction.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getAttackPriority() {
        return EnchantPriority.NORMAL;
    }

    @Override
    public boolean onAttack(@NotNull EntityDamageByEntityEvent event, @NotNull LivingEntity damager, @NotNull LivingEntity victim, @NotNull ItemStack weapon, int level) {
        EntityEquipment equipment = victim.getEquipment();
        if (equipment == null) {
            return false;
        }
        ItemStack[] armor = equipment.getArmorContents();
        if (armor.length == 0) {
            return false;
        }
        boolean isPlayer = victim instanceof Player;
        if (isPlayer && !this.allowPlayers || !isPlayer && !this.allowMobs) {
            return false;
        }
        if (!((Boolean)this.ignoreMythicMobs.get()).booleanValue() && EnchantsUtils.isMythicMob((Entity)victim)) {
            return false;
        }
        int index = Randomizer.nextInt((int)armor.length);
        ItemStack itemCut = armor[index];
        if (itemCut == null || itemCut.getType().isAir() || itemCut.getType().getMaxDurability() == 0) {
            return false;
        }
        ItemMeta meta = itemCut.getItemMeta();
        if (!(meta instanceof Damageable)) {
            return false;
        }
        Damageable damageable = (Damageable)meta;
        damageable.setDamage((int)((double)itemCut.getType().getMaxDurability() * this.getDurabilityReduction(level)));
        itemCut.setItemMeta((ItemMeta)damageable);
        armor[index] = null;
        equipment.setArmorContents(armor);
        Item drop = victim.getWorld().dropItemNaturally(victim.getLocation(), itemCut);
        drop.setPickupDelay(50);
        drop.getVelocity().multiply(3.0);
        if (this.hasVisualEffects()) {
            UniParticle.itemCrack((ItemStack)itemCut).play(victim.getEyeLocation(), 0.25, 0.15, 30);
            VanillaSound.of((Sound)Sound.ENTITY_ITEM_BREAK).play(victim.getLocation());
        }
        return true;
    }
}

