/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.weapon;

import java.nio.file.Path;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Piglin;
import org.bukkit.entity.Player;
import org.bukkit.entity.ZombieVillager;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.AttackEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class CureEnchant
extends GameEnchantment
implements AttackEnchant {
    private static final Set<EntityType> CUREABLE = Lists.newSet((Object[])new EntityType[]{EntityType.ZOMBIFIED_PIGLIN, EntityType.ZOMBIE_VILLAGER});

    public CureEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(10.0, 10.0));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
    }

    @Override
    @NotNull
    public EnchantPriority getAttackPriority() {
        return EnchantPriority.MONITOR;
    }

    @Override
    public boolean onAttack(@NotNull EntityDamageByEntityEvent event, @NotNull LivingEntity damager, @NotNull LivingEntity victim, @NotNull ItemStack weapon, int level) {
        if (!CUREABLE.contains(victim.getType())) {
            return false;
        }
        if (!(damager instanceof Player)) {
            return false;
        }
        Player player = (Player)damager;
        if (event.getFinalDamage() < victim.getHealth()) {
            return false;
        }
        event.setCancelled(true);
        if (this.hasVisualEffects()) {
            UniParticle.of((Particle)Particle.CLOUD).play(victim.getEyeLocation(), 0.25, 0.1, 30);
        }
        if (victim instanceof PigZombie) {
            victim.getWorld().spawn(victim.getLocation(), Piglin.class);
            victim.remove();
        } else if (victim instanceof ZombieVillager) {
            ZombieVillager zombieVillager = (ZombieVillager)victim;
            zombieVillager.setConversionTime(1);
            zombieVillager.setConversionPlayer((OfflinePlayer)player);
        }
        return true;
    }
}

