/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.universal;

import java.nio.file.Path;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.DurabilityEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.sound.VanillaSound;

public class RestoreEnchant
extends GameEnchantment
implements DurabilityEnchant {
    private Modifier amount;

    public RestoreEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(20.0, 5.0));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.amount = Modifier.load(config, "Restore.Amount", Modifier.addictive(15.0).perLevel(5.0).capacity(100.0), "Amount of durability (in percent of item max) to be restored.");
        this.addPlaceholder("%amount%", level -> NumberUtil.format((double)this.getAmount((int)level)));
    }

    public double getAmount(int level) {
        return this.amount.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getItemDamagePriority() {
        return EnchantPriority.MONITOR;
    }

    @Override
    public boolean onItemDamage(@NotNull PlayerItemDamageEvent event, @NotNull Player player, @NotNull ItemStack itemStack, int level) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof Damageable)) {
            return false;
        }
        Damageable damageable = (Damageable)itemMeta;
        int damage = event.getDamage();
        short maxDurability = itemStack.getType().getMaxDurability();
        if (damageable.getDamage() + damage < maxDurability) {
            return false;
        }
        event.setCancelled(true);
        double damagePercent = 100.0 - this.getAmount(level);
        int restoredDamage = (int)((double)maxDurability * (damagePercent / 100.0));
        damageable.setDamage(restoredDamage);
        damageable.removeEnchant(this.getBukkitEnchantment());
        itemStack.setItemMeta((ItemMeta)damageable);
        if (this.hasVisualEffects()) {
            VanillaSound.of((Sound)Sound.ITEM_TOTEM_USE).play(event.getPlayer());
        }
        return true;
    }
}

