/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.tool;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.type.MiningEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.BukkitThing;

public class VeinminerEnchant
extends GameEnchantment
implements MiningEnchant {
    private static final BlockFace[] AREA = new BlockFace[]{BlockFace.UP, BlockFace.DOWN, BlockFace.EAST, BlockFace.WEST, BlockFace.SOUTH, BlockFace.NORTH};
    private Modifier blocksLimit;
    private Set<Material> affectedBlocks;
    private boolean disableOnCrouch;

    public VeinminerEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.disableOnCrouch = (Boolean)ConfigValue.create((String)"Veinminer.Disable_On_Crouch", (boolean)true, (String[])new String[]{"Sets whether or not enchantment will have no effect when crouching."}).read(config);
        this.blocksLimit = Modifier.load(config, "Veinminer.Block_Limit", Modifier.addictive(4.0).perLevel(1.0).capacity(16.0), "Max. possible amount of blocks to be mined at the same time.");
        this.affectedBlocks = (Set)ConfigValue.forSet((String)"Veinminer.Block_List", BukkitThing::getMaterial, (cfg, path, set) -> cfg.set(path, set.stream().map(Enum::name).toList()), () -> {
            HashSet<Material> set = new HashSet<Material>();
            set.addAll(Tag.COAL_ORES.getValues());
            set.addAll(Tag.COPPER_ORES.getValues());
            set.addAll(Tag.DIAMOND_ORES.getValues());
            set.addAll(Tag.EMERALD_ORES.getValues());
            set.addAll(Tag.GOLD_ORES.getValues());
            set.addAll(Tag.IRON_ORES.getValues());
            set.addAll(Tag.LAPIS_ORES.getValues());
            set.addAll(Tag.REDSTONE_ORES.getValues());
            set.add(Material.NETHER_GOLD_ORE);
            set.add(Material.NETHER_QUARTZ_ORE);
            return set;
        }, (String[])new String[]{"List of blocks affected by this enchantment."}).read(config);
        this.addPlaceholder("%amount%", level -> String.valueOf(this.getBlocksLimit((int)level)));
    }

    @NotNull
    public Set<Material> getAffectedBlocks() {
        return this.affectedBlocks;
    }

    public int getBlocksLimit(int level) {
        return (int)this.blocksLimit.getValue(level);
    }

    @NotNull
    private Set<Block> getNearby(@NotNull Block block) {
        return Stream.of(AREA).map(arg_0 -> ((Block)block).getRelative(arg_0)).filter(blockAdded -> blockAdded.getType() == block.getType()).collect(Collectors.toSet());
    }

    private void vein(@NotNull Player player, @NotNull Block source, int level) {
        HashSet<Block> ores = new HashSet<Block>();
        HashSet<Block> prepare = new HashSet<Block>(this.getNearby(source));
        int limit = Math.min(this.getBlocksLimit(level), 30);
        if (limit < 0) {
            return;
        }
        while (ores.addAll(prepare) && ores.size() < limit) {
            HashSet nearby = new HashSet();
            prepare.forEach(prepared -> nearby.addAll(this.getNearby((Block)prepared)));
            prepare.clear();
            prepare.addAll(nearby);
        }
        ores.remove(source);
        ores.forEach(ore -> EnchantsUtils.safeBusyBreak(player, ore));
    }

    @Override
    @NotNull
    public EnchantPriority getBreakPriority() {
        return EnchantPriority.LOWEST;
    }

    @Override
    public boolean onBreak(@NotNull BlockBreakEvent event, @NotNull LivingEntity entity, @NotNull ItemStack tool, int level) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (EnchantsUtils.isBusy()) {
            return false;
        }
        if (this.disableOnCrouch && player.isSneaking()) {
            return false;
        }
        Block block = event.getBlock();
        if (block.getDrops(tool, (Entity)player).isEmpty()) {
            return false;
        }
        if (!this.getAffectedBlocks().contains(block.getType())) {
            return false;
        }
        this.vein(player, block, level);
        return true;
    }
}

