/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.tool;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.enchantment.type.MiningEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.Lists;

public class TunnelEnchant
extends GameEnchantment
implements MiningEnchant {
    private static final int[][] MINING_COORD_OFFSETS = new int[][]{{0, 0}, {0, -1}, {-1, 0}, {0, 1}, {1, 0}, {-1, -1}, {-1, 1}, {1, -1}, {1, 1}};
    private static final Set<Material> INTERACTABLE_BLOCKS = new HashSet<Material>();
    private boolean disableOnSneak;

    public TunnelEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.disableOnSneak = (Boolean)ConfigValue.create((String)"Tunnel.Disable_On_Crouch", (boolean)true, (String[])new String[]{"Sets whether or not enchantment will have no effect when crouching."}).read(config);
    }

    @Override
    @NotNull
    public EnchantPriority getBreakPriority() {
        return EnchantPriority.LOWEST;
    }

    @Override
    public boolean onBreak(@NotNull BlockBreakEvent event, @NotNull LivingEntity entity, @NotNull ItemStack item, int level) {
        Block adjacentBlock;
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (EnchantsUtils.isBusy()) {
            return false;
        }
        if (this.disableOnSneak && player.isSneaking()) {
            return false;
        }
        Block block = event.getBlock();
        if (block.getType().isInteractable() && !INTERACTABLE_BLOCKS.contains(block.getType())) {
            return false;
        }
        if (block.getDrops(item).isEmpty()) {
            return false;
        }
        List lastTwoTargetBlocks = player.getLastTwoTargetBlocks(Lists.newSet((Object[])new Material[]{Material.AIR, Material.WATER, Material.LAVA}), 10);
        if (lastTwoTargetBlocks.size() != 2 || !((Block)lastTwoTargetBlocks.get(1)).getType().isOccluding()) {
            return false;
        }
        Block targetBlock = (Block)lastTwoTargetBlocks.get(1);
        BlockFace dir = targetBlock.getFace(adjacentBlock = (Block)lastTwoTargetBlocks.get(0));
        boolean isZ = dir == BlockFace.EAST || dir == BlockFace.WEST;
        int blocksBroken = 1;
        if (level == 1) {
            blocksBroken = 2;
        } else if (level == 2) {
            blocksBroken = 5;
        } else if (level >= 3) {
            blocksBroken = 9;
        }
        for (int i = 0; i < blocksBroken && !item.getType().isAir(); ++i) {
            Material addType;
            int xAdd = MINING_COORD_OFFSETS[i][0];
            int zAdd = MINING_COORD_OFFSETS[i][1];
            Block blockAdd = dir == BlockFace.UP || dir == BlockFace.DOWN ? block.getLocation().clone().add((double)xAdd, 0.0, (double)zAdd).getBlock() : block.getLocation().clone().add(isZ ? 0.0 : (double)xAdd, (double)zAdd, isZ ? (double)xAdd : 0.0).getBlock();
            if (blockAdd.equals((Object)block) || blockAdd.getDrops(item).isEmpty() || blockAdd.isLiquid() || (addType = blockAdd.getType()).isInteractable() && !INTERACTABLE_BLOCKS.contains(addType) || addType == Material.BEDROCK || addType == Material.END_PORTAL || addType == Material.END_PORTAL_FRAME || addType == Material.OBSIDIAN && addType != block.getType()) continue;
            EnchantsUtils.safeBusyBreak(player, blockAdd);
        }
        return true;
    }

    static {
        INTERACTABLE_BLOCKS.add(Material.REDSTONE_ORE);
        INTERACTABLE_BLOCKS.add(Material.DEEPSLATE_REDSTONE_ORE);
    }
}

