/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.tool;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.Nameable;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.enchantment.type.BlockDropEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.BlockEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.placeholder.PlaceholderContext;

public class SilkChestEnchant
extends GameEnchantment
implements BlockDropEnchant,
BlockEnchant {
    private final NamespacedKey chestNameKey;
    private String chestName;
    private List<String> chestLore;

    public SilkChestEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.chestNameKey = new NamespacedKey((Plugin)plugin, "silkchest.original_name");
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.chestName = (String)ConfigValue.create((String)"SilkChest.Name", (String)"%name% (%amount% items)", (String[])new String[]{"Chest item display name.", "Use '%amount%' for items amount."}).read(config);
        this.chestLore = (List)ConfigValue.create((String)"SilkChest.Lore", new ArrayList(), (String[])new String[]{"Chest item lore.", "Use '%amount%' for items amount."}).read(config);
    }

    @NotNull
    public ItemStack getSilkChest(@NotNull Chest originChest) {
        ItemStack chestStack = new ItemStack(originChest.getType());
        ItemUtil.editMeta((ItemStack)chestStack, BlockStateMeta.class, stateMeta -> {
            String originName = EntityUtil.getNameSerialized((Nameable)originChest);
            Chest chestItem = (Chest)stateMeta.getBlockState();
            chestItem.getBlockInventory().setContents(originChest.getBlockInventory().getContents());
            chestItem.update(true);
            stateMeta.setBlockState((BlockState)chestItem);
            PlaceholderContext placeholderContext = PlaceholderContext.builder().with("%name%", () -> EntityUtil.getNameSerialized((Nameable)originChest)).with("%amount%", () -> String.valueOf(Stream.of(chestItem.getBlockInventory().getContents()).filter(i -> i != null && !i.getType().isAir()).count())).build();
            PDCUtil.set((PersistentDataHolder)stateMeta, (NamespacedKey)this.chestNameKey, (String)originName);
            ItemUtil.setCustomName((ItemMeta)stateMeta, (String)placeholderContext.apply(this.chestName));
            ItemUtil.setLore((ItemMeta)stateMeta, (List)placeholderContext.apply(this.chestLore));
        });
        this.manager.setBlockEnchant(chestStack, this);
        return chestStack;
    }

    @Override
    @NotNull
    public EnchantPriority getDropPriority() {
        return EnchantPriority.LOW;
    }

    @Override
    public boolean canPlaceInContainers() {
        return false;
    }

    @Override
    public boolean onDrop(@NotNull BlockDropItemEvent event, @NotNull LivingEntity player, @NotNull ItemStack itemStack, int level) {
        BlockState state = event.getBlockState();
        if (!(state instanceof Chest)) {
            return false;
        }
        Chest chest = (Chest)state;
        Material blockType = state.getType();
        List drops = event.getItems();
        Item originalContainerItem = drops.stream().filter(drop -> drop.getItemStack().getType() == blockType && drop.getItemStack().getAmount() == 1).findFirst().orElse(null);
        if (originalContainerItem == null) {
            return false;
        }
        if (drops.size() == 1) {
            return false;
        }
        drops.remove(originalContainerItem);
        chest.getBlockInventory().addItem(drops.stream().map(Item::getItemStack).toList().toArray(new ItemStack[0]));
        drops.clear();
        EnchantsUtils.populateResource(event, this.getSilkChest(chest));
        chest.getBlockInventory().clear();
        return true;
    }

    @Override
    public void onPlace(@NotNull BlockPlaceEvent event, @NotNull Player player, @NotNull Block block, @NotNull ItemStack itemStack) {
        BlockState state = block.getState();
        if (!(state instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)state;
        String name = PDCUtil.getString((ItemStack)itemStack, (NamespacedKey)this.chestNameKey).orElse(null);
        EntityUtil.setCustomName((Nameable)chest, (String)name);
        chest.update(true);
    }
}

