/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.tool;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.InteractEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.MiningEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.sound.VanillaSound;

public class ReplanterEnchant
extends GameEnchantment
implements InteractEnchant,
MiningEnchant {
    private boolean replantOnRightClick;
    private boolean replantOnPlantBreak;
    private static final Map<Material, Material> CROP_MAP = new HashMap<Material, Material>();

    public ReplanterEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.oneHundred());
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.replantOnRightClick = (Boolean)ConfigValue.create((String)"Replanter.On_Right_Click", (boolean)true, (String[])new String[]{"When 'true', player will be able to replant crops when right-clicking farmland blocks."}).read(config);
        this.replantOnPlantBreak = (Boolean)ConfigValue.create((String)"Replanter.On_Plant_Break", (boolean)true, (String[])new String[]{"When 'true', crops will be automatically replanted when player break plants with enchanted tool in hand."}).read(config);
    }

    public boolean isReplantOnPlantBreak() {
        return this.replantOnPlantBreak;
    }

    public boolean isReplantOnRightClick() {
        return this.replantOnRightClick;
    }

    private boolean takeSeeds(@NotNull Player player, @NotNull Material material) {
        int slot = player.getInventory().first(material);
        if (slot < 0) {
            return false;
        }
        ItemStack seed = player.getInventory().getItem(slot);
        if (seed == null || seed.getType().isAir()) {
            return false;
        }
        seed.setAmount(seed.getAmount() - 1);
        return true;
    }

    @Override
    @NotNull
    public EnchantPriority getInteractPriority() {
        return EnchantPriority.HIGHEST;
    }

    @Override
    @NotNull
    public EnchantPriority getBreakPriority() {
        return EnchantPriority.NORMAL;
    }

    @Override
    public boolean onInteract(@NotNull PlayerInteractEvent event, @NotNull LivingEntity entity, @NotNull ItemStack item, int level) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (!this.isReplantOnRightClick()) {
            return false;
        }
        if (event.getHand() != EquipmentSlot.HAND) {
            return false;
        }
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return false;
        }
        ItemStack off = player.getInventory().getItemInOffHand();
        if (!off.getType().isAir() && CROP_MAP.containsKey(off.getType())) {
            return false;
        }
        Block blockGround = event.getClickedBlock();
        if (blockGround == null) {
            return false;
        }
        if (blockGround.getType() != Material.FARMLAND && blockGround.getType() != Material.SOUL_SAND) {
            return false;
        }
        Block blockPlant = blockGround.getRelative(BlockFace.UP);
        if (!blockPlant.isEmpty()) {
            return false;
        }
        for (Map.Entry<Material, Material> entry : CROP_MAP.entrySet()) {
            Material seed = entry.getKey();
            if ((seed != Material.NETHER_WART || blockGround.getType() != Material.SOUL_SAND) && (seed == Material.NETHER_WART || blockGround.getType() != Material.FARMLAND) || !this.takeSeeds(player, seed)) continue;
            VanillaSound.of((Sound)(seed == Material.NETHER_WART ? Sound.ITEM_NETHER_WART_PLANT : Sound.ITEM_CROP_PLANT)).play(player);
            player.swingMainHand();
            blockPlant.setType(entry.getValue());
            break;
        }
        return true;
    }

    @Override
    public boolean onBreak(@NotNull BlockBreakEvent event, @NotNull LivingEntity entity, @NotNull ItemStack item, int level) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (!this.isReplantOnPlantBreak()) {
            return false;
        }
        Block blockPlant = event.getBlock();
        if (!CROP_MAP.containsKey(blockPlant.getBlockData().getPlacementMaterial())) {
            return false;
        }
        BlockData dataPlant = blockPlant.getBlockData();
        if (!(dataPlant instanceof Ageable)) {
            return false;
        }
        Ageable plant = (Ageable)dataPlant;
        if (this.takeSeeds(player, dataPlant.getPlacementMaterial())) {
            this.plugin.runTask(() -> {
                blockPlant.setType(plant.getMaterial());
                plant.setAge(0);
                blockPlant.setBlockData((BlockData)plant);
            });
        }
        return true;
    }

    static {
        CROP_MAP.put(Material.WHEAT_SEEDS, Material.WHEAT);
        CROP_MAP.put(Material.BEETROOT_SEEDS, Material.BEETROOTS);
        CROP_MAP.put(Material.MELON_SEEDS, Material.MELON_STEM);
        CROP_MAP.put(Material.PUMPKIN_SEEDS, Material.PUMPKIN_STEM);
        CROP_MAP.put(Material.POTATO, Material.POTATOES);
        CROP_MAP.put(Material.CARROT, Material.CARROTS);
        CROP_MAP.put(Material.NETHER_WART, Material.NETHER_WART);
    }
}

