/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.tool;

import java.nio.file.Path;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.MiningEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.NumberUtil;

public class BlastMiningEnchant
extends GameEnchantment
implements MiningEnchant {
    private Modifier explosionPower;
    private double minBlockStrength;

    public BlastMiningEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(0.0, 10.0));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.explosionPower = Modifier.load(config, "BlastMining.Explosion_Power", Modifier.addictive(3.0).perLevel(0.75).capacity(8.0), "Explosion power. The more power = the more blocks (area) to explode.");
        this.minBlockStrength = (Double)ConfigValue.create((String)"BlastMining.Min_Block_Strength", (double)1.3, (String[])new String[]{"Minimal block strength value for the enchantment to have effect.", "Block strength value is how long it takes to break the block by a hand.", "For example, a Stone has 3.0 strength."}).read(config);
        this.addPlaceholder("%radius%", level -> NumberUtil.format((double)this.getExplosionPower((int)level)));
    }

    public double getExplosionPower(int level) {
        return this.explosionPower.getValue(level);
    }

    private boolean isHardEnough(@NotNull Block block) {
        float strength = block.getType().getHardness();
        return (double)strength >= this.minBlockStrength;
    }

    @Override
    @NotNull
    public EnchantPriority getBreakPriority() {
        return EnchantPriority.LOWEST;
    }

    @Override
    public boolean onBreak(@NotNull BlockBreakEvent event, @NotNull LivingEntity entity, @NotNull ItemStack item, int level) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (EnchantsUtils.isBusy()) {
            return false;
        }
        Block block = event.getBlock();
        if (!this.isHardEnough(block)) {
            return false;
        }
        float power = (float)this.getExplosionPower(level);
        return this.plugin.getEnchantManager().createExplosion((LivingEntity)player, block.getLocation(), power, false, true, explosion -> {
            explosion.setOnDamage(damageEvent -> damageEvent.setCancelled(true));
            explosion.setOnExplode(explodeEvent -> {
                List blockList = explodeEvent.blockList();
                blockList.forEach(explodedBlock -> {
                    if (explodedBlock.getLocation().equals((Object)block.getLocation())) {
                        return;
                    }
                    EnchantsUtils.safeBusyBreak(player, explodedBlock);
                });
                blockList.clear();
            });
        });
    }
}

