/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.fishing;

import java.nio.file.Path;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.type.FishingEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.NumberUtil;

public class SeasonedAnglerEnchant
extends GameEnchantment
implements FishingEnchant {
    private Modifier xpModifier;

    public SeasonedAnglerEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.xpModifier = Modifier.load(config, "SeasonedAngler.XP_Modifier", Modifier.addictive(0.0).perLevel(50.0).capacity(300.0), "Amount (in percent) of additional XP from fishing.");
        this.addPlaceholder("%amount%", level -> NumberUtil.format((double)this.getXPPercent((int)level)));
    }

    public int getXPPercent(int level) {
        return (int)this.xpModifier.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getFishingPriority() {
        return EnchantPriority.NORMAL;
    }

    @Override
    public boolean onFishing(@NotNull PlayerFishEvent event, @NotNull ItemStack item, int level) {
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return false;
        }
        if (event.getExpToDrop() == 0) {
            return false;
        }
        int expDrop = event.getExpToDrop();
        int expPercent = this.getXPPercent(level);
        int expModified = (int)Math.ceil((double)expDrop * (1.0 + (double)expPercent / 100.0));
        event.setExpToDrop(expModified);
        return true;
    }
}

