/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.bow;

import java.nio.file.Path;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.AreaEffectCloud;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.ArrowEffects;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.ArrowEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.NumberUtil;

public class DragonfireArrowsEnchant
extends GameEnchantment
implements ArrowEnchant {
    private Modifier duration;
    private Modifier radius;

    public DragonfireArrowsEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.ARROW, ArrowEffects.basic(Particle.DRAGON_BREATH));
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(4.0, 3.0));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.duration = Modifier.load(config, "Dragonfire.Duration", Modifier.addictive(40.0).perLevel(20.0).capacity(1200.0), "Dragonfire cloud effect duration (in ticks). 20 ticks = 1 second.");
        this.radius = Modifier.load(config, "Dragonfire.Radius", Modifier.addictive(0.0).perLevel(1.0).capacity(5.0), "Dragonfire cloud effect radius.");
        this.addPlaceholder("%duration%", level -> NumberUtil.format((double)((double)this.getFireDuration((int)level) / 20.0)));
        this.addPlaceholder("%radius%", level -> NumberUtil.format((double)this.getFireRadius((int)level)));
    }

    public int getFireDuration(int level) {
        return (int)this.duration.getValue(level);
    }

    public double getFireRadius(int level) {
        return this.radius.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getShootPriority() {
        return EnchantPriority.NORMAL;
    }

    @Override
    public boolean onShoot(@NotNull EntityShootBowEvent event, @NotNull LivingEntity shooter, @NotNull ItemStack bow, int level) {
        return true;
    }

    @Override
    public void onHit(@NotNull ProjectileHitEvent event, @NotNull LivingEntity shooter, @NotNull Arrow arrow, int level) {
        if (event.getHitEntity() != null) {
            return;
        }
        this.createCloud((ProjectileSource)shooter, arrow.getLocation(), event.getHitEntity(), event.getHitBlock(), event.getHitBlockFace(), level);
    }

    @Override
    public void onDamage(@NotNull EntityDamageByEntityEvent event, @NotNull LivingEntity shooter, @NotNull LivingEntity victim, @NotNull Arrow arrow, int level) {
        this.createCloud((ProjectileSource)shooter, victim.getLocation(), (Entity)victim, null, null, level);
    }

    private void createCloud(@NotNull ProjectileSource shooter, @NotNull Location location, @Nullable Entity hitEntity, @Nullable Block hitBlock, @Nullable BlockFace hitFace, int level) {
        ItemStack itemStack = new ItemStack(Material.LINGERING_POTION);
        ItemUtil.editMeta((ItemStack)itemStack, PotionMeta.class, potionMeta -> potionMeta.addCustomEffect(new PotionEffect(PotionEffectType.INSTANT_DAMAGE, 20, 0), true));
        ThrownPotion potion = (ThrownPotion)shooter.launchProjectile(ThrownPotion.class);
        potion.setItem(itemStack);
        potion.teleport(location);
        AreaEffectCloud cloud = (AreaEffectCloud)potion.getWorld().spawn(location, AreaEffectCloud.class);
        cloud.clearCustomEffects();
        cloud.setSource(shooter);
        cloud.setParticle(Particle.DRAGON_BREATH, (Object)Float.valueOf(1.0f));
        cloud.setRadius((float)this.getFireRadius(level));
        cloud.setDuration(this.getFireDuration(level));
        cloud.setRadiusPerTick((7.0f - cloud.getRadius()) / (float)cloud.getDuration());
        cloud.addCustomEffect(new PotionEffect(PotionEffectType.INSTANT_DAMAGE, 1, 1), true);
        LingeringPotionSplashEvent splashEvent = new LingeringPotionSplashEvent(potion, hitEntity, hitBlock, hitFace, cloud);
        this.plugin.getPluginManager().callEvent((Event)splashEvent);
        if (splashEvent.isCancelled()) {
            cloud.remove();
        }
        potion.remove();
    }
}

