/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.armor;

import java.nio.file.Path;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.PotionEffects;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.DefendEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.sound.VanillaSound;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class IceShieldEnchant
extends GameEnchantment
implements DefendEnchant {
    public IceShieldEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(5.0, 5.0));
        this.addComponent(EnchantComponent.POTION_EFFECT, PotionEffects.temporal(PotionEffectType.SLOWNESS, Modifier.addictive(3.0).perLevel(1.0).capacity(10.0)));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
    }

    @Override
    @NotNull
    public EnchantPriority getProtectPriority() {
        return EnchantPriority.NORMAL;
    }

    @Override
    public boolean onProtect(@NotNull EntityDamageByEntityEvent event, @NotNull LivingEntity damager, @NotNull LivingEntity victim, @NotNull ItemStack weapon, int level) {
        if (!this.addPotionEffect(damager, level)) {
            return false;
        }
        damager.setFreezeTicks(damager.getMaxFreezeTicks());
        if (this.hasVisualEffects()) {
            UniParticle.blockCrack((Material)Material.ICE).play(victim.getEyeLocation(), 0.5, 0.1, 35);
            UniParticle.of((Particle)Particle.CLOUD).play(victim.getEyeLocation(), 0.25, 0.1, 25);
            VanillaSound.of((Sound)Sound.BLOCK_GLASS_BREAK).play(victim.getLocation());
        }
        return true;
    }
}

