/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.armor;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.damage.DamageBonus;
import su.nightexpress.excellentenchants.api.damage.DamageBonusType;
import su.nightexpress.excellentenchants.api.enchantment.type.MoveEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.ProtectionEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.Randomizer;

public class FlameWalkerEnchant
extends GameEnchantment
implements MoveEnchant,
ProtectionEnchant {
    private static final BlockFace[] FACES = new BlockFace[]{BlockFace.SOUTH, BlockFace.NORTH, BlockFace.EAST, BlockFace.WEST};
    private Modifier radius;
    private Modifier decayTime;

    public FlameWalkerEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.radius = Modifier.load(config, "FlameWalker.Radius", Modifier.addictive(1.0).perLevel(1.0).capacity(16.0), "Square radius around the block to transform into magma block.");
        this.decayTime = Modifier.load(config, "FlameWalker.Block_Decay", Modifier.addictive(8.0).perLevel(1.0).capacity(15.0), "Sets life time for magma blocks before turning back into lava.");
    }

    @NotNull
    public Modifier getRadius() {
        return this.radius;
    }

    public int getBlockDecayTime(int level) {
        return (int)this.decayTime.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getMovePriority() {
        return EnchantPriority.LOWEST;
    }

    @Override
    @NotNull
    public EnchantPriority getProtectionPriority() {
        return EnchantPriority.NORMAL;
    }

    @Override
    @NotNull
    public DamageBonus getDamageBonus() {
        return new DamageBonus(DamageBonusType.NORMAL);
    }

    @Override
    public boolean onMove(@NotNull PlayerMoveEvent event, @NotNull Player player, @NotNull ItemStack itemStack, int level) {
        Location to = event.getTo();
        Block nextBlock = to.getBlock().getRelative(BlockFace.DOWN);
        boolean hasLava = Stream.of(FACES).anyMatch(face -> nextBlock.getRelative(face).getType() == Material.LAVA);
        if (!hasLava) {
            return false;
        }
        int radius = (int)this.radius.getValue(level);
        Set<Block> blocks = this.handleFlameWalker((LivingEntity)player, level, radius);
        if (blocks.isEmpty()) {
            return false;
        }
        blocks.forEach(block -> {
            int lifeTime = (int)(Randomizer.nextDouble((double)this.getBlockDecayTime(level)) + 1.0);
            this.plugin.getEnchantManager().addTickedBlock((Block)block, Material.LAVA, Material.MAGMA_BLOCK, lifeTime);
        });
        return true;
    }

    @Override
    public boolean onProtection(@NotNull EntityDamageEvent event, @NotNull DamageBonus damageBonus, @NotNull LivingEntity entity, @NotNull ItemStack itemStack, int level) {
        DamageSource source = event.getDamageSource();
        DamageType type = source.getDamageType();
        if (type != DamageType.HOT_FLOOR) {
            return false;
        }
        event.setCancelled(true);
        return true;
    }

    @NotNull
    public Set<Block> handleFlameWalker(@NotNull LivingEntity bukkitEntity, int level, int radius) {
        HashSet<Block> blocks = new HashSet<Block>();
        for (Block block : this.getCircleBlocks(bukkitEntity, radius)) {
            Block above;
            Levelled levelled;
            BlockData blockData;
            if (block.getType() != Material.LAVA || !((blockData = block.getBlockData()) instanceof Levelled) || (levelled = (Levelled)blockData).getLevel() != 0 || !(above = block.getRelative(BlockFace.UP)).isEmpty()) continue;
            BlockState state = Material.MAGMA_BLOCK.createBlockData().createBlockState();
            EntityBlockFormEvent event = new EntityBlockFormEvent((Entity)bukkitEntity, block, state);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) continue;
            block.setBlockData(state.getBlockData());
            blocks.add(block);
        }
        return blocks;
    }

    @NotNull
    protected List<Block> getCircleBlocks(@NotNull LivingEntity entity, int radius) {
        World world = entity.getWorld();
        int fixedY = entity.getLocation().getBlockY() - 1;
        ArrayList<Block> blocks = new ArrayList<Block>();
        int centerX = entity.getLocation().getBlockX();
        int centerZ = entity.getLocation().getBlockZ();
        for (int x = centerX - radius; x <= centerX + radius; ++x) {
            for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                int dx = centerX - x;
                int dz = centerZ - z;
                if (dx * dx + dz * dz > radius * radius) continue;
                Block block = world.getBlockAt(x, fixedY, z);
                blocks.add(block);
            }
        }
        return blocks;
    }
}

