/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.armor;

import java.nio.file.Path;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.DefendEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.sound.VanillaSound;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class FireShieldEnchant
extends GameEnchantment
implements DefendEnchant {
    private Modifier fireDuration;
    private boolean addFireImmune;

    public FireShieldEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(4.0, 2.0));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.fireDuration = Modifier.load(config, "FireShield.Duration", Modifier.addictive(4.0).perLevel(1.0).capacity(10.0), "Sets the fire duration (in seconds).");
        this.addFireImmune = (Boolean)ConfigValue.create((String)"FireShield.AddResistance", (boolean)true, (String[])new String[]{"Controls whether Fire Resistance effect should be added to the enchantment's wearer."}).read(config);
        this.addPlaceholder("%duration%", level -> NumberUtil.format((double)this.getFireDuration((int)level)));
    }

    @Override
    @NotNull
    public EnchantPriority getProtectPriority() {
        return EnchantPriority.NORMAL;
    }

    public double getFireDuration(int level) {
        return this.fireDuration.getValue(level);
    }

    @Override
    public boolean onProtect(@NotNull EntityDamageByEntityEvent event, @NotNull LivingEntity damager, @NotNull LivingEntity victim, @NotNull ItemStack weapon, int level) {
        int damagerFireTicks;
        int fireTicks = (int)(this.getFireDuration(level) * 20.0);
        if (this.addFireImmune) {
            victim.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, fireTicks, 0));
        }
        if ((damagerFireTicks = damager.getFireTicks()) >= fireTicks) {
            return false;
        }
        if (this.hasVisualEffects()) {
            UniParticle.of((Particle)Particle.FLAME).play(victim.getEyeLocation(), 0.5, 0.1, 35);
            VanillaSound.of((Sound)Sound.ITEM_FIRECHARGE_USE).play(victim.getLocation());
        }
        damager.setFireTicks(fireTicks);
        return true;
    }
}

