/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.enchantment.CustomEnchantment;
import su.nightexpress.excellentenchants.api.enchantment.type.ArrowEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.AttackEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.BlockChangeEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.BlockDropEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.BlockEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.BowEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.ContainerEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.DeathEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.DefendEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.DurabilityEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.FishingEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.InteractEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.InventoryEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.KillEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.MiningEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.MoveEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.PassiveEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.ProtectionEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.ResurrectEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.TridentEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantHolder;
import su.nightexpress.nightcore.util.LowerCase;

public class EnchantRegistry {
    private static final Map<NamespacedKey, CustomEnchantment> BY_KEY = new HashMap<NamespacedKey, CustomEnchantment>();
    private static final Map<String, CustomEnchantment> BY_ID = new HashMap<String, CustomEnchantment>();
    private static final Map<String, EnchantHolder<?>> HOLDERS = new HashMap();
    public static final EnchantHolder<MiningEnchant> MINING = EnchantRegistry.registerHolder("mining", MiningEnchant.class, MiningEnchant::getBreakPriority);
    public static final EnchantHolder<BlockDropEnchant> BLOCK_DROP = EnchantRegistry.registerHolder("drop", BlockDropEnchant.class, BlockDropEnchant::getDropPriority);
    public static final EnchantHolder<BowEnchant> BOW = EnchantRegistry.registerHolder("bow", BowEnchant.class, BowEnchant::getShootPriority);
    public static final EnchantHolder<ArrowEnchant> ARROW = EnchantRegistry.registerHolder("arrow", ArrowEnchant.class, BowEnchant::getShootPriority);
    public static final EnchantHolder<TridentEnchant> TRIDENT = EnchantRegistry.registerHolder("trident", TridentEnchant.class, TridentEnchant::getLaunchPriority);
    public static final EnchantHolder<AttackEnchant> ATTACK = EnchantRegistry.registerHolder("attack", AttackEnchant.class, AttackEnchant::getAttackPriority);
    public static final EnchantHolder<DefendEnchant> DEFEND = EnchantRegistry.registerCachedHolder("defend", DefendEnchant.class, DefendEnchant::getProtectPriority);
    public static final EnchantHolder<ProtectionEnchant> PROTECTION = EnchantRegistry.registerCachedHolder("protection", ProtectionEnchant.class, ProtectionEnchant::getProtectionPriority);
    public static final EnchantHolder<ContainerEnchant> CONTAINER = EnchantRegistry.registerHolder("container", ContainerEnchant.class, ContainerEnchant::getClickPriority);
    public static final EnchantHolder<MoveEnchant> MOVE = EnchantRegistry.registerCachedHolder("move", MoveEnchant.class, MoveEnchant::getMovePriority);
    public static final EnchantHolder<KillEnchant> KILL = EnchantRegistry.registerHolder("kill", KillEnchant.class, KillEnchant::getKillPriority);
    public static final EnchantHolder<DeathEnchant> DEATH = EnchantRegistry.registerHolder("death", DeathEnchant.class, DeathEnchant::getDeathPriority);
    public static final EnchantHolder<ResurrectEnchant> RESURRECT = EnchantRegistry.registerHolder("resurrect", ResurrectEnchant.class, ResurrectEnchant::getResurrectPriority);
    public static final EnchantHolder<FishingEnchant> FISHING = EnchantRegistry.registerHolder("fishing", FishingEnchant.class, FishingEnchant::getFishingPriority);
    public static final EnchantHolder<InteractEnchant> INTERACT = EnchantRegistry.registerHolder("interact", InteractEnchant.class, InteractEnchant::getInteractPriority);
    public static final EnchantHolder<DurabilityEnchant> DURABILITY = EnchantRegistry.registerCachedHolder("durability", DurabilityEnchant.class, DurabilityEnchant::getItemDamagePriority);
    public static final EnchantHolder<BlockChangeEnchant> BLOCK_CHANGE = EnchantRegistry.registerCachedHolder("block_change", BlockChangeEnchant.class, e -> EnchantPriority.NORMAL);
    public static final EnchantHolder<InventoryEnchant> INVENTORY = EnchantRegistry.registerHolder("inventory", InventoryEnchant.class, e -> EnchantPriority.NORMAL);
    public static final EnchantHolder<BlockEnchant> BLOCK = EnchantRegistry.registerHolder("block", BlockEnchant.class, e -> EnchantPriority.NORMAL);
    public static final EnchantHolder<PassiveEnchant> PASSIVE = EnchantRegistry.registerCachedHolder("passive", PassiveEnchant.class, e -> EnchantPriority.NORMAL);

    public static void registerEnchant(@NotNull CustomEnchantment enchantment) {
        EnchantRegistry.getHolders().forEach(holder -> holder.accept(enchantment));
        BY_KEY.put(enchantment.getKey(), enchantment);
        BY_ID.put(enchantment.getId(), enchantment);
    }

    public static boolean isRegistered(@NotNull String id) {
        return EnchantRegistry.getById(id) != null;
    }

    public static boolean isRegistered(@NotNull Enchantment enchantment) {
        return EnchantRegistry.getByBukkit(enchantment) != null;
    }

    @Nullable
    public static CustomEnchantment getById(@NotNull String id) {
        return BY_ID.get(LowerCase.INTERNAL.apply(id));
    }

    @Nullable
    public static CustomEnchantment getByKey(@NotNull NamespacedKey key) {
        return BY_KEY.get(key);
    }

    @Nullable
    public static CustomEnchantment getByBukkit(@NotNull Enchantment enchantment) {
        return EnchantRegistry.getByKey(enchantment.getKey());
    }

    @NotNull
    public static Set<CustomEnchantment> getRegistered() {
        return new HashSet<CustomEnchantment>(BY_ID.values());
    }

    @NotNull
    public static Set<Enchantment> getRegisteredBukkit() {
        return EnchantRegistry.getRegistered().stream().map(CustomEnchantment::getBukkitEnchantment).collect(Collectors.toSet());
    }

    @NotNull
    public static List<String> getRegisteredNames() {
        return new ArrayList<String>(BY_ID.keySet());
    }

    @NotNull
    public static <T extends CustomEnchantment> EnchantHolder<T> registerHolder(@NotNull String name, @NotNull Class<T> type, @NotNull Function<T, EnchantPriority> priority) {
        return EnchantRegistry.registerHolder(name, type, priority, EnchantHolder::withNoCache);
    }

    @NotNull
    public static <T extends CustomEnchantment> EnchantHolder<T> registerCachedHolder(@NotNull String name, @NotNull Class<T> type, @NotNull Function<T, EnchantPriority> priority) {
        return EnchantRegistry.registerHolder(name, type, priority, EnchantHolder::cached);
    }

    @NotNull
    private static <T extends CustomEnchantment> EnchantHolder<T> registerHolder(@NotNull String name, @NotNull Class<T> type, @NotNull Function<T, EnchantPriority> priority, @NotNull BiFunction<Class<T>, Function<T, EnchantPriority>, EnchantHolder<T>> function) {
        EnchantHolder<T> holder = function.apply(type, priority);
        EnchantRegistry.registerHolder(name, holder);
        return holder;
    }

    public static <T extends CustomEnchantment> void registerHolder(@NotNull String name, @NotNull EnchantHolder<T> holder) {
        HOLDERS.put(LowerCase.INTERNAL.apply(name), holder);
    }

    @NotNull
    public static Set<EnchantHolder<?>> getHolders() {
        return new HashSet(HOLDERS.values());
    }
}

