/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsKeys;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantDefinition;
import su.nightexpress.excellentenchants.api.EnchantDistribution;
import su.nightexpress.excellentenchants.api.enchantment.CustomEnchantment;
import su.nightexpress.excellentenchants.api.item.ItemSetDefaults;
import su.nightexpress.excellentenchants.api.item.ItemSetRegistry;
import su.nightexpress.excellentenchants.api.wrapper.TradeType;
import su.nightexpress.excellentenchants.bridge.EnchantCatalogEntry;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.EnchantFactory;
import su.nightexpress.excellentenchants.enchantment.armor.ColdSteelEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.DarknessCloakEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.DragonHeartEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.ElementalProtectionEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.FireShieldEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.FlameWalkerEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.HardenedEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.IceShieldEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.JumpingEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.KamikadzeEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.LightweightEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.NightVisionEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.ReboundEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.RegrowthEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.SaturationEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.SpeedyEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.StoppingForceEnchant;
import su.nightexpress.excellentenchants.enchantment.armor.WaterBreathingEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.BomberEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.ConfusingArrowsEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.DarknessArrowsEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.DragonfireArrowsEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.ElectrifiedArrowsEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.EnderBowEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.ExplosiveArrowsEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.FlareEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.GhastEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.HoverEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.LingeringEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.PoisonedArrowsEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.SniperEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.VampiricArrowsEnchant;
import su.nightexpress.excellentenchants.enchantment.bow.WitheredArrowsEnchant;
import su.nightexpress.excellentenchants.enchantment.fishing.AutoReelEnchant;
import su.nightexpress.excellentenchants.enchantment.fishing.CurseOfDrownedEnchant;
import su.nightexpress.excellentenchants.enchantment.fishing.DoubleCatchEnchant;
import su.nightexpress.excellentenchants.enchantment.fishing.RiverMasterEnchant;
import su.nightexpress.excellentenchants.enchantment.fishing.SeasonedAnglerEnchant;
import su.nightexpress.excellentenchants.enchantment.fishing.SurvivalistEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.BlastMiningEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.GlassbreakerEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.HasteEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.LuckyMinerEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.ReplanterEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.SilkChestEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.SilkSpawnerEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.SmelterEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.TelekinesisEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.TreefellerEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.TunnelEnchant;
import su.nightexpress.excellentenchants.enchantment.tool.VeinminerEnchant;
import su.nightexpress.excellentenchants.enchantment.universal.CurseOfBreakingEnchant;
import su.nightexpress.excellentenchants.enchantment.universal.CurseOfFragilityEnchant;
import su.nightexpress.excellentenchants.enchantment.universal.CurseOfMediocrityEnchant;
import su.nightexpress.excellentenchants.enchantment.universal.CurseOfMisfortuneEnchant;
import su.nightexpress.excellentenchants.enchantment.universal.RestoreEnchant;
import su.nightexpress.excellentenchants.enchantment.universal.SoulboundEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.BaneOfNetherspawnEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.BlindnessEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.ConfusionEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.CureEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.CurseOfDeathEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.CutterEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.DecapitatorEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.DoubleStrikeEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.ExhaustEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.IceAspectEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.InfernusEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.NimbleEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.ParalyzeEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.RageEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.RocketEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.SwiperEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.TemperEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.ThriftyEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.ThunderEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.VampireEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.VenomEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.VillageDefenderEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.WisdomEnchant;
import su.nightexpress.excellentenchants.enchantment.weapon.WitherEnchant;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.FileUtil;
import su.nightexpress.nightcore.util.LowerCase;
import su.nightexpress.nightcore.util.Version;

public enum EnchantCatalog implements EnchantCatalogEntry
{
    COLD_STEEL(() -> EnchantDefinition.builder("Cold Steel", 3).description("%enchantment_trigger_chance%% chance to apply %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on attacker.").weight(5).supportedItems(ItemSetDefaults.CHESTPLATE_ELYTRA).primaryItems(ItemSetDefaults.CHESTPLATE).build(), () -> EnchantDistribution.regular(TradeType.SNOW_COMMON), ColdSteelEnchant::new),
    DARKNESS_CLOAK(() -> EnchantDefinition.builder("Darkness Cloak", 3).description("%enchantment_trigger_chance%% chance to apply %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on attacker.").weight(5).supportedItems(ItemSetDefaults.CHESTPLATE_ELYTRA).primaryItems(ItemSetDefaults.CHESTPLATE).build(), () -> EnchantDistribution.regular(TradeType.SAVANNA_COMMON), DarknessCloakEnchant::new),
    DRAGON_HEART(() -> EnchantDefinition.builder("Dragon Heart", 5).description("Grants permanent %enchantment_potion_type% %enchantment_potion_level% effect.").weight(2).supportedItems(ItemSetDefaults.CHESTPLATE_ELYTRA).primaryItems(ItemSetDefaults.CHESTPLATE).build(), () -> EnchantDistribution.regular(TradeType.JUNGLE_SPECIAL), DragonHeartEnchant::new),
    ELEMENTAL_PROTECTION(() -> EnchantDefinition.builder("Elemental Protection", 4).description("Reduces potion and elemental damage by %amount%%.").weight(10).items(ItemSetDefaults.ARMOR).build(), () -> EnchantDistribution.regular(TradeType.SWAMP_COMMON), ElementalProtectionEnchant::new),
    FIRE_SHIELD(() -> EnchantDefinition.builder("Fire Shield", 4).description("%enchantment_trigger_chance%% chance to ignite attackers for %duration%s.").weight(2).supportedItems(ItemSetDefaults.CHESTPLATE_ELYTRA).primaryItems(ItemSetDefaults.CHESTPLATE).build(), () -> EnchantDistribution.regular(TradeType.DESERT_COMMON), FireShieldEnchant::new),
    FLAME_WALKER(() -> EnchantDefinition.builder("Flame Walker", 2).description("Ability to walk on lava, immunity to magma damage.").weight(1).items(ItemSetDefaults.BOOTS).exclusives(EnchantsKeys.FROST_WALKER).build(), () -> EnchantDistribution.treasure(TradeType.DESERT_SPECIAL), FlameWalkerEnchant::new),
    HARDENED(() -> EnchantDefinition.builder("Hardened", 2).description("%enchantment_trigger_chance%% chance to get %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) when damaged.").weight(5).supportedItems(ItemSetDefaults.CHESTPLATE_ELYTRA).primaryItems(ItemSetDefaults.CHESTPLATE).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), HardenedEnchant::new),
    ICE_SHIELD(() -> EnchantDefinition.builder("Ice Shield", 3).description("%enchantment_trigger_chance%% chance to freeze and apply %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on attacker.").weight(10).supportedItems(ItemSetDefaults.CHESTPLATE_ELYTRA).primaryItems(ItemSetDefaults.CHESTPLATE).build(), () -> EnchantDistribution.regular(TradeType.SNOW_COMMON), IceShieldEnchant::new),
    LIGHTWEIGHT(() -> EnchantDefinition.builder("Lightweight", 1).description("You can safely jump on turtle eggs, farmlands and big dripleaf.").weight(10).items(ItemSetDefaults.BOOTS).build(), () -> EnchantDistribution.regular(TradeType.SNOW_COMMON), LightweightEnchant::new),
    JUMPING(() -> EnchantDefinition.builder("Jumping", 2).description("Grants permanent %enchantment_potion_type% %enchantment_potion_level% effect.").weight(2).items(ItemSetDefaults.BOOTS).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), JumpingEnchant::new),
    KAMIKADZE(() -> EnchantDefinition.builder("Kamikadze", 3).description("%enchantment_trigger_chance%% chance to explode on death.").weight(5).supportedItems(ItemSetDefaults.CHESTPLATE_ELYTRA).primaryItems(ItemSetDefaults.CHESTPLATE).build(), () -> EnchantDistribution.regular(TradeType.JUNGLE_COMMON), KamikadzeEnchant::new),
    NIGHT_VISION(() -> EnchantDefinition.builder("Night Vision", 1).description("Grants permanent %enchantment_potion_type% %enchantment_potion_level% effect.").weight(1).items(ItemSetDefaults.HELMET).build(), () -> EnchantDistribution.treasure(TradeType.TAIGA_SPECIAL), NightVisionEnchant::new),
    REBOUND(() -> EnchantDefinition.builder("Rebound", 1).description("Effect of landing on a slime block.").weight(2).items(ItemSetDefaults.BOOTS).exclusives(EnchantsKeys.FEATHER_FALLING).build(), () -> EnchantDistribution.treasure(TradeType.SWAMP_COMMON), ReboundEnchant::new),
    REGROWTH(() -> EnchantDefinition.builder("Regrowth", 4).description("Restores %amount%\u2764 every few seconds.").weight(2).supportedItems(ItemSetDefaults.CHESTPLATE_ELYTRA).primaryItems(ItemSetDefaults.CHESTPLATE).build(), () -> EnchantDistribution.treasure(TradeType.JUNGLE_SPECIAL), RegrowthEnchant::new),
    SATURATION(() -> EnchantDefinition.builder("Saturation", 2).description("Restores %amount% food points every few seconds.").weight(2).items(ItemSetDefaults.HELMET).build(), () -> EnchantDistribution.regular(TradeType.SAVANNA_SPECIAL), SaturationEnchant::new),
    SPEED(() -> EnchantDefinition.builder("Speed", 2).description("Grants permanent %enchantment_potion_type% %enchantment_potion_level% effect.").weight(2).items(ItemSetDefaults.BOOTS).build(), () -> EnchantDistribution.regular(TradeType.DESERT_SPECIAL), SpeedyEnchant::new),
    STOPPING_FORCE(() -> EnchantDefinition.builder("Stopping Force", 3).description("%enchantment_trigger_chance%% chance to reduce knockback for %amount%%.").weight(5).items(ItemSetDefaults.LEGGINGS).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), StoppingForceEnchant::new),
    WATER_BREATHING(() -> EnchantDefinition.builder("Water Breathing", 1).description("Grants permanent %enchantment_potion_type% %enchantment_potion_level% effect.").weight(1).items(ItemSetDefaults.HELMET).build(), () -> EnchantDistribution.treasure(TradeType.PLAINS_SPECIAL), WaterBreathingEnchant::new),
    BOMBER(() -> EnchantDefinition.builder("Bomber", 3).description("%enchantment_trigger_chance%% chance to shoot a TNT ignited for %time%s.").weight(1).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(EnchantsKeys.FLAME, EnchantsKeys.PUNCH, EnchantsKeys.POWER).build(), () -> EnchantDistribution.treasure(TradeType.DESERT_SPECIAL), BomberEnchant::new),
    ENDER_BOW(() -> EnchantDefinition.builder("Ender Bow", 1).description("Shoots ender pearls instead of arrows.").weight(1).items(ItemSetDefaults.BOW).exclusives(BOMBER.getKey(), EnchantsKeys.FLAME, EnchantsKeys.PUNCH, EnchantsKeys.POWER).build(), () -> EnchantDistribution.treasure(TradeType.PLAINS_SPECIAL), EnderBowEnchant::new),
    GHAST(() -> EnchantDefinition.builder("Ghast", 1).description("Shoots fireballs instead of arrows.").weight(1).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), BOMBER.getKey(), EnchantsKeys.FLAME, EnchantsKeys.PUNCH, EnchantsKeys.POWER).build(), () -> EnchantDistribution.treasure(TradeType.DESERT_COMMON), GhastEnchant::new),
    CONFUSING_ARROWS(() -> EnchantDefinition.builder("Confusing Arrows", 3).description("%enchantment_trigger_chance%% chance for arrow to have %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.)").weight(10).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.regular(TradeType.SWAMP_COMMON), ConfusingArrowsEnchant::new),
    DARKNESS_ARROWS(() -> EnchantDefinition.builder("Darkness Arrows", 3).description("%enchantment_trigger_chance%% chance for arrow to have %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.)").weight(10).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.regular(TradeType.SNOW_COMMON), DarknessArrowsEnchant::new),
    DRAGONFIRE_ARROWS(() -> EnchantDefinition.builder("Dragonfire Arrows", 3).description("%enchantment_trigger_chance%% chance for arrow to have Dragonfire Effect (R=%radius%, %duration%s).").weight(2).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.regular(TradeType.SWAMP_SPECIAL), DragonfireArrowsEnchant::new),
    ELECTRIFIED_ARROWS(() -> EnchantDefinition.builder("Electrified Arrows", 3).description("%enchantment_trigger_chance%% chance for an arrow to strike lightning with %damage%\u2764 extra damage.").weight(5).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), ElectrifiedArrowsEnchant::new),
    EXPLOSIVE_ARROWS(() -> EnchantDefinition.builder("Explosive Arrows", 3).description("%enchantment_trigger_chance%% chance to shoot an explosive arrow.").weight(5).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.regular(TradeType.TAIGA_COMMON), ExplosiveArrowsEnchant::new),
    FLARE(() -> EnchantDefinition.builder("Flare", 1).description("%enchantment_trigger_chance%% chance to create a torch where arrow lands.").weight(5).items(ItemSetDefaults.BOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.treasure(TradeType.SNOW_COMMON), FlareEnchant::new),
    HOVER(() -> EnchantDefinition.builder("Hover", 3).description("%enchantment_trigger_chance%% chance for arrow to have %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.)").weight(10).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_SPECIAL), HoverEnchant::new),
    LINGERING(() -> EnchantDefinition.builder("Lingering", 3).description("%enchantment_trigger_chance%% chance for tipped arrows to generate a lingering effect.").weight(2).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.regular(TradeType.SAVANNA_COMMON), LingeringEnchant::new),
    POISONED_ARROWS(() -> EnchantDefinition.builder("Poisoned Arrows", 3).description("%enchantment_trigger_chance%% chance for arrow to have %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.)").weight(5).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.regular(TradeType.SWAMP_COMMON), PoisonedArrowsEnchant::new),
    SNIPER(() -> EnchantDefinition.builder("Sniper", 2).description("Increases projectile speed by %amount%%").weight(10).items(ItemSetDefaults.BOW_CROSSBOW).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_SPECIAL), SniperEnchant::new),
    VAMPIRIC_ARROWS(() -> EnchantDefinition.builder("Vampiric Arrows", 3).description("%enchantment_trigger_chance%% chance to restore %amount%\u2764 on arrow hit.").weight(2).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.regular(TradeType.SWAMP_SPECIAL), VampiricArrowsEnchant::new),
    WITHERED_ARROWS(() -> EnchantDefinition.builder("Withered Arrows", 3).description("%enchantment_trigger_chance%% chance for arrow to have %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.)").weight(5).items(ItemSetDefaults.BOW_CROSSBOW).exclusives(ENDER_BOW.getKey(), GHAST.getKey(), BOMBER.getKey()).build(), () -> EnchantDistribution.regular(TradeType.SNOW_SPECIAL), WitheredArrowsEnchant::new),
    AUTO_REEL(() -> EnchantDefinition.builder("Auto Reel", 1).description("Automatically reels in a hook on bite.").weight(1).items(ItemSetDefaults.FISHING_ROD).build(), () -> EnchantDistribution.treasure(TradeType.JUNGLE_SPECIAL), AutoReelEnchant::new, false, true),
    CURSE_OF_DROWNED(() -> EnchantDefinition.builder("Curse of Drowned", 3).description("%enchantment_trigger_chance%% chance to fish up a Drowned Zombie.").weight(5).items(ItemSetDefaults.FISHING_ROD).build(), () -> EnchantDistribution.treasure(TradeType.SWAMP_COMMON), CurseOfDrownedEnchant::new, true),
    DOUBLE_CATCH(() -> EnchantDefinition.builder("Double Catch", 3).description("Increases amount of caught item by x2 with %enchantment_trigger_chance%% chance.").weight(2).items(ItemSetDefaults.FISHING_ROD).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), DoubleCatchEnchant::new),
    RIVER_MASTER(() -> EnchantDefinition.builder("River Master", 5).description("Increases casting distance.").weight(10).items(ItemSetDefaults.FISHING_ROD).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), RiverMasterEnchant::new),
    SEASONED_ANGLER(() -> EnchantDefinition.builder("Seasoned Angler", 3).description("Increases amount of XP gained from fishing by %amount%%.").weight(5).items(ItemSetDefaults.FISHING_ROD).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), SeasonedAnglerEnchant::new),
    SURVIVALIST(() -> EnchantDefinition.builder("Survivalist", 1).description("Automatically cooks fish if what is caught is raw.").weight(2).items(ItemSetDefaults.FISHING_ROD).build(), () -> EnchantDistribution.treasure(TradeType.SNOW_SPECIAL), SurvivalistEnchant::new),
    BLAST_MINING(() -> EnchantDefinition.builder("Blast Mining", 5).description("%enchantment_trigger_chance%% chance to mine blocks by explosion.").weight(2).items(ItemSetDefaults.PICKAXE).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), BlastMiningEnchant::new),
    GLASSBREAKER(() -> EnchantDefinition.builder("Glass Breaker", 1).description("Breaks glass instantly").weight(10).supportedItems(ItemSetDefaults.TOOL).primaryItems(ItemSetDefaults.MINING_TOOLS).build(), () -> EnchantDistribution.regular(TradeType.DESERT_COMMON), GlassbreakerEnchant::new),
    HASTE(() -> EnchantDefinition.builder("Haste", 3).description("Grants %enchantment_potion_type% %enchantment_potion_level% effect when mining blocks.").weight(2).supportedItems(ItemSetDefaults.TOOL).primaryItems(ItemSetDefaults.MINING_TOOLS).build(), () -> EnchantDistribution.regular(TradeType.SAVANNA_COMMON), HasteEnchant::new),
    LUCKY_MINER(() -> EnchantDefinition.builder("Lucky Miner", 3).description("%enchantment_trigger_chance%% chance to gain %amount%% more XP from ores.").weight(5).items(ItemSetDefaults.PICKAXE).build(), () -> EnchantDistribution.regular(TradeType.JUNGLE_COMMON), LuckyMinerEnchant::new),
    REPLANTER(() -> EnchantDefinition.builder("Replanter", 1).description("Automatically replant crops on right click and when harvest.").weight(1).items(ItemSetDefaults.HOE).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), ReplanterEnchant::new),
    SILK_CHEST(() -> EnchantDefinition.builder("Silk Chest", 1).description("Drop chests and saves all its content.").weight(1).supportedItems(ItemSetDefaults.MINING_TOOLS).primaryItems(ItemSetDefaults.AXE).build(), () -> EnchantDistribution.regular(TradeType.SAVANNA_COMMON), SilkChestEnchant::new, false, true),
    SILK_SPAWNER(() -> EnchantDefinition.builder("Silk Spawner", 1).description("%enchantment_trigger_chance%% chance to mine spawner.").weight(1).supportedItems(ItemSetDefaults.MINING_TOOLS).primaryItems(ItemSetDefaults.PICKAXE).build(), () -> EnchantDistribution.treasure(TradeType.JUNGLE_SPECIAL), SilkSpawnerEnchant::new),
    SMELTER(() -> EnchantDefinition.builder("Smelter", 5).description("Smelts mined blocks with %enchantment_trigger_chance%% chance.").weight(5).supportedItems(ItemSetDefaults.TOOL).primaryItems(ItemSetDefaults.MINING_TOOLS).exclusives(SILK_SPAWNER.getKey(), SILK_CHEST.getKey(), EnchantsKeys.SILK_TOUCH).build(), () -> EnchantDistribution.regular(TradeType.DESERT_COMMON), SmelterEnchant::new),
    TELEKINESIS(() -> EnchantDefinition.builder("Telekinesis", 1).description("Moves all blocks loot directly to your inventory.").weight(1).supportedItems(ItemSetDefaults.TOOL).primaryItems(ItemSetDefaults.MINING_TOOLS).build(), () -> EnchantDistribution.treasure(TradeType.DESERT_SPECIAL), TelekinesisEnchant::new),
    TREEFELLER(() -> EnchantDefinition.builder("Treefeller", 1).description("Cuts down an entire tree.").weight(2).items(ItemSetDefaults.AXE).build(), () -> EnchantDistribution.regular(TradeType.TAIGA_SPECIAL), TreefellerEnchant::new),
    TUNNEL(() -> EnchantDefinition.builder("Tunnel", 3).description("Mines multiple blocks at once in a certain shape.").weight(1).supportedItems(ItemSetDefaults.MINING_TOOLS).primaryItems(ItemSetDefaults.PICKAXE).exclusives(BLAST_MINING.getKey()).build(), () -> EnchantDistribution.regular(TradeType.SAVANNA_SPECIAL), TunnelEnchant::new),
    VEINMINER(() -> EnchantDefinition.builder("Veinminer", 3).description("Mines up to %amount% blocks of the ore vein at once.").weight(2).items(ItemSetDefaults.PICKAXE).exclusives(BLAST_MINING.getKey(), TUNNEL.getKey()).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_SPECIAL), VeinminerEnchant::new),
    CURSE_OF_BREAKING(() -> EnchantDefinition.builder("Curse of Breaking", 3).description("%enchantment_trigger_chance%% chance to consume extra %amount% durability points.").weight(10).items(ItemSetDefaults.BREAKABLE).exclusives(EnchantsKeys.UNBREAKING).build(), () -> EnchantDistribution.treasure(TradeType.SAVANNA_COMMON), CurseOfBreakingEnchant::new, true),
    CURSE_OF_FRAGILITY(() -> EnchantDefinition.builder("Curse of Fragility", 1).description("Prevents an item from being grindstoned or anviled.").weight(10).items(ItemSetDefaults.BREAKABLE).build(), () -> EnchantDistribution.treasure(TradeType.TAIGA_COMMON), CurseOfFragilityEnchant::new, true),
    CURSE_OF_MEDIOCRITY(() -> EnchantDefinition.builder("Curse of Mediocrity", 3).description("%enchantment_trigger_chance%% chance to disenchant item drops.").weight(5).supportedItems(ItemSetDefaults.TOOLS_WEAPONS).primaryItems(ItemSetDefaults.ALL_WEAPON).build(), () -> EnchantDistribution.treasure(TradeType.SNOW_COMMON), CurseOfMediocrityEnchant::new, true),
    CURSE_OF_MISFORTUNE(() -> EnchantDefinition.builder("Curse of Misfortune", 3).description("%enchantment_trigger_chance%% chance to have no drops from blocks or mobs.").weight(5).items(ItemSetDefaults.TOOLS_WEAPONS).exclusives(EnchantsKeys.FORTUNE, EnchantsKeys.LOOTING).build(), () -> EnchantDistribution.treasure(TradeType.TAIGA_COMMON), CurseOfMisfortuneEnchant::new, true),
    RESTORE(() -> EnchantDefinition.builder("Restore", 3).description("%enchantment_trigger_chance%% chance to save item from breaking back to %amount%%").weight(2).items(ItemSetDefaults.BREAKABLE).build(), () -> EnchantDistribution.regular(TradeType.DESERT_COMMON), RestoreEnchant::new),
    SOULBOUND(() -> EnchantDefinition.builder("Soulbound", 1).description("Protects from being dropped on death.").weight(2).items(ItemSetDefaults.BREAKABLE).exclusives(EnchantsKeys.VANISHING_CURSE).build(), () -> EnchantDistribution.treasure(TradeType.DESERT_SPECIAL), SoulboundEnchant::new),
    BANE_OF_NETHERSPAWN(() -> EnchantDefinition.builder("Bane of Netherspawn", 5).description("Inflicts %damage%\u2764 more damage to nether mobs.").weight(10).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), BaneOfNetherspawnEnchant::new),
    BLINDNESS(() -> EnchantDefinition.builder("Blindness", 2).description("%enchantment_trigger_chance%% chance to apply %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on hit.").weight(10).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.TAIGA_COMMON), BlindnessEnchant::new),
    CONFUSION(() -> EnchantDefinition.builder("Confusion", 2).description("%enchantment_trigger_chance%% chance to apply %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on hit.").weight(10).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.SNOW_COMMON), ConfusionEnchant::new),
    CURE(() -> EnchantDefinition.builder("Cure", 3).description("%enchantment_trigger_chance%% chance to cure Zombified Piglins and Zombie Villagers on hit.").weight(10).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.SAVANNA_COMMON), CureEnchant::new),
    CURSE_OF_DEATH(() -> EnchantDefinition.builder("Curse of Death", 3).description("When killing players, you have a chance of dying too.").weight(2).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.treasure(TradeType.DESERT_SPECIAL), CurseOfDeathEnchant::new, true),
    CUTTER(() -> EnchantDefinition.builder("Cutter", 3).description("%enchantment_trigger_chance%% chance to throw away enemy''s armor and damage it for %damage%%.").weight(2).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), CutterEnchant::new),
    DECAPITATOR(() -> EnchantDefinition.builder("Decapitator", 2).description("%enchantment_trigger_chance%% chance to obtain player's or mob's head.").weight(2).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.treasure(TradeType.SNOW_SPECIAL), DecapitatorEnchant::new),
    DOUBLE_STRIKE(() -> EnchantDefinition.builder("Double Strike", 2).description("%enchantment_trigger_chance%% chance to inflict double damage.").weight(1).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.TAIGA_COMMON), DoubleStrikeEnchant::new),
    EXHAUST(() -> EnchantDefinition.builder("Exhaust", 4).description("%enchantment_trigger_chance%% chance to apply %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on hit.").weight(10).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), ExhaustEnchant::new),
    ICE_ASPECT(() -> EnchantDefinition.builder("Ice Aspect", 3).description("Freezes and applies %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on hit.").weight(10).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.SNOW_COMMON), IceAspectEnchant::new),
    INFERNUS(() -> EnchantDefinition.builder("Infernus", 3).description("Launched trident will ignite the enemy for %time%s. on hit.").weight(10).items(ItemSetDefaults.TRIDENT).build(), () -> EnchantDistribution.regular(TradeType.SAVANNA_COMMON), InfernusEnchant::new),
    NIMBLE(() -> EnchantDefinition.builder("Nimble", 1).description("Moves all entity's loot directly to your inventory.").weight(2).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.JUNGLE_COMMON), NimbleEnchant::new),
    PARALYZE(() -> EnchantDefinition.builder("Paralyze", 5).description("%enchantment_trigger_chance%% chance to apply %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on hit.").weight(5).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.TAIGA_COMMON), ParalyzeEnchant::new),
    RAGE(() -> EnchantDefinition.builder("Rage", 2).description("%enchantment_trigger_chance%% chance to get %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on hit.").weight(5).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.DESERT_COMMON), RageEnchant::new),
    ROCKET(() -> EnchantDefinition.builder("Rocket", 3).description("%enchantment_trigger_chance%% chance to launch your enemy into the space.").weight(5).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.treasure(TradeType.JUNGLE_COMMON), RocketEnchant::new),
    SWIPER(() -> EnchantDefinition.builder("Swiper", 3).description("%enchantment_trigger_chance%% chance to steal %amount% XP from players.").weight(2).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.SWAMP_COMMON), SwiperEnchant::new),
    TEMPER(() -> EnchantDefinition.builder("Temper", 5).description("Inflicts %amount%% more damage for each %radius%\u2764 missing.").weight(1).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.TAIGA_COMMON), TemperEnchant::new),
    THRIFTY(() -> EnchantDefinition.builder("Thrifty", 3).description("%enchantment_trigger_chance%% chance for mobs to drop spawn egg.").weight(2).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.treasure(TradeType.JUNGLE_SPECIAL), ThriftyEnchant::new),
    THUNDER(() -> EnchantDefinition.builder("Thunder", 5).description("%enchantment_trigger_chance%% chance to strike lightning with %damage%\u2764 extra damage.").weight(5).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), ThunderEnchant::new),
    VAMPIRE(() -> EnchantDefinition.builder("Vampire", 3).description("%enchantment_trigger_chance%% chance to heal for %amount%\u2764 on hit.").weight(2).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.SAVANNA_COMMON), VampireEnchant::new),
    VENOM(() -> EnchantDefinition.builder("Venom", 2).description("%enchantment_trigger_chance%% chance to apply %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on hit.").weight(10).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.SWAMP_COMMON), VenomEnchant::new),
    VILLAGE_DEFENDER(() -> EnchantDefinition.builder("Village Defender", 5).description("Inflicts %amount%\u2764 more damage to all pillagers.").weight(10).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.PLAINS_COMMON), VillageDefenderEnchant::new),
    WISDOM(() -> EnchantDefinition.builder("Wisdom", 5).description("Mobs drops x%modifier% more XP.").weight(5).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.DESERT_COMMON), WisdomEnchant::new),
    WITHER(() -> EnchantDefinition.builder("Wither", 2).description("%enchantment_trigger_chance%% chance to apply %enchantment_potion_type% %enchantment_potion_level% (%enchantment_potion_duration%s.) on hit.").weight(5).supportedItems(ItemSetDefaults.SWORDS_AXES).primaryItems(ItemSetDefaults.SWORD).build(), () -> EnchantDistribution.regular(TradeType.SNOW_COMMON), WitherEnchant::new);

    private final String id = LowerCase.INTERNAL.apply(this.name());
    private final boolean curse;
    private final boolean paperOnly;
    private final Supplier<EnchantDefinition> initDefinition;
    private final Supplier<EnchantDistribution> initDistribution;
    private final EnchantFactory<?> factory;
    private EnchantDefinition definition;
    private EnchantDistribution distribution;
    private boolean disabled;

    public static void loadAll(@NotNull Path dataDir, @NotNull ItemSetRegistry itemSetRegistry, @NotNull BiConsumer<EnchantCatalog, IllegalStateException> onError) {
        Path enchantsDir = Path.of(dataDir.toString(), "/enchants/");
        Path disabledDir = Path.of(enchantsDir.toString(), "_disabled_");
        if (!Files.exists(disabledDir, new LinkOption[0])) {
            try {
                Files.createDirectories(disabledDir, new FileAttribute[0]);
            }
            catch (IOException exception) {
                exception.printStackTrace();
            }
        }
        Set disabledEnchants = FileUtil.findYamlFiles((String)disabledDir.toString()).stream().map(FileUtil::getNameWithoutExtension).collect(Collectors.toSet());
        for (EnchantCatalog value : EnchantCatalog.values()) {
            if (disabledEnchants.contains(value.getId())) {
                value.disabled = true;
                continue;
            }
            try {
                value.load(enchantsDir, itemSetRegistry);
            }
            catch (IllegalStateException exception) {
                onError.accept(value, exception);
            }
        }
    }

    @NotNull
    public static Stream<EnchantCatalog> stream() {
        return Stream.of(EnchantCatalog.values());
    }

    @NotNull
    public static Stream<EnchantCatalog> enabled() {
        return EnchantCatalog.stream().filter(EnchantCatalog::isEnabled);
    }

    private EnchantCatalog(@NotNull Supplier<EnchantDefinition> initDefinition, Supplier<EnchantDistribution> initDistribution, EnchantFactory<?> factory) {
        this(initDefinition, initDistribution, factory, false);
    }

    private EnchantCatalog(@NotNull Supplier<EnchantDefinition> initDefinition, Supplier<EnchantDistribution> initDistribution, EnchantFactory<?> factory, boolean curse) {
        this(initDefinition, initDistribution, factory, curse, false);
    }

    private EnchantCatalog(@NotNull Supplier<EnchantDefinition> initDefinition, Supplier<EnchantDistribution> initDistribution, EnchantFactory<?> factory, boolean curse, boolean paperOnly) {
        this.curse = curse;
        this.paperOnly = paperOnly;
        this.initDefinition = initDefinition;
        this.initDistribution = initDistribution;
        this.factory = factory;
    }

    public void load(@NotNull Path enchantsDir, @NotNull ItemSetRegistry itemSetRegistry) throws IllegalStateException {
        if (this.paperOnly && Version.isSpigot()) {
            throw new IllegalStateException("The enchantment is available for PaperMC only");
        }
        Path file = Path.of(enchantsDir.toString(), FileConfig.withExtension((String)this.id));
        boolean exists = Files.exists(file, new LinkOption[0]);
        FileConfig config = FileConfig.load((Path)file);
        EnchantDefinition definition = this.initDefinition.get();
        EnchantDistribution distribution = this.initDistribution.get();
        if (!exists) {
            config.set("Definition", (Object)definition);
            config.set("Distribution", (Object)distribution);
        }
        this.definition = EnchantDefinition.read(config, "Definition", itemSetRegistry);
        this.distribution = EnchantDistribution.read(config, "Distribution");
        config.saveChanges();
    }

    @NotNull
    public CustomEnchantment createEnchantment(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        return this.factory.create(plugin, manager, file, context);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return EnchantsKeys.create(this.id);
    }

    @Override
    @NotNull
    public EnchantDefinition getDefinition() {
        if (this.definition == null) {
            throw new IllegalStateException("Definition is not yet initialized");
        }
        return this.definition;
    }

    @Override
    @NotNull
    public EnchantDistribution getDistribution() {
        if (this.distribution == null) {
            throw new IllegalStateException("Distribution is not yet initialized");
        }
        return this.distribution;
    }

    @Override
    public boolean isCurse() {
        return this.curse;
    }

    public boolean isPaperOnly() {
        return this.paperOnly;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    static class Weight {
        static final int COMMON = 10;
        static final int UNCOMMON = 5;
        static final int RARE = 2;
        static final int VERY_RARE = 1;

        Weight() {
        }
    }
}

