/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment;

import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.bridge.DistributionSettings;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.AbstractConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigTypes;

public class DistributionConfig
extends AbstractConfig
implements DistributionSettings {
    private final ConfigProperty<Boolean> useMinecraftNamespace = this.addProperty(ConfigTypes.BOOLEAN, "Core.Use-Minecraft-Namespace", false, new String[]{"Controls whether to use 'minecraft' namespace for the Excellent Enchantments.", "[*] WARNING: NOT RECOMMENED TO CHANGE. MAY BE REMOVED IN FUTURE RELEASES. SUPPORT VOID IF SET ON 'TRUE'.", "[*] WHEN CHANGED, ALL EXISTING EXCELLENT ENCHANTMENTS ON ITEMS WILL BE DELETED FOREVER.", "[*] Server reboot required.", "[Default is false]"});
    private final ConfigProperty<Boolean> distributionEnchanting = this.addProperty(ConfigTypes.BOOLEAN, "Distribution.Enchanting_Table", true, new String[]{"Controls whether excellent enchants can be found in an enchanting table or use to enchant items generated by loot tables.", "https://minecraft.wiki/w/Enchanting#Enchanting_table", "[*] Server reboot required.", "[Default is true]"});
    private final ConfigProperty<Boolean> distributionTrading = this.addProperty(ConfigTypes.BOOLEAN, "Distribution.Trading", true, new String[]{"Controls whether excellent enchants can be sold by villagers.", "https://minecraft.wiki/w/Trading#Librarian", "[*] Server reboot required.", "[Default is true]"});
    private final ConfigProperty<Boolean> distributionMobEquipment = this.addProperty(ConfigTypes.BOOLEAN, "Distribution.Mob_Equipment", true, new String[]{"Controls whether excellent enchants can be found on spawned mobs' equipment.", "https://minecraft.wiki/w/Armor#Armor_equipped_on_mobs", "[*] Server reboot required.", "[Default is true]"});
    private final ConfigProperty<Boolean> distributionTradeEquipment = this.addProperty(ConfigTypes.BOOLEAN, "Distribution.Trade_Equipment", true, new String[]{"Controls whether excellent enchants can be found on equipment sold by villagers.", "https://minecraft.wiki/w/Trading#Trade_offers", "[*] Works only if Villager Trade Rebalance is DISABLED.", "[*] Server reboot required.", "[Default is true]"});
    private final ConfigProperty<Boolean> distributionRandomLoot = this.addProperty(ConfigTypes.BOOLEAN, "Distribution.Random_Loot", true, new String[]{"Controls whether excellent enchants can be found on naturally generated equipment from loot tables.", "https://minecraft.wiki/w/Loot_table", "[*] Server reboot required.", "[Default is true]"});

    @NotNull
    public static DistributionConfig load(@NotNull Path dataDir) {
        FileConfig fileConfig = FileConfig.load((String)dataDir.toString(), (String)"distribution.yml");
        DistributionConfig settings = new DistributionConfig();
        fileConfig.edit(settings::load);
        return settings;
    }

    public void load(@NotNull FileConfig config) {
        if (config.contains("Custom_Namespace.Enabled")) {
            config.set("Core.Use-Minecraft-Namespace", (Object)(!config.getBoolean("Custom_Namespace.Enabled") ? 1 : 0));
            config.remove("Custom_Namespace.Enabled");
        }
        super.load(config);
    }

    public boolean isUseMinecraftNamespace() {
        return (Boolean)this.useMinecraftNamespace.get();
    }

    @Override
    public boolean isEnchantingEnabled() {
        return (Boolean)this.distributionEnchanting.get();
    }

    @Override
    public boolean isTradingEnabled() {
        return (Boolean)this.distributionTrading.get();
    }

    @Override
    public boolean isMobEquipmentEnabled() {
        return (Boolean)this.distributionMobEquipment.get();
    }

    @Override
    public boolean isTradeEquipmentEnabled() {
        return (Boolean)this.distributionTradeEquipment.get();
    }

    @Override
    public boolean isRandomLootEnabled() {
        return (Boolean)this.distributionRandomLoot.get();
    }
}

