/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.config;

import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.configuration.AbstractConfig;
import su.nightexpress.nightcore.configuration.ConfigProperty;
import su.nightexpress.nightcore.configuration.ConfigTypes;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class Config
extends AbstractConfig {
    private final ConfigProperty<Boolean> featuresEnchantTooltip = this.addProperty(ConfigTypes.BOOLEAN, "Modules.EnchantTooltip", true, new String[]{"When 'true', adds the enchantment description to item lore under enchantment names."});
    public static final ConfigValue<Boolean> CHARGES_ENABLED = ConfigValue.create((String)"Charges.Enabled", (boolean)false, (String[])new String[]{"Enables the Charges feature: https://nightexpressdev.com/excellentenchants/features/charges"});
    public static final ConfigValue<Boolean> CHARGES_FUEL_IGNORE_META = ConfigValue.create((String)"Charges.Fuel.Ignore_Meta", (boolean)false, (String[])new String[]{"Controls if item meta (such as display name, lore, model data, etc.) should be ignored when checks if item is valid fuel.", "[Default is false]"});
    public static final ConfigValue<NightItem> CHARGES_FUEL_ITEM = ConfigValue.create((String)"Charges.Fuel.Item", (NightItem)NightItem.fromType((Material)Material.LAPIS_LAZULI), (String[])new String[]{"Default item used to fuel enchantments on anvils.", "Enchantments can have their own custom fuel items.", "https://nightexpressdev.com/nightcore/configuration/item-formation/"});

    public void load(@NotNull FileConfig config) {
        if (config.contains("Description.Enabled")) {
            config.set("Modules.EnchantTooltip", (Object)config.getBoolean("Description.Enabled"));
            config.remove("Description.Enabled");
        }
        super.load(config);
    }

    public boolean isEnchantTooltipEnabled() {
        return (Boolean)this.featuresEnchantTooltip.get();
    }

    public static boolean isChargesEnabled() {
        return (Boolean)CHARGES_ENABLED.get();
    }
}

