/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.command;

import java.util.Set;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlaceholders;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.api.enchantment.CustomEnchantment;
import su.nightexpress.excellentenchants.command.CommandArguments;
import su.nightexpress.excellentenchants.config.Config;
import su.nightexpress.excellentenchants.config.Lang;
import su.nightexpress.excellentenchants.config.Perms;
import su.nightexpress.excellentenchants.enchantment.EnchantRegistry;
import su.nightexpress.nightcore.commands.Arguments;
import su.nightexpress.nightcore.commands.Commands;
import su.nightexpress.nightcore.commands.builder.ArgumentNodeBuilder;
import su.nightexpress.nightcore.commands.builder.ExecutableNodeBuilder;
import su.nightexpress.nightcore.commands.builder.HubNodeBuilder;
import su.nightexpress.nightcore.commands.builder.LiteralNodeBuilder;
import su.nightexpress.nightcore.commands.context.CommandContext;
import su.nightexpress.nightcore.commands.context.ParsedArguments;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.LangUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.Randomizer;
import su.nightexpress.nightcore.util.bridge.RegistryType;

public class BaseCommands {
    private final EnchantsPlugin plugin;

    public BaseCommands(@NotNull EnchantsPlugin plugin) {
        this.plugin = plugin;
    }

    public void load(@NotNull HubNodeBuilder builder) {
        builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"reload").description(CoreLang.COMMAND_RELOAD_DESC)).permission((Permission)Perms.COMMAND_RELOAD)).executes((context, arguments) -> {
            this.plugin.doReload(context.getSender());
            return true;
        })});
        builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"book").description(Lang.COMMAND_BOOK_DESC)).permission((Permission)Perms.COMMAND_BOOK)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.enchantArgument("enchant"), CommandArguments.levelArgument("level").optional(), Arguments.player((String)"player").optional()}).withFlags(new String[]{"charged"}).executes(this::giveEnchantBook)});
        builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"randombook").description(Lang.COMMAND_RANDOM_BOOK_DESC)).permission((Permission)Perms.COMMAND_RANDOM_BOOK)).withArguments(new ArgumentNodeBuilder[]{Arguments.player((String)"player").optional()}).withFlags(new String[]{"custom", "charged"}).executes(this::giveRandomBook)});
        builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"enchant").description(Lang.COMMAND_ENCHANT_DESC)).permission((Permission)Perms.COMMAND_ENCHANT)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.enchantArgument("enchant"), CommandArguments.levelArgument("level"), Arguments.player((String)"player").optional(), CommandArguments.slotArgument("slot").optional()}).withFlags(new String[]{"charged"}).executes(this::enchantItem)});
        builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"disenchant").description(Lang.COMMAND_DISENCHANT_DESC)).permission((Permission)Perms.COMMAND_DISENCHANT)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.enchantArgument("enchant"), Arguments.player((String)"player").optional(), CommandArguments.slotArgument("slot").optional()}).executes(this::disenchantItem)});
        builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"list").playerOnly()).description(Lang.COMMAND_LIST_DESC)).permission((Permission)Perms.COMMAND_LIST)).withArguments(new ArgumentNodeBuilder[]{((ArgumentNodeBuilder)Arguments.player((String)"player").permission((Permission)Perms.COMMAND_LIST_OTHERS)).optional()}).executes(this::openList)});
        if (Config.isChargesEnabled()) {
            builder.branch(new ExecutableNodeBuilder[]{((LiteralNodeBuilder)((LiteralNodeBuilder)((LiteralNodeBuilder)Commands.literal((String)"givefuel").playerOnly()).description(Lang.COMMAND_GIVE_FUEL_DESC)).permission((Permission)Perms.COMMAND_GIVE_FUEL)).withArguments(new ArgumentNodeBuilder[]{CommandArguments.customEnchantArgument("enchant").suggestions((reader, context) -> EnchantRegistry.getRegistered().stream().filter(CustomEnchantment::isChargeable).map(CustomEnchantment::getId).toList()), Arguments.integer((String)"amount", (int)1).suggestions((rader, context) -> Lists.newList((Object[])new String[]{"1", "8", "16", "32", "64"})).optional(), Arguments.player((String)"player").optional()}).executes(this::giveFuel)});
        }
    }

    private int getLevel(@NotNull Enchantment enchantment, @NotNull ParsedArguments arguments) {
        int level = arguments.getInt("level", -1);
        if (level <= 0) {
            level = EnchantsUtils.randomLevel(enchantment);
        }
        return level;
    }

    private boolean giveEnchantBook(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        if (!context.isPlayer() && !arguments.contains("player")) {
            context.printUsage();
            return false;
        }
        Player player = arguments.contains("player") ? arguments.getPlayer("player") : context.getPlayerOrThrow();
        boolean charged = context.hasFlag("charged");
        Enchantment enchantment = arguments.getEnchantment("enchant");
        int level = this.getLevel(enchantment, arguments);
        return this.giveBook(context.getSender(), player, enchantment, level, charged);
    }

    private boolean giveRandomBook(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        if (!context.isPlayer() && !arguments.contains("player")) {
            context.printUsage();
            return false;
        }
        Player player = arguments.contains("player") ? arguments.getPlayer("player") : context.getPlayerOrThrow();
        boolean custom = context.hasFlag("custom");
        boolean charged = context.hasFlag("charged");
        Enchantment enchantment = (Enchantment)Randomizer.pick((Set)(custom ? EnchantRegistry.getRegisteredBukkit() : BukkitThing.getAll((RegistryType)RegistryType.ENCHANTMENT)));
        int level = EnchantsUtils.randomLevel(enchantment);
        return this.giveBook(context.getSender(), player, enchantment, level, charged);
    }

    private boolean giveBook(@NotNull CommandSender sender, @NotNull Player player, @NotNull Enchantment enchantment, int level, boolean charged) {
        ItemStack itemStack = new ItemStack(Material.ENCHANTED_BOOK);
        if (charged) {
            EnchantsUtils.restoreCharges(itemStack, enchantment, level);
        }
        EnchantsUtils.add(itemStack, enchantment, level, true);
        Players.addItem((Player)player, (ItemStack[])new ItemStack[]{itemStack});
        Lang.ENCHANTED_BOOK_GAVE.message().send(sender, replacer -> replacer.replace("%enchant%", (Object)LangUtil.getSerializedName((Enchantment)enchantment)).replace("%level%", (Object)NumberUtil.toRoman((int)level)).replace(EnchantsPlaceholders.forPlayer((Player)player)));
        return true;
    }

    private boolean enchantItem(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        EquipmentSlot slot;
        if (!context.isPlayer() && !arguments.contains("player")) {
            context.printUsage();
            return false;
        }
        Player player = arguments.contains("player") ? arguments.getPlayer("player") : context.getPlayerOrThrow();
        ItemStack itemStack = EntityUtil.getItemInSlot((LivingEntity)player, (EquipmentSlot)(slot = (EquipmentSlot)arguments.getOr("slot", EquipmentSlot.class, (Object)EquipmentSlot.HAND)));
        if (itemStack == null || itemStack.getType().isAir()) {
            context.send(Lang.COMMAND_ENCHANT_ERROR_NO_ITEM);
            return false;
        }
        boolean charged = context.hasFlag("charged");
        Enchantment enchantment = arguments.getEnchantment("enchant");
        int level = this.getLevel(enchantment, arguments);
        EnchantsUtils.add(itemStack, enchantment, level, true);
        if (charged) {
            EnchantsUtils.restoreCharges(itemStack, enchantment, level);
        }
        context.send(context.getSender() == player ? Lang.COMMAND_ENCHANT_DONE_SELF : Lang.COMMAND_ENCHANT_DONE_OTHERS, replacer -> replacer.replace(EnchantsPlaceholders.forPlayer((Player)player)).replace("%item%", (Object)ItemUtil.getNameSerialized((ItemStack)itemStack)).replace("%enchant%", (Object)LangUtil.getSerializedName((Enchantment)enchantment)).replace("%level%", (Object)NumberUtil.toRoman((int)level)));
        return true;
    }

    private boolean disenchantItem(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        EquipmentSlot slot;
        if (!context.isPlayer() && !arguments.contains("player")) {
            context.printUsage();
            return false;
        }
        Player player = arguments.contains("player") ? arguments.getPlayer("player") : context.getPlayerOrThrow();
        ItemStack itemStack = EntityUtil.getItemInSlot((LivingEntity)player, (EquipmentSlot)(slot = (EquipmentSlot)arguments.getOr("slot", EquipmentSlot.class, (Object)EquipmentSlot.HAND)));
        if (itemStack == null || itemStack.getType().isAir()) {
            context.send(Lang.COMMAND_ENCHANT_ERROR_NO_ITEM);
            return false;
        }
        Enchantment enchantment = arguments.getEnchantment("enchant");
        EnchantsUtils.remove(itemStack, enchantment);
        context.send(context.getSender() == player ? Lang.COMMAND_DISENCHANT_DONE_SELF : Lang.COMMAND_DISENCHANT_DONE_OTHERS, replacer -> replacer.replace(EnchantsPlaceholders.forPlayer((Player)player)).replace("%item%", (Object)ItemUtil.getNameSerialized((ItemStack)itemStack)).replace("%enchant%", (Object)LangUtil.getSerializedName((Enchantment)enchantment)));
        return true;
    }

    private boolean giveFuel(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        if (!context.isPlayer() && !arguments.contains("player")) {
            context.printUsage();
            return false;
        }
        Player player = arguments.contains("player") ? arguments.getPlayer("player") : context.getPlayerOrThrow();
        CustomEnchantment enchantment = (CustomEnchantment)arguments.get("enchant", CustomEnchantment.class);
        int amount = arguments.getInt("amount", 1);
        if (!enchantment.isChargeable()) {
            context.send(Lang.CHARGES_FUEL_BAD_ENCHANTMENT, replacer -> replacer.replace("%name%", (Object)enchantment.getDisplayName()));
            return false;
        }
        ItemStack fuel = enchantment.getFuel();
        fuel.setAmount(amount);
        Players.addItem((Player)player, (ItemStack[])new ItemStack[]{fuel});
        context.send(Lang.CHARGES_FUEL_GAVE, replacer -> replacer.replace("%amount%", (Object)NumberUtil.format((double)amount)).replace("%name%", (Object)ItemUtil.getNameSerialized((ItemStack)fuel)).replace(EnchantsPlaceholders.forPlayer((Player)player)));
        return true;
    }

    private boolean openList(@NotNull CommandContext context, @NotNull ParsedArguments arguments) {
        if (!context.isPlayer() && !arguments.contains("player")) {
            context.printUsage();
            return false;
        }
        Player player = arguments.contains("player") ? arguments.getPlayer("player") : context.getPlayerOrThrow();
        this.plugin.getEnchantManager().openEnchantsMenu(player);
        if (player != context.getSender()) {
            context.send(Lang.COMMAND_LIST_DONE_OTHERS, replacer -> replacer.replace(EnchantsPlaceholders.forPlayer((Player)player)));
        }
        return true;
    }
}

