/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.bridge.paper;

import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.EnchantmentRegistryEntry;
import io.papermc.paper.registry.event.RegistryEvents;
import io.papermc.paper.registry.keys.EnchantmentKeys;
import io.papermc.paper.registry.keys.tags.EnchantmentTagKeys;
import io.papermc.paper.registry.set.RegistryKeySet;
import io.papermc.paper.registry.set.RegistrySet;
import io.papermc.paper.registry.tag.Tag;
import io.papermc.paper.registry.tag.TagKey;
import io.papermc.paper.tag.PostFlattenTagRegistrar;
import io.papermc.paper.tag.PreFlattenTagRegistrar;
import io.papermc.paper.tag.TagEntry;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;
import su.nightexpress.excellentenchants.EnchantsKeys;
import su.nightexpress.excellentenchants.api.EnchantDefinition;
import su.nightexpress.excellentenchants.api.EnchantDistribution;
import su.nightexpress.excellentenchants.api.item.ItemSet;
import su.nightexpress.excellentenchants.api.item.ItemSetRegistry;
import su.nightexpress.excellentenchants.api.wrapper.TradeType;
import su.nightexpress.excellentenchants.bridge.paper.PaperItemTagLookup;
import su.nightexpress.excellentenchants.enchantment.DistributionConfig;
import su.nightexpress.excellentenchants.enchantment.EnchantCatalog;
import su.nightexpress.nightcore.bridge.common.NightKey;
import su.nightexpress.nightcore.util.Lists;

public class PaperEnchantsBootstrap
implements PluginBootstrap {
    @NotNull
    private TagKey<ItemType> customItemTag(@NotNull String name) {
        return TagKey.create((RegistryKey)RegistryKey.ITEM, (Key)Key.key((String)"excellentenchants", (String)name));
    }

    public void bootstrap(@NotNull BootstrapContext context) {
        Path dataDirectory = context.getDataDirectory();
        DistributionConfig distributionConfig = DistributionConfig.load(dataDirectory);
        if (distributionConfig.isUseMinecraftNamespace()) {
            EnchantsKeys.setVanillaNamespace();
        }
        LifecycleEventManager lifeCycle = context.getLifecycleManager();
        lifeCycle.registerEventHandler(LifecycleEvents.TAGS.postFlatten(RegistryKey.ITEM).newHandler(event -> {
            PostFlattenTagRegistrar registrar = (PostFlattenTagRegistrar)event.registrar();
            PaperItemTagLookup tagLookup = new PaperItemTagLookup((PostFlattenTagRegistrar<ItemType>)registrar);
            ItemSetRegistry itemSetRegistry = new ItemSetRegistry(dataDirectory, tagLookup);
            itemSetRegistry.load();
            itemSetRegistry.values().forEach(itemSet -> {
                TagKey<ItemType> tagKey = this.customItemTag(itemSet.getId());
                List<TypedKey> tagEntries = itemSet.getMaterials().stream().map(itemName -> TypedKey.create((RegistryKey)RegistryKey.ITEM, (Key)Key.key((String)itemName))).toList();
                registrar.addToTag(tagKey, tagEntries);
            });
            EnchantCatalog.loadAll(dataDirectory, itemSetRegistry, (entry, exception) -> context.getLogger().error("Could not load '{}' enchantment: '{}'", (Object)entry.getId(), (Object)exception.getMessage()));
        }));
        lifeCycle.registerEventHandler(RegistryEvents.ENCHANTMENT.compose().newHandler(event -> {
            Registry registry = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
            EnchantCatalog.enabled().forEach(data -> {
                EnchantDefinition definition = data.getDefinition();
                ItemSet primarySet = definition.getPrimaryItemSet();
                ItemSet supportedSet = definition.getSupportedItemSet();
                TagKey<ItemType> primaryItemsTag = this.customItemTag(primarySet.getId());
                TagKey<ItemType> supportedItemsTag = this.customItemTag(supportedSet.getId());
                @NonNull Tag primaryItems = event.getOrCreateTag(primaryItemsTag);
                @NonNull Tag supportedItems = event.getOrCreateTag(supportedItemsTag);
                @NonNull RegistryKeySet exclusiveSet = RegistrySet.keySet((RegistryKey)RegistryKey.ENCHANTMENT, definition.getExclusiveSet().stream().map(rawKey -> {
                    NamespacedKey key = NightKey.key((String)rawKey).toBukkit();
                    if (registry.get((Key)key) == null) {
                        context.getLogger().warn("Unknown enchantment '{}' in exclusive list of '{}'. Ensure excluded enchantments are loaded before they are listed as exclusions for others.", (Object)key, (Object)data.getId());
                        return null;
                    }
                    return EnchantmentKeys.create((Key)key);
                }).filter(Objects::nonNull).toList());
                EquipmentSlotGroup[] activeSlots = (EquipmentSlotGroup[])Stream.of(supportedSet.getSlots()).map(EquipmentSlot::getGroup).toArray(EquipmentSlotGroup[]::new);
                NamespacedKey key = data.getKey();
                Component component = MiniMessage.miniMessage().deserialize((Object)definition.getDisplayName());
                String nameOnly = MiniMessage.miniMessage().stripTags(definition.getDisplayName());
                event.registry().register(EnchantmentKeys.create((Key)key), arg_0 -> PaperEnchantsBootstrap.lambda$bootstrap$6((Key)key, nameOnly, component, primaryItems, supportedItems, exclusiveSet, definition, activeSlots, arg_0));
            });
        }));
        lifeCycle.registerEventHandler(LifecycleEvents.TAGS.preFlatten(RegistryKey.ENCHANTMENT).newHandler(event -> {
            PreFlattenTagRegistrar registrar = (PreFlattenTagRegistrar)event.registrar();
            EnchantCatalog.enabled().forEach(data -> {
                EnchantDistribution distribution = data.getDistribution();
                TypedKey key = EnchantmentKeys.create((Key)data.getKey());
                TagEntry entry = TagEntry.valueEntry((TypedKey)key);
                Set list = Lists.newSet((Object[])new TagEntry[]{entry});
                if (distribution.isTreasure()) {
                    registrar.addToTag(EnchantmentTagKeys.TREASURE, (Collection)list);
                    registrar.addToTag(EnchantmentTagKeys.DOUBLE_TRADE_PRICE, (Collection)list);
                }
                if (distribution.isOnRandomLoot() && distributionConfig.isRandomLootEnabled()) {
                    registrar.addToTag(EnchantmentTagKeys.ON_RANDOM_LOOT, (Collection)list);
                }
                if (!distribution.isTreasure()) {
                    if (distribution.isOnMobSpawnEquipment() && distributionConfig.isMobEquipmentEnabled()) {
                        registrar.addToTag(EnchantmentTagKeys.ON_MOB_SPAWN_EQUIPMENT, (Collection)list);
                    }
                    if (distribution.isOnTradedEquipment() && distributionConfig.isTradeEquipmentEnabled()) {
                        registrar.addToTag(EnchantmentTagKeys.ON_TRADED_EQUIPMENT, (Collection)list);
                    }
                }
                if (distribution.isTradable() && distributionConfig.isTradingEnabled()) {
                    distribution.getTrades().forEach(tradeType -> registrar.addToTag(PaperEnchantsBootstrap.getTradeKey(tradeType), (Collection)list));
                    registrar.addToTag(EnchantmentTagKeys.TRADEABLE, (Collection)list);
                }
                if (data.isCurse()) {
                    registrar.addToTag(EnchantmentTagKeys.CURSE, (Collection)list);
                } else if (!distribution.isTreasure() && distribution.isDiscoverable() && distributionConfig.isEnchantingEnabled()) {
                    registrar.addToTag(EnchantmentTagKeys.IN_ENCHANTING_TABLE, (Collection)list);
                }
            });
        }));
    }

    @NotNull
    private static TagKey<Enchantment> getTradeKey(@NotNull TradeType tradeType) {
        return switch (tradeType) {
            default -> throw new MatchException(null, null);
            case TradeType.DESERT_COMMON -> EnchantmentTagKeys.TRADES_DESERT_COMMON;
            case TradeType.DESERT_SPECIAL -> EnchantmentTagKeys.TRADES_DESERT_SPECIAL;
            case TradeType.PLAINS_COMMON -> EnchantmentTagKeys.TRADES_PLAINS_COMMON;
            case TradeType.PLAINS_SPECIAL -> EnchantmentTagKeys.TRADES_PLAINS_SPECIAL;
            case TradeType.SAVANNA_COMMON -> EnchantmentTagKeys.TRADES_SAVANNA_COMMON;
            case TradeType.SAVANNA_SPECIAL -> EnchantmentTagKeys.TRADES_SAVANNA_SPECIAL;
            case TradeType.JUNGLE_COMMON -> EnchantmentTagKeys.TRADES_JUNGLE_COMMON;
            case TradeType.JUNGLE_SPECIAL -> EnchantmentTagKeys.TRADES_JUNGLE_SPECIAL;
            case TradeType.SNOW_COMMON -> EnchantmentTagKeys.TRADES_SNOW_COMMON;
            case TradeType.SNOW_SPECIAL -> EnchantmentTagKeys.TRADES_SNOW_SPECIAL;
            case TradeType.SWAMP_COMMON -> EnchantmentTagKeys.TRADES_SWAMP_COMMON;
            case TradeType.SWAMP_SPECIAL -> EnchantmentTagKeys.TRADES_SWAMP_SPECIAL;
            case TradeType.TAIGA_COMMON -> EnchantmentTagKeys.TRADES_TAIGA_COMMON;
            case TradeType.TAIGA_SPECIAL -> EnchantmentTagKeys.TRADES_TAIGA_SPECIAL;
        };
    }

    private static /* synthetic */ void lambda$bootstrap$6(Key key, String nameOnly, Component component, Tag primaryItems, Tag supportedItems, RegistryKeySet exclusiveSet, EnchantDefinition definition, EquipmentSlotGroup[] activeSlots, EnchantmentRegistryEntry.Builder builder) {
        builder.description((Component)Component.translatable((String)key.asString(), (String)nameOnly, (Style)component.style())).primaryItems((RegistryKeySet)primaryItems).supportedItems((RegistryKeySet)supportedItems).exclusiveWith(exclusiveSet).anvilCost(definition.getAnvilCost()).maxLevel(definition.getMaxLevel()).weight(definition.getWeight()).minimumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)definition.getMinCost().base(), (int)definition.getMinCost().perLevel())).maximumCost(EnchantmentRegistryEntry.EnchantmentCost.of((int)definition.getMaxCost().base(), (int)definition.getMaxCost().perLevel())).activeSlots(activeSlots);
    }
}

