/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.api.enchantment.component.impl;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Charges;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class ChargesComponent
implements EnchantComponent<Charges> {
    @Override
    @NotNull
    public String getName() {
        return "charges";
    }

    @Override
    @NotNull
    public Charges read(@NotNull FileConfig config, @NotNull Charges defaultValue) {
        Modifier maxAmount = Modifier.load(config, "Charges.Max_Amount", defaultValue.getMaxAmount(), "Maximum amount of charges for the enchantment.");
        int consumeAmount = (Integer)ConfigValue.create((String)"Charges.Consume_Amount", (int)defaultValue.getConsumeAmount(), (String[])new String[]{"Controls how many charges consumed when enchantment is triggered."}).read(config);
        int rechargeAmount = (Integer)ConfigValue.create((String)"Charges.Recharge_Amount", (int)defaultValue.getRechargeAmount(), (String[])new String[]{"Controls how many charges added per fuel item."}).read(config);
        boolean customFuelEnabled = (Boolean)ConfigValue.create((String)"Charges.CustomFuel.Enabled", (boolean)defaultValue.isCustomFuelEnabled(), (String[])new String[]{"Controls if custom fuel item should be used for this enchantment."}).read(config);
        NightItem customFuelItem = (NightItem)ConfigValue.create((String)"Charges.CustomFuel.Item", (NightItem)defaultValue.getCustomFuelItem(), (String[])new String[]{"Custom fuel item.", "https://nightexpressdev.com/nightcore/configuration/item-formation/"}).read(config);
        return new Charges(maxAmount, consumeAmount, rechargeAmount, customFuelEnabled, customFuelItem);
    }
}

