/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.EquipmentSlotGroup;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentenchants.api.enchantment.CustomEnchantment;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.enchantment.EnchantHolder;
import su.nightexpress.excellentenchants.enchantment.EnchantRegistry;
import su.nightexpress.excellentenchants.external.MythicMobsHook;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.PDCUtil;
import su.nightexpress.nightcore.util.Plugins;
import su.nightexpress.nightcore.util.Randomizer;

public class EnchantsUtils {
    private static final EquipmentSlot[] HANDS = new EquipmentSlot[]{EquipmentSlot.HAND, EquipmentSlot.OFF_HAND};
    private static boolean busyBreak;

    public static boolean isBusy() {
        return busyBreak;
    }

    public static boolean isMythicMob(@NotNull Entity entity) {
        return Plugins.isLoaded((String)"MythicMobs") && MythicMobsHook.isMythicMob(entity);
    }

    public static void busyBreak(@NotNull Player player, @NotNull Block block) {
        busyBreak = true;
        player.breakBlock(block);
        busyBreak = false;
    }

    public static void safeBusyBreak(@NotNull Player player, @NotNull Block block) {
        if (!EnchantsUtils.isBusy()) {
            EnchantsUtils.busyBreak(player, block);
        }
    }

    public static boolean isEnchantedBook(@NotNull ItemStack item) {
        return item.getType() == Material.ENCHANTED_BOOK;
    }

    public static boolean isBlockItem(@NotNull ItemStack itemStack) {
        return itemStack.getType().isBlock();
    }

    public static boolean isValidSlotForEnchantEffects(@NotNull ItemStack itemStack, @NotNull EquipmentSlot slot) {
        if (EquipmentSlotGroup.HAND.test(slot)) {
            return !ItemUtil.isArmor((ItemStack)itemStack);
        }
        return true;
    }

    public static boolean hasEnchantsAndNotABook(@NotNull ItemStack itemStack) {
        return itemStack.hasItemMeta() && Optional.ofNullable(itemStack.getItemMeta()).map(ItemMeta::hasEnchants).orElse(false) != false && !EnchantsUtils.isEnchantedBook(itemStack);
    }

    public static int randomLevel(@NotNull Enchantment enchantment) {
        return Randomizer.nextInt((int)1, (int)(enchantment.getMaxLevel() + 1));
    }

    public static boolean add(@NotNull ItemStack item, @NotNull Enchantment enchantment, int level, boolean force) {
        EnchantmentStorageMeta storageMeta;
        if (!(force || enchantment.canEnchantItem(item) || EnchantsUtils.isEnchantedBook(item))) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null) {
            return false;
        }
        if (meta instanceof EnchantmentStorageMeta ? !(storageMeta = (EnchantmentStorageMeta)meta).addStoredEnchant(enchantment, level, true) : !meta.addEnchant(enchantment, level, true)) {
            return false;
        }
        item.setItemMeta(meta);
        return true;
    }

    public static void remove(@NotNull ItemStack item, @NotNull Enchantment enchantment) {
        ItemUtil.editMeta((ItemStack)item, meta -> EnchantsUtils.remove(meta, enchantment));
    }

    public static void remove(@NotNull ItemMeta meta, @NotNull Enchantment enchantment) {
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            storageMeta.removeStoredEnchant(enchantment);
        } else {
            meta.removeEnchant(enchantment);
        }
    }

    public static void removeAll(@NotNull ItemStack item) {
        ItemUtil.editMeta((ItemStack)item, meta -> EnchantsUtils.getEnchantments(meta).keySet().forEach(enchantment -> EnchantsUtils.remove(meta, enchantment)));
    }

    public static void restoreCharges(@NotNull ItemStack itemStack, @NotNull Enchantment enchantment, int level) {
        CustomEnchantment customEnchantment = EnchantRegistry.getByBukkit(enchantment);
        if (customEnchantment != null && customEnchantment.hasComponent(EnchantComponent.CHARGES)) {
            customEnchantment.restoreCharges(itemStack, level);
        }
    }

    @Nullable
    public static EquipmentSlot getItemHand(@NotNull LivingEntity entity, @NotNull Material material) {
        for (EquipmentSlot slot : HANDS) {
            ItemStack itemStack = EntityUtil.getItemInSlot((LivingEntity)entity, (EquipmentSlot)slot);
            if (itemStack == null || itemStack.getType() != material) continue;
            return slot;
        }
        return null;
    }

    @NotNull
    public static Map<Enchantment, Integer> getEnchantments(@NotNull ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        return meta == null ? Collections.emptyMap() : EnchantsUtils.getEnchantments(meta);
    }

    @NotNull
    public static Map<Enchantment, Integer> getEnchantments(@NotNull ItemMeta meta) {
        Map map;
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            map = storageMeta.getStoredEnchants();
        } else {
            map = meta.getEnchants();
        }
        return map;
    }

    public static boolean contains(@NotNull ItemStack item, @NotNull String id) {
        CustomEnchantment enchant = EnchantRegistry.getById(id);
        if (enchant == null) {
            return false;
        }
        return EnchantsUtils.contains(item, enchant.getBukkitEnchantment());
    }

    public static boolean contains(@NotNull ItemStack item, @NotNull Enchantment enchantment) {
        ItemMeta meta = item.getItemMeta();
        return meta != null && EnchantsUtils.contains(meta, enchantment);
    }

    public static boolean contains(@NotNull ItemMeta meta, @NotNull Enchantment enchantment) {
        boolean bl;
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            bl = storageMeta.hasStoredEnchant(enchantment);
        } else {
            bl = meta.hasEnchant(enchantment);
        }
        return bl;
    }

    public static int getLevel(@NotNull ItemStack item, @NotNull Enchantment enchant) {
        ItemMeta meta = item.getItemMeta();
        return meta == null ? 0 : EnchantsUtils.getLevel(meta, enchant);
    }

    public static int getLevel(@NotNull ItemMeta meta, @NotNull Enchantment enchant) {
        int n;
        if (meta instanceof EnchantmentStorageMeta) {
            EnchantmentStorageMeta storageMeta = (EnchantmentStorageMeta)meta;
            n = storageMeta.getStoredEnchantLevel(enchant);
        } else {
            n = meta.getEnchantLevel(enchant);
        }
        return n;
    }

    public static int countEnchantments(@NotNull ItemStack item) {
        return EnchantsUtils.getEnchantments(item).size();
    }

    public static int countCustomEnchantments(@NotNull ItemStack item) {
        return EnchantsUtils.getCustomEnchantments(item).size();
    }

    @NotNull
    public static Map<CustomEnchantment, Integer> getCustomEnchantments(@NotNull ItemStack item) {
        return EnchantsUtils.toCustomEnchantments(EnchantsUtils.getEnchantments(item));
    }

    @NotNull
    public static Map<CustomEnchantment, Integer> getCustomEnchantments(@NotNull ItemMeta meta) {
        return EnchantsUtils.toCustomEnchantments(EnchantsUtils.getEnchantments(meta));
    }

    @NotNull
    private static Map<CustomEnchantment, Integer> toCustomEnchantments(@NotNull Map<Enchantment, Integer> enchants) {
        LinkedHashMap<CustomEnchantment, Integer> map = new LinkedHashMap<CustomEnchantment, Integer>();
        enchants.forEach((enchantment, level) -> {
            CustomEnchantment excellent = EnchantRegistry.getByBukkit(enchantment);
            if (excellent != null) {
                map.put(excellent, (Integer)level);
            }
        });
        return map;
    }

    @NotNull
    public static <T extends CustomEnchantment> Map<T, Integer> getCustomEnchantments(@NotNull ItemStack item, @NotNull EnchantHolder<T> holder) {
        HashMap map = new HashMap();
        EnchantsUtils.getEnchantments(item).forEach((enchantment, level) -> {
            Object specific = holder.getEnchant(BukkitThing.getValue((Keyed)enchantment));
            if (specific == null) {
                return;
            }
            map.put(specific, level);
        });
        return map;
    }

    @NotNull
    public static <T extends CustomEnchantment> Map<ItemStack, Map<T, Integer>> getAll(@NotNull Player player, @NotNull EnchantHolder<T> holder) {
        HashMap map = new HashMap();
        for (ItemStack itemStack : player.getInventory().getContents()) {
            if (itemStack == null || itemStack.getType().isAir()) continue;
            EnchantsUtils.getCustomEnchantments(itemStack, holder).forEach((enchant, level) -> map.computeIfAbsent(itemStack, k -> new LinkedHashMap()).put(enchant, level));
        }
        return map;
    }

    @Deprecated
    @NotNull
    public static <T extends CustomEnchantment> Map<ItemStack, Map<T, Integer>> getEquipped(@NotNull LivingEntity entity, @NotNull EnchantHolder<T> holder) {
        HashMap map = new HashMap();
        EntityUtil.getEquippedItems((LivingEntity)entity).forEach((slot, itemStack) -> {
            if (itemStack == null || !EnchantsUtils.hasEnchantsAndNotABook(itemStack)) {
                return;
            }
            EnchantsUtils.getCustomEnchantments(itemStack, holder).forEach((enchant, level) -> {
                Object[] enchantSlots = enchant.getSupportedItems().getSlots();
                if (!Lists.contains((Object[])enchantSlots, (Object)slot)) {
                    return;
                }
                map.computeIfAbsent((ItemStack)itemStack, k -> new LinkedHashMap()).put(enchant, level);
            });
        });
        return map;
    }

    public static void addArrowEnchant(@NotNull AbstractArrow arrow, @NotNull CustomEnchantment enchant, int level) {
        PDCUtil.set((PersistentDataHolder)arrow, (NamespacedKey)enchant.getBukkitEnchantment().getKey(), (int)level);
    }

    @NotNull
    public static <T extends CustomEnchantment> Map<T, Integer> getArrowEnchants(@NotNull AbstractArrow arrow, @NotNull EnchantHolder<T> holder) {
        HashMap map = new HashMap();
        holder.getEnchants().forEach(enchant -> {
            int level = PDCUtil.getInt((PersistentDataHolder)arrow, (NamespacedKey)enchant.getBukkitEnchantment().getKey()).orElse(-1);
            if (level <= 0) {
                return;
            }
            map.put(enchant, level);
        });
        return map;
    }

    public static void populateResource(@NotNull BlockDropItemEvent event, @NotNull ItemStack itemStack) {
        EnchantsUtils.populateResource(event, itemStack, null);
    }

    public static void populateResource(@NotNull BlockDropItemEvent event, @NotNull ItemStack itemStack, @Nullable Consumer<Item> consumer) {
        Block block = event.getBlock();
        World world = block.getWorld();
        Location location = block.getLocation();
        float yMod = 0.125f;
        double x = location.getX() + 0.5 + Randomizer.nextDouble((double)-0.25, (double)0.25);
        double y = location.getY() + 0.5 + Randomizer.nextDouble((double)-0.25, (double)0.25) - (double)yMod;
        double z = location.getZ() + 0.5 + Randomizer.nextDouble((double)-0.25, (double)0.25);
        Location spawn = new Location(world, x, y, z);
        Item item = (Item)world.createEntity(spawn, Item.class);
        item.setItemStack(itemStack);
        if (consumer != null) {
            consumer.accept(item);
        }
        event.getItems().add(item);
    }
}

