/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.tooltip.format;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;

public class ChargesFormat
implements Writeable {
    private final int threshold;
    private final String format;

    public ChargesFormat(int threshold, @NotNull String format) {
        this.threshold = threshold;
        this.format = format;
    }

    @NotNull
    public static ChargesFormat read(@NotNull FileConfig config, @NotNull String path) {
        int threshold = config.getInt(path + ".Threshold");
        String format = config.getString(path + ".Format", "%amount%");
        return new ChargesFormat(threshold, format);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Threshold", (Object)this.threshold);
        config.set(path + ".Format", (Object)this.format);
    }

    @NotNull
    public String getFormatted(int charges) {
        return this.format.replace("%amount%", String.valueOf(charges));
    }

    public boolean isAboveThreshold(int percent) {
        return percent >= this.threshold;
    }

    public boolean isUnderThreshold(int percent) {
        return percent < this.threshold;
    }

    public int getThreshold() {
        return this.threshold;
    }

    @NotNull
    public String getFormat() {
        return this.format;
    }
}

