/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.tooltip;

import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.tooltip.TooltipManager;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;

public class TooltipListener
extends AbstractListener<EnchantsPlugin> {
    private final TooltipManager manager;

    public TooltipListener(@NotNull EnchantsPlugin plugin, @NotNull TooltipManager manager) {
        super((NightCorePlugin)plugin);
        this.manager = manager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onGameModeChange(PlayerGameModeChangeEvent event) {
        Player player = event.getPlayer();
        GameMode current = player.getGameMode();
        GameMode newGameMode = event.getNewGameMode();
        if (newGameMode == GameMode.CREATIVE) {
            this.manager.runInStopList(player, () -> ((Player)player).updateInventory());
        } else if (current == GameMode.CREATIVE) {
            ((EnchantsPlugin)this.plugin).runTask(() -> ((Player)player).updateInventory());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent event) {
        this.manager.removeFromUpdateStopList(event.getPlayer());
    }
}

