/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.nms.mc_1_21_8;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.CraftEquipmentSlot;
import org.bukkit.craftbukkit.v1_21_R5.CraftServer;
import org.bukkit.craftbukkit.v1_21_R5.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftChatMessage;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.excellentenchants.EnchantsKeys;
import su.nightexpress.excellentenchants.api.EnchantDefinition;
import su.nightexpress.excellentenchants.api.EnchantDistribution;
import su.nightexpress.excellentenchants.api.enchantment.CustomEnchantment;
import su.nightexpress.excellentenchants.api.item.ItemSet;
import su.nightexpress.excellentenchants.api.wrapper.EnchantCost;
import su.nightexpress.excellentenchants.api.wrapper.TradeType;
import su.nightexpress.excellentenchants.bridge.DistributionSettings;
import su.nightexpress.excellentenchants.bridge.EnchantCatalogEntry;
import su.nightexpress.excellentenchants.bridge.RegistryHack;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.util.Reflex;
import su.nightexpress.nightcore.util.text.night.NightMessage;

public class RegistryHack_1_21_8
implements RegistryHack {
    private static final MinecraftServer SERVER = ((CraftServer)Bukkit.getServer()).getServer();
    private static final RegistryMaterials<Enchantment> ENCHANTS = (RegistryMaterials)SERVER.ba().a(Registries.aW).orElseThrow();
    private static final RegistryMaterials<Item> ITEMS = (RegistryMaterials)SERVER.ba().a(Registries.N).orElseThrow();
    private static final String REGISTRY_FROZEN_TAGS_FIELD = "j";
    private static final String REGISTRY_ALL_TAGS_FIELD = "k";
    private static final String TAG_SET_UNBOUND_METHOD = "a";
    private static final String TAG_SET_MAP_FIELD = "a";
    private final NightPlugin plugin;

    public RegistryHack_1_21_8(@NotNull NightPlugin plugin) {
        this.plugin = plugin;
    }

    @NotNull
    private static MinecraftKey customResourceLocation(@NotNull String value) {
        return CraftNamespacedKey.toMinecraft((NamespacedKey)EnchantsKeys.create(value));
    }

    private static <T> TagKey<T> customTagKey(@NotNull IRegistry<T> registry, @NotNull String name) {
        return TagKey.a((ResourceKey)registry.g(), (MinecraftKey)RegistryHack_1_21_8.customResourceLocation(name));
    }

    @NotNull
    private static ResourceKey<Enchantment> customEnchantKey(@NotNull String name) {
        MinecraftKey location = RegistryHack_1_21_8.customResourceLocation(name);
        return ResourceKey.a((ResourceKey)ENCHANTS.g(), (MinecraftKey)location);
    }

    @NotNull
    private static ResourceKey<Enchantment> enchantKey(@NotNull String name) {
        MinecraftKey location = MinecraftKey.a((String)name);
        return ResourceKey.a((ResourceKey)ENCHANTS.g(), (MinecraftKey)location);
    }

    private static TagKey<Item> customItemsTag(@NotNull String path) {
        return TagKey.a((ResourceKey)ITEMS.g(), (MinecraftKey)RegistryHack_1_21_8.customResourceLocation(path));
    }

    @NotNull
    private static <T> Map<TagKey<T>, HolderSet.Named<T>> getFrozenTags(@NotNull RegistryMaterials<T> registry) {
        return (Map)Reflex.getFieldValue(registry, (String)REGISTRY_FROZEN_TAGS_FIELD);
    }

    @NotNull
    private static <T> Object getAllTags(@NotNull RegistryMaterials<T> registry) {
        return Reflex.getFieldValue(registry, (String)REGISTRY_ALL_TAGS_FIELD);
    }

    @NotNull
    private static <T> Map<TagKey<T>, HolderSet.Named<T>> getTagsMap(@NotNull Object tagSet) {
        return new HashMap<TagKey<T>, HolderSet.Named<T>>((Map)Reflex.getFieldValue((Object)tagSet, (String)"a"));
    }

    @Override
    public void unfreezeRegistry() {
        RegistryHack_1_21_8.unfreeze(ENCHANTS);
        RegistryHack_1_21_8.unfreeze(ITEMS);
    }

    @Override
    public void freezeRegistry() {
        RegistryHack_1_21_8.freeze(ITEMS);
        RegistryHack_1_21_8.freeze(ENCHANTS);
    }

    private static <T> void unfreeze(@NotNull RegistryMaterials<T> registry) {
        Reflex.setFieldValue(registry, (String)"l", (Object)false);
        Reflex.setFieldValue(registry, (String)"m", new IdentityHashMap());
    }

    private static <T> void freeze(@NotNull RegistryMaterials<T> registry) {
        Object tagSet = RegistryHack_1_21_8.getAllTags(registry);
        Map<TagKey<T>, HolderSet.Named<T>> tagsMap = RegistryHack_1_21_8.getTagsMap(tagSet);
        Map<TagKey<T>, HolderSet.Named<T>> frozenTags = RegistryHack_1_21_8.getFrozenTags(registry);
        tagsMap.forEach(frozenTags::putIfAbsent);
        RegistryHack_1_21_8.unbound(registry);
        registry.n();
        frozenTags.forEach(tagsMap::putIfAbsent);
        Reflex.setFieldValue((Object)tagSet, (String)"a", tagsMap);
        Reflex.setFieldValue(registry, (String)REGISTRY_ALL_TAGS_FIELD, (Object)tagSet);
    }

    private static <T> void unbound(@NotNull RegistryMaterials<T> registry) {
        Class tagSetClass = Reflex.safeInnerClass((String)RegistryMaterials.class.getName(), (String)"a");
        Method unboundMethod = Reflex.safeMethod((Class)tagSetClass, (String)"a", (Class[])new Class[0]);
        Object unboundTagSet = Reflex.invokeMethod((Method)unboundMethod, registry, (Object[])new Object[0]);
        Reflex.setFieldValue(registry, (String)REGISTRY_ALL_TAGS_FIELD, (Object)unboundTagSet);
    }

    @Override
    public void addExclusives(@NotNull CustomEnchantment customEnchantment) {
        ResourceKey<Enchantment> enchantKey = RegistryHack_1_21_8.customEnchantKey(customEnchantment.getId());
        Enchantment enchantment = (Enchantment)ENCHANTS.c(enchantKey);
        if (enchantment == null) {
            this.plugin.error(customEnchantment.getId() + ": Could not set exclusive item list. Enchantment is not registered.");
            return;
        }
        TagKey<Enchantment> exclusivesKey = RegistryHack_1_21_8.customTagKey(ENCHANTS, "exclusive_set/" + customEnchantment.getId());
        customEnchantment.getDefinition().getExclusiveSet().forEach(enchantId -> {
            ResourceKey<Enchantment> conflictKey = RegistryHack_1_21_8.enchantKey(enchantId);
            Holder.c reference = ENCHANTS.a(conflictKey).orElse(null);
            if (reference == null) {
                return;
            }
            this.addInTag(exclusivesKey, (Holder.c<Enchantment>)reference);
        });
    }

    @Override
    @Nullable
    public org.bukkit.enchantments.Enchantment registerEnchantment(@NotNull EnchantCatalogEntry entry, @NotNull DistributionSettings settings) {
        String id = entry.getId();
        EnchantDefinition definition = entry.getDefinition();
        String primaryId = definition.getPrimaryItemSet().getId();
        String supportedId = definition.getSupportedItemSet().getId();
        HolderSet.Named<Item> supportedItems = RegistryHack_1_21_8.getFrozenTags(ITEMS).get(RegistryHack_1_21_8.customItemsTag(supportedId));
        HolderSet.Named<Item> primaryItems = RegistryHack_1_21_8.getFrozenTags(ITEMS).get(RegistryHack_1_21_8.customItemsTag(primaryId));
        IChatBaseComponent display = CraftChatMessage.fromJSON((String)NightMessage.asJson((String)definition.getDisplayName()));
        int weight = definition.getWeight();
        int maxLevel = definition.getMaxLevel();
        Enchantment.b minCost = RegistryHack_1_21_8.nmsCost(definition.getMinCost());
        Enchantment.b maxCost = RegistryHack_1_21_8.nmsCost(definition.getMaxCost());
        int anvilCost = definition.getAnvilCost();
        EquipmentSlotGroup[] slots = RegistryHack_1_21_8.nmsSlots(definition.getSupportedItemSet().getSlots());
        Enchantment.c nmsDefinition = Enchantment.a(supportedItems, primaryItems, (int)weight, (int)maxLevel, (Enchantment.b)minCost, (Enchantment.b)maxCost, (int)anvilCost, (EquipmentSlotGroup[])slots);
        HolderSet.Named<Enchantment> exclusiveSet = this.createExclusiveSet(id);
        DataComponentMap.a builder = DataComponentMap.a();
        Enchantment enchantment = new Enchantment(display, nmsDefinition, exclusiveSet, builder.a());
        Holder.c reference = ENCHANTS.f((Object)enchantment);
        IRegistry.a(ENCHANTS, RegistryHack_1_21_8.customEnchantKey(id), (Object)enchantment);
        this.setupDistribution(entry, settings, (Holder.c<Enchantment>)reference);
        return CraftEnchantment.minecraftToBukkit((Enchantment)enchantment);
    }

    private void setupDistribution(@NotNull EnchantCatalogEntry entry, @NotNull DistributionSettings settings, @NotNull Holder.c<Enchantment> reference) {
        EnchantDistribution distribution = entry.getDistribution();
        boolean experimentalTrades = SERVER.aZ().K().b(FeatureFlags.b);
        if (distribution.isTreasure()) {
            this.addInTag((TagKey<Enchantment>)EnchantmentTags.u, reference);
            this.addInTag((TagKey<Enchantment>)EnchantmentTags.j, reference);
        } else {
            this.addInTag((TagKey<Enchantment>)EnchantmentTags.v, reference);
        }
        if (distribution.isOnRandomLoot() && settings.isRandomLootEnabled()) {
            this.addInTag((TagKey<Enchantment>)EnchantmentTags.n, reference);
        }
        if (!distribution.isTreasure()) {
            if (distribution.isOnMobSpawnEquipment() && settings.isMobEquipmentEnabled()) {
                this.addInTag((TagKey<Enchantment>)EnchantmentTags.l, reference);
            }
            if (distribution.isOnTradedEquipment() && settings.isTradeEquipmentEnabled()) {
                this.addInTag((TagKey<Enchantment>)EnchantmentTags.m, reference);
            }
        }
        if (experimentalTrades) {
            if (distribution.isTradable() && settings.isTradingEnabled()) {
                distribution.getTrades().forEach(tradeType -> this.addInTag(RegistryHack_1_21_8.getTradeKey(tradeType), reference));
            }
        } else if (distribution.isTradable() && settings.isTradingEnabled()) {
            this.addInTag((TagKey<Enchantment>)EnchantmentTags.i, reference);
        } else {
            this.removeFromTag((TagKey<Enchantment>)EnchantmentTags.i, reference);
        }
        if (entry.isCurse()) {
            this.addInTag((TagKey<Enchantment>)EnchantmentTags.o, reference);
        } else if (!distribution.isTreasure()) {
            if (distribution.isDiscoverable() && settings.isEnchantingEnabled()) {
                this.addInTag((TagKey<Enchantment>)EnchantmentTags.k, reference);
            } else {
                this.removeFromTag((TagKey<Enchantment>)EnchantmentTags.k, reference);
            }
        }
    }

    private void addInTag(@NotNull TagKey<Enchantment> tagKey, @NotNull Holder.c<Enchantment> reference) {
        this.modfiyTag(ENCHANTS, tagKey, reference, List::add);
    }

    private void removeFromTag(@NotNull TagKey<Enchantment> tagKey, @NotNull Holder.c<Enchantment> reference) {
        this.modfiyTag(ENCHANTS, tagKey, reference, List::remove);
    }

    private <T> void modfiyTag(@NotNull RegistryMaterials<T> registry, @NotNull TagKey<T> tagKey, @NotNull Holder.c<T> reference, @NotNull BiConsumer<List<Holder<T>>, Holder.c<T>> consumer) {
        HolderSet.Named holders = registry.a(tagKey).orElse(null);
        if (holders == null) {
            this.plugin.warn(String.valueOf(tagKey) + ": Could not modify HolderSet. HolderSet is NULL.");
            return;
        }
        ArrayList contents = new ArrayList(holders.a().toList());
        consumer.accept(contents, reference);
        registry.a(tagKey, contents);
    }

    @Override
    public void createItemsSet(@NotNull ItemSet itemSet) {
        TagKey<Item> tag = RegistryHack_1_21_8.customItemsTag(itemSet.getId());
        ArrayList holders = new ArrayList();
        itemSet.getMaterials().forEach(material -> {
            MinecraftKey location = MinecraftKey.b((String)material);
            Holder.c holder = ITEMS.c(location).orElse(null);
            if (holder == null) {
                return;
            }
            holders.add(holder);
        });
        ITEMS.a(tag, holders);
    }

    @NotNull
    private HolderSet.Named<Enchantment> createExclusiveSet(@NotNull String id) {
        TagKey<Enchantment> customKey = RegistryHack_1_21_8.customTagKey(ENCHANTS, "exclusive_set/" + id);
        ArrayList holders = new ArrayList();
        ENCHANTS.a(customKey, holders);
        return RegistryHack_1_21_8.getFrozenTags(ENCHANTS).get(customKey);
    }

    @NotNull
    private static TagKey<Enchantment> getTradeKey(@NotNull TradeType tradeType) {
        return switch (tradeType) {
            default -> throw new MatchException(null, null);
            case TradeType.DESERT_COMMON -> EnchantmentTags.w;
            case TradeType.DESERT_SPECIAL -> EnchantmentTags.D;
            case TradeType.PLAINS_COMMON -> EnchantmentTags.y;
            case TradeType.PLAINS_SPECIAL -> EnchantmentTags.F;
            case TradeType.SAVANNA_COMMON -> EnchantmentTags.z;
            case TradeType.SAVANNA_SPECIAL -> EnchantmentTags.G;
            case TradeType.JUNGLE_COMMON -> EnchantmentTags.x;
            case TradeType.JUNGLE_SPECIAL -> EnchantmentTags.E;
            case TradeType.SNOW_COMMON -> EnchantmentTags.A;
            case TradeType.SNOW_SPECIAL -> EnchantmentTags.H;
            case TradeType.SWAMP_COMMON -> EnchantmentTags.B;
            case TradeType.SWAMP_SPECIAL -> EnchantmentTags.I;
            case TradeType.TAIGA_COMMON -> EnchantmentTags.C;
            case TradeType.TAIGA_SPECIAL -> EnchantmentTags.J;
        };
    }

    @NotNull
    private static Enchantment.b nmsCost(@NotNull EnchantCost cost) {
        return new Enchantment.b(cost.base(), cost.perLevel());
    }

    private static EquipmentSlotGroup[] nmsSlots(@NotNull EquipmentSlot[] slots) {
        EquipmentSlotGroup[] nmsSlots = new EquipmentSlotGroup[slots.length];
        for (int index = 0; index < nmsSlots.length; ++index) {
            EquipmentSlot bukkitSlot = slots[index];
            nmsSlots[index] = CraftEquipmentSlot.getNMSGroup((org.bukkit.inventory.EquipmentSlotGroup)bukkitSlot.getGroup());
        }
        return nmsSlots;
    }
}

