/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.manager.listener;

import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.config.Config;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;

public class GenericListener
extends AbstractListener<EnchantsPlugin> {
    private final EnchantManager manager;

    public GenericListener(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager) {
        super((NightCorePlugin)plugin);
        this.manager = manager;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) {
        this.manager.setSpawnReason((Entity)event.getEntity(), event.getSpawnReason());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChargesFillOnEnchant(EnchantItemEvent event) {
        if (!Config.isChargesEnabled()) {
            return;
        }
        ((EnchantsPlugin)this.plugin).runTask(() -> {
            Inventory inventory = event.getInventory();
            ItemStack result = inventory.getItem(0);
            if (result == null) {
                return;
            }
            event.getEnchantsToAdd().forEach((enchantment, level) -> EnchantsUtils.restoreCharges(result, enchantment, level));
            inventory.setItem(0, result);
        });
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTickedBlockBreak(BlockBreakEvent event) {
        if (this.manager.removeTickedBlock(event.getBlock())) {
            event.setDropItems(false);
            event.setExpToDrop(0);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTickedBlockTNTExplode(BlockExplodeEvent event) {
        event.blockList().forEach(this.manager::removeTickedBlock);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onTickedBlockEntityExplode(EntityExplodeEvent event) {
        event.blockList().forEach(this.manager::removeTickedBlock);
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            this.manager.handleEnchantExplosion(event, entity2);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onExplosionDamage(EntityDamageByEntityEvent event) {
        DamageSource source = event.getDamageSource();
        DamageType type = source.getDamageType();
        if (type != DamageType.PLAYER_EXPLOSION && type != DamageType.EXPLOSION) {
            return;
        }
        Entity entity = source.getCausingEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        this.manager.handleEnchantExplosionDamage(event, entity2);
    }
}

