/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.tool;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockDropItemEvent;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.BlockDropEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.bridge.wrap.NightSound;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.BukkitThing;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.sound.VanillaSound;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class SmelterEnchant
extends GameEnchantment
implements BlockDropEnchant {
    private NightSound sound;
    private boolean disableOnCrouch;
    private final Set<Material> exemptedItems;
    private final Set<FurnaceRecipe> recipes;

    public SmelterEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(15.0, 5.0));
        this.exemptedItems = new HashSet<Material>();
        this.recipes = new HashSet<FurnaceRecipe>();
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.disableOnCrouch = (Boolean)ConfigValue.create((String)"Smelter.Disable_On_Crouch", (boolean)true, (String[])new String[]{"Sets whether or not enchantment will have no effect when crouching."}).read(config);
        this.sound = (NightSound)ConfigValue.create((String)"Smelter.Sound", (NightSound)VanillaSound.of((Sound)Sound.BLOCK_LAVA_EXTINGUISH), (String[])new String[]{"Sound to play on smelting."}).read(config);
        this.recipes.clear();
        this.exemptedItems.clear();
        this.exemptedItems.addAll((Collection)ConfigValue.forSet((String)"Smelter.Exempted_Blocks", BukkitThing::getMaterial, (cfg, path, set) -> cfg.set(path, set.stream().map(BukkitThing::getAsString).toList()), (Set)Lists.newSet((Object[])new Material[]{Material.COBBLESTONE}), (String[])new String[]{"List of blocks / items that are immune to the Smelter effect."}).read(config));
        this.plugin.getServer().recipeIterator().forEachRemaining(recipe -> {
            if (!(recipe instanceof FurnaceRecipe)) {
                return;
            }
            FurnaceRecipe furnaceRecipe = (FurnaceRecipe)recipe;
            if (!this.exemptedItems.contains(furnaceRecipe.getInput().getType())) {
                this.recipes.add(furnaceRecipe);
            }
        });
    }

    @Override
    @NotNull
    public EnchantPriority getDropPriority() {
        return EnchantPriority.LOW;
    }

    @Override
    public boolean onDrop(@NotNull BlockDropItemEvent event, @NotNull LivingEntity entity, @NotNull ItemStack item, int level) {
        Player player;
        if (this.disableOnCrouch && entity instanceof Player && (player = (Player)entity).isSneaking()) {
            return false;
        }
        BlockState state = event.getBlockState();
        if (state instanceof Container) {
            return false;
        }
        ArrayList smelts = new ArrayList();
        event.getItems().removeIf(drop -> {
            FurnaceRecipe recipe = this.recipes.stream().filter(rec -> rec.getInputChoice().test(drop.getItemStack())).findFirst().orElse(null);
            if (recipe == null) {
                return false;
            }
            int amount = drop.getItemStack().getAmount();
            ItemStack result = new ItemStack(recipe.getResult());
            result.setAmount(amount);
            smelts.add(result);
            return true;
        });
        if (smelts.isEmpty()) {
            return false;
        }
        smelts.forEach(itemStack -> EnchantsUtils.populateResource(event, itemStack));
        Block block = state.getBlock();
        if (this.hasVisualEffects()) {
            Location location = LocationUtil.setCenter3D((Location)block.getLocation());
            UniParticle.of((Particle)Particle.FLAME).play(location, 0.25, 0.05, 20);
            this.sound.play(location);
        }
        return true;
    }
}

