/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.tool;

import java.nio.file.Path;
import java.util.HashSet;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.spawner.Spawner;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.BlockEnchant;
import su.nightexpress.excellentenchants.api.enchantment.type.MiningEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.ItemUtil;
import su.nightexpress.nightcore.util.LangUtil;
import su.nightexpress.nightcore.util.LocationUtil;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class SilkSpawnerEnchant
extends GameEnchantment
implements MiningEnchant,
BlockEnchant {
    private String spawnerName;

    public SilkSpawnerEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(0.0, 25.0));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.spawnerName = (String)ConfigValue.create((String)"SilkSpawner.Name", (String)TagWrappers.GREEN.wrap(LangUtil.getSerializedName((Material)Material.SPAWNER) + " " + TagWrappers.GRAY.wrap("(" + TagWrappers.WHITE.wrap("%type%") + ")")), (String[])new String[]{"Spawner item display name.", "Use '%type%' for the mob name."}).read(config);
    }

    @NotNull
    public ItemStack getSpawner(@NotNull CreatureSpawner spawnerBlock) {
        ItemStack itemSpawner = new ItemStack(Material.SPAWNER);
        BlockStateMeta stateMeta = (BlockStateMeta)itemSpawner.getItemMeta();
        if (stateMeta == null || spawnerBlock.getSpawnedType() == null) {
            return itemSpawner;
        }
        CreatureSpawner spawnerItem = (CreatureSpawner)stateMeta.getBlockState();
        this.transferSettings((Spawner)spawnerBlock, (Spawner)spawnerItem);
        spawnerItem.update(true);
        stateMeta.setBlockState((BlockState)spawnerItem);
        ItemUtil.setCustomName((ItemMeta)stateMeta, (String)this.spawnerName.replace("%type%", LangUtil.getSerializedName((EntityType)spawnerBlock.getSpawnedType())));
        itemSpawner.setItemMeta((ItemMeta)stateMeta);
        this.manager.setBlockEnchant(itemSpawner, this);
        return itemSpawner;
    }

    @Override
    @NotNull
    public EnchantPriority getBreakPriority() {
        return EnchantPriority.LOW;
    }

    @Override
    public boolean canPlaceInContainers() {
        return true;
    }

    @Override
    public boolean onBreak(@NotNull BlockBreakEvent event, @NotNull LivingEntity player, @NotNull ItemStack item, int level) {
        Block block = event.getBlock();
        BlockState blockState = block.getState();
        if (!(blockState instanceof CreatureSpawner)) {
            return false;
        }
        CreatureSpawner spawner = (CreatureSpawner)blockState;
        event.setExpToDrop(0);
        event.setDropItems(true);
        Location location = LocationUtil.setCenter3D((Location)block.getLocation());
        World world = block.getWorld();
        world.dropItemNaturally(location, this.getSpawner(spawner));
        return true;
    }

    @Override
    public void onPlace(@NotNull BlockPlaceEvent event, @NotNull Player player, @NotNull Block block, @NotNull ItemStack itemStack) {
        if (block.getType() != Material.SPAWNER) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta stateMeta = (BlockStateMeta)itemMeta;
        CreatureSpawner spawnerItem = (CreatureSpawner)stateMeta.getBlockState();
        CreatureSpawner spawnerBlock = (CreatureSpawner)block.getState();
        this.transferSettings((Spawner)spawnerItem, (Spawner)spawnerBlock);
        spawnerBlock.update(true);
    }

    private void transferSettings(@NotNull Spawner from, @NotNull Spawner to) {
        to.setPotentialSpawns(new HashSet());
        if (from.getPotentialSpawns().isEmpty()) {
            to.setSpawnedType(from.getSpawnedType());
        } else {
            from.getPotentialSpawns().forEach(arg_0 -> ((Spawner)to).addPotentialSpawn(arg_0));
        }
        to.setDelay(from.getMinSpawnDelay());
        to.setMinSpawnDelay(from.getMinSpawnDelay());
        to.setMaxSpawnDelay(from.getMaxSpawnDelay());
        to.setMaxNearbyEntities(from.getMaxNearbyEntities());
        to.setRequiredPlayerRange(from.getRequiredPlayerRange());
        to.setSpawnCount(from.getSpawnCount());
        to.setSpawnRange(from.getSpawnRange());
    }
}

