/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.bow;

import java.nio.file.Path;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityRegainHealthEvent;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.ArrowEffects;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.ArrowEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.EntityUtil;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.wrapper.UniParticle;

public class VampiricArrowsEnchant
extends GameEnchantment
implements ArrowEnchant {
    private Modifier healAmount;

    public VampiricArrowsEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.ARROW, new ArrowEffects(UniParticle.redstone((Color)Color.RED, (float)1.0f)));
        this.addComponent(EnchantComponent.PROBABILITY, Probability.addictive(20.0, 5.0));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.healAmount = Modifier.load(config, "Vampire.Heal_Amount", Modifier.addictive(1.0).perLevel(0.5).capacity(5.0), "Amount of hearts to be restore.");
        this.addPlaceholder("%amount%", level -> NumberUtil.format((double)this.getHealAmount((int)level)));
    }

    public double getHealAmount(int level) {
        return this.healAmount.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getShootPriority() {
        return EnchantPriority.HIGHEST;
    }

    @Override
    public boolean onShoot(@NotNull EntityShootBowEvent event, @NotNull LivingEntity shooter, @NotNull ItemStack bow, int level) {
        return event.getProjectile() instanceof Arrow;
    }

    @Override
    public void onHit(@NotNull ProjectileHitEvent event, @NotNull LivingEntity shooter, @NotNull Arrow arrow, int level) {
    }

    @Override
    public void onDamage(@NotNull EntityDamageByEntityEvent event, @NotNull LivingEntity shooter, @NotNull LivingEntity victim, @NotNull Arrow arrow, int level) {
        double maxHealth;
        if (shooter.isDead() || shooter.getHealth() <= 0.0) {
            return;
        }
        double healAmount = this.getHealAmount(level);
        if (healAmount <= 0.0) {
            return;
        }
        double health = shooter.getHealth();
        if (health >= (maxHealth = EntityUtil.getAttributeValue((LivingEntity)shooter, (Attribute)Attribute.MAX_HEALTH))) {
            return;
        }
        EntityRegainHealthEvent healthEvent = new EntityRegainHealthEvent((Entity)shooter, healAmount, EntityRegainHealthEvent.RegainReason.CUSTOM);
        this.plugin.getPluginManager().callEvent((Event)healthEvent);
        if (healthEvent.isCancelled()) {
            return;
        }
        shooter.setHealth(Math.min(maxHealth, health + healAmount));
        if (this.hasVisualEffects()) {
            UniParticle.of((Particle)Particle.HEART).play(shooter.getEyeLocation(), 0.25, (double)0.15f, 5);
        }
    }
}

