/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.bow;

import java.nio.file.Path;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SmallFireball;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.EnchantsUtils;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.BowEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;

public class GhastEnchant
extends GameEnchantment
implements BowEnchant {
    private boolean fireSpread;
    private Modifier yield;

    public GhastEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.oneHundred());
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.fireSpread = (Boolean)ConfigValue.create((String)"Fireball.Fire_Spread", (boolean)true, (String[])new String[]{"Controls whether fireball explosion sets nearby blocks on fire."}).read(config);
        this.yield = Modifier.load(config, "Fireball.Yield", Modifier.addictive(2.0).perLevel(0.0).capacity(5.0), "Fireball explosion power.");
    }

    public boolean isFireSpread() {
        return this.fireSpread;
    }

    public float getYield(int level) {
        return (float)this.yield.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getShootPriority() {
        return EnchantPriority.LOWEST;
    }

    @Override
    public boolean onShoot(@NotNull EntityShootBowEvent event, @NotNull LivingEntity shooter, @NotNull ItemStack bow, int level) {
        Fireball fireball;
        Entity entity = event.getProjectile();
        if (!(entity instanceof Projectile)) {
            return false;
        }
        Projectile projectile = (Projectile)entity;
        if (EnchantsUtils.contains(bow, Enchantment.MULTISHOT)) {
            fireball = (Fireball)shooter.launchProjectile(SmallFireball.class);
            fireball.setVelocity(projectile.getVelocity().normalize().multiply(0.5f));
        } else {
            fireball = (Fireball)shooter.launchProjectile(Fireball.class);
            fireball.setDirection(projectile.getVelocity());
        }
        fireball.setIsIncendiary(this.fireSpread);
        fireball.setYield(this.getYield(level));
        event.setProjectile((Entity)fireball);
        return true;
    }
}

