/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.bow;

import java.nio.file.Path;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.entity.EntityShootBowEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Charges;
import su.nightexpress.excellentenchants.api.enchantment.meta.Probability;
import su.nightexpress.excellentenchants.api.enchantment.type.BowEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.NumberUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;

public class BomberEnchant
extends GameEnchantment
implements BowEnchant {
    private Modifier fuseTicks;

    public BomberEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PROBABILITY, Probability.oneHundred());
        this.addComponent(EnchantComponent.CHARGES, Charges.custom(Modifier.addictive(50.0).perLevel(10.0).build(), 1, 1, NightItem.fromType((Material)Material.TNT)));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.fuseTicks = Modifier.load(config, "Bomber.Fuse_Ticks", Modifier.addictive(40.0).perLevel(10.0).capacity(200.0), "Sets TNT fuse ticks.");
        this.addPlaceholder("%time%", level -> NumberUtil.format((double)((double)this.getFuseTicks((int)level) / 20.0)));
    }

    public int getFuseTicks(int level) {
        return (int)this.fuseTicks.getValue(level);
    }

    @Override
    @NotNull
    public EnchantPriority getShootPriority() {
        return EnchantPriority.LOWEST;
    }

    @Override
    public boolean onShoot(@NotNull EntityShootBowEvent event, @NotNull LivingEntity shooter, @NotNull ItemStack bow, int level) {
        Entity entity = event.getProjectile();
        if (!(entity instanceof Projectile)) {
            return false;
        }
        Projectile projectile = (Projectile)entity;
        int fuseTicks = Math.max(1, this.getFuseTicks(level));
        TNTPrimed primed = (TNTPrimed)projectile.getWorld().spawn(projectile.getLocation(), TNTPrimed.class);
        primed.setVelocity(projectile.getVelocity().multiply((double)event.getForce() * 1.25));
        primed.setFuseTicks(fuseTicks);
        primed.setSource((Entity)shooter);
        event.setProjectile((Entity)primed);
        return true;
    }
}

