/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.armor;

import java.nio.file.Path;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.enchantment.component.EnchantComponent;
import su.nightexpress.excellentenchants.api.enchantment.meta.Period;
import su.nightexpress.excellentenchants.api.enchantment.type.PassiveEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.NumberUtil;

public class SaturationEnchant
extends GameEnchantment
implements PassiveEnchant {
    private Modifier feedAmount;
    private Modifier maxFoodLevel;

    public SaturationEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
        this.addComponent(EnchantComponent.PERIODIC, Period.ofSeconds(15));
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.feedAmount = Modifier.load(config, "Saturation.Amount", Modifier.addictive(0.0).perLevel(1.0).capacity(5.0), "Amount of food points to restore.");
        this.maxFoodLevel = Modifier.load(config, "Saturation.Max_Food_Level", Modifier.addictive(20.0), "Max. food level where saturation stops.");
        this.addPlaceholder("%amount%", level -> NumberUtil.format((double)this.getFeedAmount((int)level)));
        this.addPlaceholder("%max%", level -> NumberUtil.format((double)this.getMaxFoodLevel((int)level)));
    }

    public final int getFeedAmount(int level) {
        return (int)this.feedAmount.getValue(level);
    }

    public final int getMaxFoodLevel(int level) {
        return (int)this.maxFoodLevel.getValue(level);
    }

    @Override
    public boolean onTrigger(@NotNull LivingEntity entity, @NotNull ItemStack item, int level) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        if (player.getFoodLevel() >= this.getMaxFoodLevel(level)) {
            return false;
        }
        int amount = this.getFeedAmount(level);
        player.setFoodLevel(Math.min(20, player.getFoodLevel() + amount));
        return true;
    }
}

