/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.enchantment.armor;

import java.nio.file.Path;
import java.util.Set;
import org.bukkit.damage.DamageSource;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.EnchantsPlugin;
import su.nightexpress.excellentenchants.api.EnchantPriority;
import su.nightexpress.excellentenchants.api.Modifier;
import su.nightexpress.excellentenchants.api.damage.DamageBonus;
import su.nightexpress.excellentenchants.api.damage.DamageBonusType;
import su.nightexpress.excellentenchants.api.enchantment.type.ProtectionEnchant;
import su.nightexpress.excellentenchants.enchantment.EnchantContext;
import su.nightexpress.excellentenchants.enchantment.GameEnchantment;
import su.nightexpress.excellentenchants.manager.EnchantManager;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.NumberUtil;

public class ElementalProtectionEnchant
extends GameEnchantment
implements ProtectionEnchant {
    private static final Set<DamageType> DAMAGE_CAUSES = Lists.newSet((Object[])new DamageType[]{DamageType.WITHER, DamageType.MAGIC, DamageType.FREEZE, DamageType.LIGHTNING_BOLT});
    private Modifier amount;
    private double capacity;
    private boolean multiplier;

    public ElementalProtectionEnchant(@NotNull EnchantsPlugin plugin, @NotNull EnchantManager manager, @NotNull Path file, @NotNull EnchantContext context) {
        super(plugin, manager, file, context);
    }

    @Override
    protected void loadAdditional(@NotNull FileConfig config) {
        this.amount = Modifier.load(config, "Protection.Amount", Modifier.addictive(0.0).perLevel(5.0).capacity(25.0), "Protection amount given by enchantment.");
        this.capacity = (Double)ConfigValue.create((String)"Protection.Capacity", (double)80.0, (String[])new String[]{"Max. possible protection value from all armor pieces."}).read(config);
        this.multiplier = (Boolean)ConfigValue.create((String)"Protection.Multiplier", (boolean)true, (String[])new String[]{"Controls if protection amount is in percent."}).read(config);
        this.addPlaceholder("%amount%", level -> NumberUtil.format((double)this.getProtectionAmount((int)level)));
        this.addPlaceholder("%max%", level -> NumberUtil.format((double)this.getCapacity()));
    }

    public double getProtectionAmount(int level) {
        return this.amount.getValue(level);
    }

    public double getCapacity() {
        return this.capacity;
    }

    public boolean isMultiplier() {
        return this.multiplier;
    }

    @Override
    @NotNull
    public EnchantPriority getProtectionPriority() {
        return EnchantPriority.NORMAL;
    }

    @Override
    @NotNull
    public DamageBonus getDamageBonus() {
        return new DamageBonus(this.multiplier ? DamageBonusType.MULTIPLIER : DamageBonusType.NORMAL);
    }

    @Override
    public boolean onProtection(@NotNull EntityDamageEvent event, @NotNull DamageBonus damageBonus, @NotNull LivingEntity entity, @NotNull ItemStack itemStack, int level) {
        DamageSource source = event.getDamageSource();
        DamageType type = source.getDamageType();
        if (!DAMAGE_CAUSES.contains(type)) {
            return false;
        }
        double protectionAmount = this.getProtectionAmount(level);
        if (protectionAmount <= 0.0) {
            return false;
        }
        damageBonus.addPenalty(protectionAmount, this.capacity);
        return true;
    }
}

