/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentenchants.api;

import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentenchants.api.ModifierAction;
import su.nightexpress.nightcore.config.ConfigValue;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.config.Writeable;

public class Modifier
implements Writeable {
    private final double base;
    private final double perLevel;
    private final double capacity;
    private final ModifierAction action;

    public Modifier(double base, double perLevel, double capacity, @NotNull ModifierAction action) {
        this.base = base;
        this.perLevel = perLevel;
        this.capacity = capacity;
        this.action = action;
    }

    @NotNull
    public static Builder addictive(double base) {
        return new Builder(base, ModifierAction.ADD);
    }

    @NotNull
    public static Builder multiplier(double base) {
        return new Builder(base, ModifierAction.MULTIPLY);
    }

    @NotNull
    public static Modifier load(@NotNull FileConfig config, @NotNull String path, @NotNull Builder builder, String ... comments) {
        return Modifier.load(config, path, builder.build(), comments);
    }

    @NotNull
    public static Modifier load(@NotNull FileConfig config, @NotNull String path, @NotNull Modifier def, String ... comments) {
        return (Modifier)ConfigValue.create((String)path, Modifier::read, (Object)def, (String[])comments).read(config);
    }

    @NotNull
    public static Modifier read(@NotNull FileConfig config, @NotNull String path) {
        double base = (Double)ConfigValue.create((String)(path + ".Base"), (double)0.0, (String[])new String[0]).read(config);
        double perLevel = (Double)ConfigValue.create((String)(path + ".Per_Level"), (double)0.0, (String[])new String[0]).read(config);
        double cap = ((Integer)ConfigValue.create((String)(path + ".Capacity"), (int)-1, (String[])new String[0]).read(config)).intValue();
        ModifierAction action = (ModifierAction)((Object)ConfigValue.create((String)(path + ".Action"), ModifierAction.class, (Enum)ModifierAction.ADD, (String[])new String[0]).read(config));
        return new Modifier(base, perLevel, cap, action);
    }

    public void write(@NotNull FileConfig config, @NotNull String path) {
        config.set(path + ".Base", (Object)this.base);
        config.set(path + ".Per_Level", (Object)this.perLevel);
        config.set(path + ".Capacity", (Object)this.capacity);
        config.set(path + ".Action", (Object)this.action.name());
    }

    public double getValue(int level) {
        if (this.perLevel == 0.0) {
            return this.base;
        }
        double result = this.action.math(this.base, this.perLevel * (double)level);
        return this.capValue(result);
    }

    public double capValue(double result) {
        return this.capacity > 0.0 ? Math.min(result, this.capacity) : result;
    }

    public int getIntValue(int level) {
        return (int)this.getValue(level);
    }

    public double getBase() {
        return this.base;
    }

    public double getPerLevel() {
        return this.perLevel;
    }

    public double getCapacity() {
        return this.capacity;
    }

    @NotNull
    public ModifierAction getAction() {
        return this.action;
    }

    public static class Builder {
        private final double base;
        private final ModifierAction action;
        private double perLevel;
        private double capacity;

        public Builder(double base, @NotNull ModifierAction action) {
            this.base = base;
            this.action = action;
            this.perLevel = 0.0;
            this.capacity = -1.0;
        }

        @NotNull
        public Modifier build() {
            return new Modifier(this.base, this.perLevel, this.capacity, this.action);
        }

        @NotNull
        public Builder perLevel(double perLevel) {
            this.perLevel = perLevel;
            return this;
        }

        @NotNull
        public Builder capacity(double capacity) {
            this.capacity = capacity;
            return this;
        }
    }
}

