/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.util;

import java.util.Optional;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.bridge.item.ItemAdapter;
import su.nightexpress.nightcore.config.FileConfig;
import su.nightexpress.nightcore.integration.item.ItemBridge;
import su.nightexpress.nightcore.integration.item.adapter.IdentifiableItemAdapter;
import su.nightexpress.nightcore.integration.item.data.ItemIdData;
import su.nightexpress.nightcore.integration.item.impl.AdaptedCustomStack;
import su.nightexpress.nightcore.integration.item.impl.AdaptedItemStack;
import su.nightexpress.nightcore.integration.item.impl.AdaptedVanillaStack;
import su.nightexpress.nightcore.util.ItemTag;
import su.nightexpress.nightcore.util.Version;

public class ItemHelper {
    @NotNull
    public static AdaptedItem readOrPlaceholder(@NotNull FileConfig config, @NotNull String path) {
        return ItemHelper.read(config, path).orElse(ItemHelper.vanilla(CrateUtils.getQuestionStack()));
    }

    @NotNull
    public static Optional<AdaptedItem> read(@NotNull FileConfig config, @NotNull String path) {
        String oldType = config.getString(path + ".Type");
        if (oldType != null) {
            AdaptedVanillaStack adaptedItem = null;
            if (oldType.equalsIgnoreCase("vanilla")) {
                ItemTag tag;
                String itemTag = config.getString(path + ".ItemTag");
                if (itemTag != null) {
                    tag = new ItemTag(itemTag, Version.MC_1_21.getDataVersion());
                    config.set(path + ".Tag", (Object)tag);
                    config.remove(path + ".ItemTag");
                }
                if (config.contains(path + ".Tag")) {
                    tag = ItemTag.read((FileConfig)config, (String)(path + ".Tag"));
                    adaptedItem = new AdaptedVanillaStack(tag);
                    config.remove(path + ".Tag");
                }
            } else if (oldType.equalsIgnoreCase("custom")) {
                String handlerName = config.getString(path + ".Handler", "null");
                String itemId = config.getString(path + ".ItemId", "null");
                int amount = config.getInt(path + ".Amount");
                config.remove(path + ".Handler");
                config.remove(path + ".ItemId");
                config.remove(path + ".Amount");
                ItemAdapter adapter = ItemBridge.getAdapter((String)handlerName);
                if (adapter instanceof IdentifiableItemAdapter) {
                    IdentifiableItemAdapter identifiableItemAdapter = (IdentifiableItemAdapter)adapter;
                    adaptedItem = new AdaptedCustomStack((ItemAdapter)identifiableItemAdapter, new ItemIdData(itemId, amount));
                } else if (adapter == null) {
                    config.set(path + ".Provider", (Object)handlerName);
                    config.set(path + ".Data.ID", (Object)itemId);
                    config.set(path + ".Data.Amount", (Object)amount);
                }
            }
            config.remove(path + ".Type");
            if (adaptedItem != null) {
                config.set(path, adaptedItem);
            }
        }
        return Optional.ofNullable(AdaptedItemStack.read((FileConfig)config, (String)path));
    }

    @NotNull
    public static ItemStack toItemStack(@NotNull AdaptedItem item) {
        return item.itemStack().orElse(CrateUtils.getQuestionStack());
    }

    public static boolean isCustom(@NotNull ItemStack itemStack) {
        ItemAdapter adapter = ItemBridge.getAdapter((ItemStack)itemStack);
        return adapter != null && !adapter.isVanilla();
    }

    @NotNull
    public static AdaptedItem vanilla(@NotNull ItemStack itemStack) {
        return AdaptedVanillaStack.of((ItemStack)itemStack);
    }

    @NotNull
    public static AdaptedItem adapt(@NotNull ItemStack itemStack) {
        ItemAdapter adapter = ItemBridge.getAdapterOrVanilla((ItemStack)itemStack);
        AdaptedItem item = adapter.adapt(itemStack).orElse(null);
        return item == null ? ItemHelper.vanilla(itemStack) : item;
    }

    @NotNull
    public static AdaptedItem adapt(@NotNull ItemStack itemStack, boolean allowCustoms) {
        return allowCustoms ? ItemHelper.adapt(itemStack) : ItemHelper.vanilla(itemStack);
    }
}

