/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.key;

import java.util.stream.Stream;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.key.KeyManager;
import su.nightexpress.nightcore.NightCorePlugin;
import su.nightexpress.nightcore.manager.AbstractListener;

public class KeyListener
extends AbstractListener<CratesPlugin> {
    private final KeyManager manager;

    public KeyListener(@NotNull CratesPlugin plugin, @NotNull KeyManager manager) {
        super((NightCorePlugin)plugin);
        this.manager = manager;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.manager.giveKeysOnHold(player);
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onKeyPlace(BlockPlaceEvent event) {
        ItemStack item = event.getItemInHand();
        if (this.manager.isKey(item)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onKeyUse(PlayerInteractEvent event) {
        if (event.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (event.useInteractedBlock() == Event.Result.DENY) {
            return;
        }
        ItemStack item = event.getItem();
        if (item != null && this.manager.isKey(item)) {
            Player player = event.getPlayer();
            Block clickedBlock = event.getClickedBlock();
            if (clickedBlock != null && clickedBlock.getType().isInteractable() && !player.isSneaking()) {
                return;
            }
            event.setUseItemInHand(Event.Result.DENY);
            event.setUseInteractedBlock(Event.Result.DENY);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onKeyAnvilStop(PrepareAnvilEvent event) {
        AnvilInventory inventory = event.getInventory();
        ItemStack first = inventory.getItem(0);
        ItemStack second = inventory.getItem(1);
        if (first != null && this.manager.isKey(first) || second != null && this.manager.isKey(second)) {
            event.setResult(null);
        }
    }

    private boolean doesRecipeContainKeys(Recipe recipe) {
        Stream<Object> choices;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            choices = shaped.getChoiceMap().values().stream();
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe shapeless = (ShapelessRecipe)recipe;
            choices = shapeless.getChoiceList().stream();
        } else {
            return false;
        }
        return choices.filter(RecipeChoice.ExactChoice.class::isInstance).map(RecipeChoice.ExactChoice.class::cast).flatMap(choice -> choice.getChoices().stream()).anyMatch(this.manager::isKey);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onKeyCraftStop(CraftItemEvent event) {
        if (this.doesRecipeContainKeys(event.getRecipe())) {
            return;
        }
        CraftingInventory inventory = event.getInventory();
        if (Stream.of(inventory.getMatrix()).anyMatch(item -> item != null && this.manager.isKey((ItemStack)item))) {
            event.setCancelled(true);
        }
    }
}

