/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.key;

import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.dialog.DialogRegistry;
import su.nightexpress.excellentcrates.dialog.generic.GenericItemDialog;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.excellentcrates.key.dialog.KeyDialogs;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.click.ClickResult;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class KeyOptionsMenu
extends LinkedMenu<CratesPlugin, CrateKey>
implements LangContainer {
    private static final IconLocale LOCALE_DELETE = LangEntry.iconBuilder((String)"Editor.Button.Key.Delete").accentColor((TagWrapper)TagWrappers.RED).name("Delete Key").appendInfo(new String[]{"Permanently deletes the key."}).br().appendClick("Press [" + (String)TagWrappers.KEY.apply("key.drop") + "] to delete").build();
    private static final IconLocale LOCALE_NAME = LangEntry.iconBuilder((String)"Editor.Button.Key.Name").name("Display Name").appendCurrent("Current", "%key_name%").br().appendClick("Click to change").build();
    private static final IconLocale LOCALE_ITEM = LangEntry.iconBuilder((String)"Editor.Button.Key.Item").name("Key Item").appendCurrent("Status", "%inspection%").appendCurrent("Stackable", "%state%").br().appendInfo(new String[]{"Drop an item on " + TagWrappers.SOFT_YELLOW.wrap("this") + " button", "to replace the key's item."}).br().appendClick("Click to toggle stacking").build();
    private static final IconLocale LOCALE_VIRTUAL = LangEntry.iconBuilder((String)"Editor.Button.Key.Virtual").name("Virtual").appendCurrent("State", "%state%").br().appendInfo(new String[]{"Controls whether the key is virtual."}).br().appendClick("Click to toggle").build();
    private final DialogRegistry dialogs;

    public KeyOptionsMenu(@NotNull CratesPlugin plugin, @NotNull DialogRegistry dialogs) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Lang.EDITOR_TITLE_KEY_LIST.text());
        this.dialogs = dialogs;
        ((CratesPlugin)this.plugin).injectLang(this);
        this.addItem(MenuItem.buildReturn((Menu)this, (int)40, (viewer, event) -> this.runNextTick(() -> plugin.getEditorManager().openKeyList(viewer.getPlayer()))));
        this.addItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])IntStream.range(36, 45).toArray()));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Player player = viewer.getPlayer();
        CrateKey key = (CrateKey)this.getLink(player);
        Runnable flush = () -> this.flush(player);
        viewer.addItem(NightItem.fromType((Material)Material.NAME_TAG).localized(LOCALE_NAME).replacement(replacer -> replacer.replace(key.replacePlaceholders())).toMenuItem().setSlots(new int[]{11}).setHandler((viewer1, event) -> this.dialogs.show(player, KeyDialogs.NAME, key, flush)).build());
        if (!key.isVirtual()) {
            viewer.addItem(NightItem.fromItemStack((ItemStack)key.getItemStack()).localized(LOCALE_ITEM).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_GENERIC_ITEM, key.getItem().isValid())).replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(key.isItemStackable()))).toMenuItem().setSlots(new int[]{13}).setHandler((viewer1, event) -> {
                ItemStack cursor = event.getCursor();
                if (cursor == null || cursor.getType().isAir()) {
                    if (event.isLeftClick()) {
                        key.setItemStackable(!key.isItemStackable());
                        key.markDirty();
                        this.runNextTick(flush);
                    }
                    return;
                }
                ItemStack clean = CrateUtils.removeCrateTags(new ItemStack(cursor));
                Players.addItem((Player)player, (ItemStack[])new ItemStack[]{cursor});
                event.getView().setCursor(null);
                this.dialogs.show(player, KeyDialogs.ITEM, new GenericItemDialog.Data<CrateKey>(key, clean), flush);
            }).build());
        }
        viewer.addItem(NightItem.fromType((Material)Material.ENDER_PEARL).localized(LOCALE_VIRTUAL).replacement(replacer -> replacer.replace("%state%", () -> CoreLang.STATE_YES_NO.get(key.isVirtual()))).toMenuItem().setSlots(new int[]{15}).setHandler((viewer1, event) -> {
            key.setVirtual(!key.isVirtual());
            key.markDirty();
            this.runNextTick(flush);
        }).build());
        viewer.addItem(NightItem.fromType((Material)Material.BARRIER).localized(LOCALE_DELETE).toMenuItem().setSlots(new int[]{44}).setHandler((viewer1, event) -> {
            if (event.getClick() != ClickType.DROP) {
                return;
            }
            ((CratesPlugin)this.plugin).getKeyManager().delete(key);
            this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openKeyList(player));
        }).build());
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void onClick(@NotNull MenuViewer viewer, @NotNull ClickResult result, @NotNull InventoryClickEvent event) {
        super.onClick(viewer, result, event);
        if (result.isInventory()) {
            event.setCancelled(false);
        }
    }
}

