/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.key;

import java.util.Comparator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.dialog.DialogRegistry;
import su.nightexpress.excellentcrates.key.CrateKey;
import su.nightexpress.excellentcrates.key.KeyManager;
import su.nightexpress.excellentcrates.key.dialog.KeyDialogs;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class KeyListMenu
extends LinkedMenu<CratesPlugin, KeyManager>
implements Filled<CrateKey>,
LangContainer {
    private static final IconLocale LOCALE_CREATION = LangEntry.iconBuilder((String)"Editor.Button.Keys.Create").accentColor((TagWrapper)TagWrappers.GREEN).name("New Key").appendInfo(new String[]{"Use this button to create", "brand new keys!"}).br().appendClick("Click to create").build();
    private static final IconLocale LOCALE_KEY = LangEntry.iconBuilder((String)"Editor.Button.Keys.Key").rawName("%key_name%").appendCurrent("Status", "%inspection%").appendCurrent("ID", "%key_id%").appendCurrent("Virtual", "%state%").br().appendClick("Click to edit").build();
    private final DialogRegistry dialogs;

    public KeyListMenu(@NotNull CratesPlugin plugin, @NotNull DialogRegistry dialogs) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Lang.EDITOR_TITLE_KEY_LIST.text());
        this.dialogs = dialogs;
        ((CratesPlugin)this.plugin).injectLang(this);
        this.addItem(MenuItem.buildReturn((Menu)this, (int)40, (viewer, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openEditor(viewer.getPlayer()))));
        this.addItem(MenuItem.buildNextPage((Menu)this, (int)44));
        this.addItem(MenuItem.buildPreviousPage((Menu)this, (int)36));
        this.addItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])IntStream.range(36, 45).toArray()));
        this.addItem(MenuItem.background((Material)Material.GRAY_STAINED_GLASS_PANE, (int[])IntStream.range(0, 36).toArray()));
        this.addItem(Material.ANVIL, LOCALE_CREATION, 42, (viewer, event, manager) -> {
            Player player = viewer.getPlayer();
            this.dialogs.show(player, KeyDialogs.CREATION, manager, () -> this.flush(player));
        });
    }

    @NotNull
    public MenuFiller<CrateKey> createFiller(@NotNull MenuViewer viewer) {
        MenuFiller.Builder autoFill = MenuFiller.builder((Filled)this);
        autoFill.setSlots(IntStream.range(0, 36).toArray());
        autoFill.setItems(((CratesPlugin)this.plugin).getKeyManager().getKeys().stream().sorted(Comparator.comparing(CrateKey::getId)).toList());
        autoFill.setItemCreator(key -> NightItem.fromItemStack((ItemStack)key.getRawItem()).hideAllComponents().localized(LOCALE_KEY).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_GENERIC_OVERVIEW, !key.hasProblems())).replace("%state%", () -> CoreLang.STATE_YES_NO.get(key.isVirtual())).replace(key.replacePlaceholders())));
        autoFill.setItemClick(key -> (viewer1, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openKeyOptions(viewer1.getPlayer(), (CrateKey)key)));
        return autoFill.build();
    }

    public void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }
}

