/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.crate;

import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.api.crate.RewardType;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.reward.RewardDialogs;
import su.nightexpress.excellentcrates.crate.reward.impl.CommandReward;
import su.nightexpress.excellentcrates.crate.reward.impl.ItemReward;
import su.nightexpress.excellentcrates.dialog.DialogRegistry;
import su.nightexpress.excellentcrates.dialog.reward.RewardPreviewDialog;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.click.ClickResult;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardOptionsMenu
extends LinkedMenu<CratesPlugin, Reward>
implements LangContainer {
    private static final IconLocale LOCALE_ITEMS = LangEntry.iconBuilder((String)"Editor.Button.Reward.Items").name("Items to Give").appendCurrent("Status", "%inspection%").appendCurrent("Items", "%amount%").br().appendInfo(new String[]{"Gives listed items when won."}).br().appendClick("Click to open").build();
    private static final IconLocale LOCALE_COMMANDS = LangEntry.iconBuilder((String)"Editor.Button.Reward.Commands").name("Commands to Run").appendCurrent("Status", "%inspection%").appendCurrent("Commands", "%amount%").br().appendInfo(new String[]{"Runs listed commands when won."}).br().appendClick("Click to edit").build();
    private static final IconLocale LOCALE_PREVIEW_NORMAL = LangEntry.iconBuilder((String)"Editor.Button.Reward.PreviewNormal").name("Preview Item").appendCurrent("Status", "%inspection%").br().appendInfo(new String[]{"Drop an item on " + TagWrappers.SOFT_YELLOW.wrap("this") + " button", "to replace the reward preview."}).build();
    private static final IconLocale LOCALE_PREVIEW_CUSTOM = LangEntry.iconBuilder((String)"Editor.Button.Reward.PreviewCustom").name("Preview Item").appendCurrent("Status", "%inspection%").appendCurrent("Use Custom", "%state%").br().appendInfo(new String[]{"Drop an item on " + TagWrappers.SOFT_YELLOW.wrap("this") + " button", "to replace the reward preview."}).br().appendClick("Click to toggle custom usage").build();
    public static final IconLocale LOCALE_RARIRY_WEIGHT = LangEntry.iconBuilder((String)"Editor.Button.Reward.RarityWeight").name("Rarity & Weight").appendCurrent("Rarity", "%reward_rarity_name% \u2192 " + TagWrappers.SOFT_GREEN.wrap("%reward_rarity_roll_chance%%")).appendCurrent("Weight", "%reward_weight% \u2192 " + TagWrappers.SOFT_GREEN.wrap("%reward_roll_chance%%")).br().appendClick("Click to change").build();
    public static final IconLocale LOCALE_NAME = LangEntry.iconBuilder((String)"Editor.Button.Reward.Name").name("Display Name").appendCurrent("Current", "%reward_name%").br().appendClick("Click to change").build();
    public static final IconLocale LOCALE_DESCRIPTION = LangEntry.iconBuilder((String)"Editor.Button.Reward.Description").name("Description").rawLore(new String[]{"%reward_description%", "%empty-if-above%"}).appendClick("Click to change").build();
    public static final IconLocale LOCALE_BROADCAST = LangEntry.iconBuilder((String)"Editor.Button.Reward.Broadcast").name("Win Broadcast").appendCurrent("State", "%state%").br().appendInfo(new String[]{"Restricts player access to the reward", "based on their permissions."}).br().appendClick("Click to toggle").build();
    public static final IconLocale LOCALE_PERMISSIONS = LangEntry.iconBuilder((String)"Editor.Button.Reward.Permissions").name("Permissions").appendCurrent("Total Permissions", "%amount%").br().appendInfo(new String[]{"Restrict reward access based on", "player's permissions."}).br().appendClick("Click to edit").build();
    public static final IconLocale LOCALE_LIMITS = LangEntry.iconBuilder((String)"Editor.Button.Reward.Limits").name("Limits").appendCurrent("State", "%state%").br().appendInfo(new String[]{"Controls how often and how many", "times this reward can be won."}).br().appendClick("Click to edit").build();
    public static final IconLocale LOCALE_DELETE = LangEntry.iconBuilder((String)"Editor.Button.Reward.Delete").accentColor((TagWrapper)TagWrappers.SOFT_RED).name("Delete Reward").appendInfo(new String[]{"Permanently deletes the reward."}).br().appendClick("Press " + (String)TagWrappers.KEY.apply("key.drop") + " to delete").build();
    private final DialogRegistry dialogs;

    public RewardOptionsMenu(@NotNull CratesPlugin plugin, @NotNull DialogRegistry dialogs) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X6, Lang.EDITOR_TITLE_REWARD_SETTINGS.text());
        this.dialogs = dialogs;
        ((CratesPlugin)this.plugin).injectLang(this);
        this.addItem(MenuItem.buildReturn((Menu)this, (int)49, (viewer, event) -> this.runNextTick(() -> plugin.getEditorManager().openRewardList(viewer.getPlayer(), ((Reward)this.getLink(viewer)).getCrate()))));
        this.addItem(MenuItem.background((Material)Material.GLASS_PANE, (int[])new int[]{19, 20, 21, 22, 23, 24, 25}));
        this.addItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])IntStream.range(45, 54).toArray()));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Player player = viewer.getPlayer();
        Reward reward = (Reward)this.getLink(player);
        Crate crate = reward.getCrate();
        Runnable flush = () -> this.flush(player);
        viewer.addItem(NightItem.fromItemStack((ItemStack)reward.getPreviewItem()).localized(reward.getType() == RewardType.ITEM ? LOCALE_PREVIEW_CUSTOM : LOCALE_PREVIEW_NORMAL).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_REWARD_PREVIEW, reward.getPreview().isValid())).replace("%state%", () -> {
            ItemReward itemReward;
            return CoreLang.STATE_ENABLED_DISALBED.get(reward instanceof ItemReward && (itemReward = (ItemReward)reward).isCustomPreview());
        })).toMenuItem().setSlots(new int[]{11}).setHandler((viewer1, event) -> {
            ItemStack cursor = event.getCursor();
            if (cursor == null || cursor.getType().isAir()) {
                if (reward instanceof ItemReward) {
                    ItemReward itemReward;
                    itemReward.setCustomPreview(!(itemReward = (ItemReward)reward).isCustomPreview());
                    crate.markDirty();
                    this.runNextTick(flush);
                }
                return;
            }
            ItemStack copy = new ItemStack(cursor);
            Players.addItem((Player)player, (ItemStack[])new ItemStack[]{copy});
            event.getView().setCursor(null);
            if (!ItemHelper.isCustom(copy)) {
                reward.setPreview(ItemHelper.vanilla(copy));
                crate.markDirty();
                this.runNextTick(flush);
            } else {
                this.dialogs.show(player, RewardDialogs.PREVIEW, new RewardPreviewDialog.Data(reward, copy), flush);
            }
        }).build());
        if (reward instanceof ItemReward) {
            ItemReward itemReward = (ItemReward)reward;
            viewer.addItem(NightItem.fromType((Material)Material.BUNDLE).hideAllComponents().localized(LOCALE_ITEMS).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_REWARD_ITEMS, itemReward.hasContent() && !itemReward.hasInvalidItems())).replace("%amount%", () -> itemReward.hasContent() ? CoreLang.goodEntry((String)String.valueOf(itemReward.countItems())) : CoreLang.badEntry((String)Lang.INSPECTIONS_REWARD_NO_ITEMS.text()))).toMenuItem().setSlots(new int[]{10}).setHandler((viewer1, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openRewardContent(viewer.getPlayer(), itemReward))).build());
        } else if (reward instanceof CommandReward) {
            CommandReward commandReward = (CommandReward)reward;
            viewer.addItem(NightItem.fromType((Material)Material.COMMAND_BLOCK).hideAllComponents().localized(LOCALE_COMMANDS).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_GENERIC_COMMANDS, commandReward.hasContent() && !commandReward.hasInvalidCommands())).replace("%amount%", () -> commandReward.hasContent() ? CoreLang.goodEntry((String)String.valueOf(commandReward.countCommands())) : CoreLang.badEntry((String)Lang.INSPECTIONS_REWARD_NO_COMMANDS.text()))).toMenuItem().setSlots(new int[]{10}).setHandler((viewer1, event) -> this.dialogs.show(player, RewardDialogs.COMMANDS, commandReward, flush)).build());
            viewer.addItem(NightItem.fromType((Material)Material.NAME_TAG).localized(LOCALE_NAME).replacement(replacer -> replacer.replace(reward.replacePlaceholders())).toMenuItem().setSlots(new int[]{30}).setHandler((viewer1, event) -> this.dialogs.show(player, RewardDialogs.NAME, commandReward, flush)).build());
            viewer.addItem(NightItem.fromType((Material)Material.WRITABLE_BOOK).localized(LOCALE_DESCRIPTION).replacement(replacer -> replacer.replace(reward.replacePlaceholders())).toMenuItem().setSlots(new int[]{32}).setHandler((viewer1, event) -> this.dialogs.show(player, RewardDialogs.DESCRIPTION, commandReward, flush)).build());
        }
        viewer.addItem(NightItem.fromType((Material)Material.GLISTERING_MELON_SLICE).localized(LOCALE_RARIRY_WEIGHT).replacement(replacer -> replacer.replace(reward.replacePlaceholders())).toMenuItem().setSlots(new int[]{12}).setHandler((viewer1, event) -> this.dialogs.show(player, RewardDialogs.WEIGHT, reward, flush)).build());
        viewer.addItem(NightItem.fromType((Material)Material.ENDER_PEARL).localized(LOCALE_BROADCAST).replacement(replacer -> replacer.replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(reward.isBroadcast()))).toMenuItem().setSlots(new int[]{13}).setHandler((viewer1, event) -> {
            reward.setBroadcast(!reward.isBroadcast());
            crate.markDirty();
            this.runNextTick(flush);
        }).build());
        viewer.addItem(NightItem.fromType((Material)Material.REDSTONE).localized(LOCALE_PERMISSIONS).replacement(replacer -> replacer.replace("%amount%", () -> String.valueOf(reward.getIgnoredPermissions().size() + reward.getRequiredPermissions().size()))).toMenuItem().setSlots(new int[]{14}).setHandler((viewer1, event) -> this.dialogs.show(player, RewardDialogs.PERMISSIONS, reward, flush)).build());
        viewer.addItem(NightItem.fromType((Material)Material.COMPARATOR).localized(LOCALE_LIMITS).replacement(replacer -> replacer.replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(reward.getLimits().isEnabled()))).toMenuItem().setSlots(new int[]{15}).setHandler((viewer1, event) -> this.dialogs.show(player, RewardDialogs.LIMITS, reward, flush)).build());
        viewer.addItem(NightItem.fromType((Material)Material.BARRIER).localized(LOCALE_DELETE).toMenuItem().setSlots(new int[]{53}).setHandler((viewer1, event) -> {
            if (event.getClick() != ClickType.DROP) {
                return;
            }
            crate.removeReward(reward);
            crate.markDirty();
            this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openRewardList(player, crate));
        }).build());
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void onClick(@NotNull MenuViewer viewer, @NotNull ClickResult result, @NotNull InventoryClickEvent event) {
        super.onClick(viewer, result, event);
        if (result.isInventory()) {
            event.setCancelled(false);
        }
    }
}

