/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.crate;

import java.util.ArrayList;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.api.crate.RewardType;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.reward.RewardDialogs;
import su.nightexpress.excellentcrates.crate.reward.RewardFactory;
import su.nightexpress.excellentcrates.dialog.DialogRegistry;
import su.nightexpress.excellentcrates.dialog.reward.RewardCreationDialog;
import su.nightexpress.excellentcrates.util.ItemHelper;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.bridge.item.AdaptedItem;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.click.ClickResult;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Lists;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class RewardListMenu
extends LinkedMenu<CratesPlugin, Data>
implements Filled<Reward>,
LangContainer {
    private static final IconLocale LOCALE_REWARD = LangEntry.iconBuilder((String)"Editor.Button.Rewards.Reward").rawName("%reward_name%").appendCurrent("Status", "%inspection%").appendCurrent("ID", "%reward_id%").appendCurrent("Weight", "%reward_weight% \u2192 " + TagWrappers.GREEN.wrap("%reward_roll_chance%%")).appendCurrent("Rarity", "%reward_rarity_name% \u2192 " + TagWrappers.GREEN.wrap("%reward_rarity_roll_chance%%")).br().appendClick("Click to edit").build();
    private static final IconLocale LOCALE_CREATION = LangEntry.iconBuilder((String)"Editor.Button.Rewards.Creation").accentColor((TagWrapper)TagWrappers.GREEN).name("Reward Creation").appendInfo(new String[]{"Drop item on " + TagWrappers.GREEN.wrap("this") + " button", "to create a new reward of it."}).build();
    private static final IconLocale LOCALE_SORTING = LangEntry.iconBuilder((String)"Editor.Button.Rewards.Sorting").name("Sort Rewards").appendInfo(new String[]{"Automatically sorts rewards in", "certain order."}).br().appendClick("Click to open").build();
    private static final IconLocale LOCALE_MASS_MODE = LangEntry.iconBuilder((String)"Editor.Button.Rewards.MassMode").name("Mass Creation Mode").appendCurrent("Status", "%state%").appendCurrent("Reward Type", "%type%").br().appendInfo(new String[]{"Allows you to quickly add", "multiple rewards to the crate", "by clicking on items in", "your inventory."}).br().appendClick("Click to toggle mode").appendClick("Click to toggle type").build();
    private static final IconLocale LOCALE_ARRANGE_MODE = LangEntry.iconBuilder((String)"Editor.Button.Rewards.ArrangeMode").name("Arrange Mode").appendCurrent("Status", "%state%").br().appendInfo(new String[]{"Allows you to arrange rewards by", "shifting them left or right."}).br().appendInfo(new String[]{"Use the " + TagWrappers.SOFT_YELLOW.wrap("Left-Click") + " to shift left,"}).appendInfo(new String[]{"and the " + TagWrappers.SOFT_YELLOW.wrap("Right-Click") + " to shift right."}).br().appendClick("Click to toggle").build();
    private final DialogRegistry dialogs;

    public boolean open(@NotNull Player player, @NotNull Crate crate) {
        return this.open(player, crate, RewardType.ITEM, false, false);
    }

    private boolean open(@NotNull Player player, @NotNull Crate crate, @NotNull RewardType massModeType, boolean massMode, boolean arrangeMode) {
        return this.open(player, new Data(crate, massModeType, massMode, arrangeMode));
    }

    public RewardListMenu(@NotNull CratesPlugin plugin, @NotNull DialogRegistry dialogs) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Lang.EDITOR_TITLE_REWARD_LIST.text());
        this.dialogs = dialogs;
        ((CratesPlugin)this.plugin).injectLang(this);
        this.addItem(MenuItem.buildReturn((Menu)this, (int)40, (viewer, event) -> this.runNextTick(() -> plugin.getEditorManager().openOptionsMenu(viewer.getPlayer(), ((Data)this.getLink((MenuViewer)viewer)).crate))));
        this.addItem(MenuItem.buildNextPage((Menu)this, (int)41));
        this.addItem(MenuItem.buildPreviousPage((Menu)this, (int)39));
        this.addItem(NightItem.fromType((Material)Material.GRAY_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setSlots(IntStream.range(0, 36).toArray()).setPriority(-1));
        this.addItem(NightItem.fromType((Material)Material.BLACK_STAINED_GLASS_PANE).setHideTooltip(true).toMenuItem().setSlots(IntStream.range(36, 45).toArray()).setPriority(-1));
        this.addItem(Material.ANVIL, LOCALE_CREATION, 42, (viewer, event, data) -> {
            Player player = viewer.getPlayer();
            ItemStack cursor = event.getCursor();
            if (cursor == null || cursor.getType().isAir()) {
                return;
            }
            ItemStack copy = new ItemStack(cursor);
            event.getView().setCursor(null);
            Players.addItem((Player)player, (ItemStack[])new ItemStack[]{copy});
            this.dialogs.show(player, RewardDialogs.CREATION, new RewardCreationDialog.Data(data.crate, copy), () -> this.flush(player));
        });
        this.addItem(Material.COMPARATOR, LOCALE_SORTING, 38, (viewer, event, data) -> {
            Player player = viewer.getPlayer();
            this.dialogs.show(player, RewardDialogs.SORTING, data.crate, () -> this.flush(player));
        });
    }

    @NotNull
    public MenuFiller<Reward> createFiller(@NotNull MenuViewer viewer) {
        MenuFiller.Builder autoFill = MenuFiller.builder((Filled)this);
        autoFill.setSlots(IntStream.range(0, 36).toArray());
        autoFill.setItems(((Data)this.getLink((MenuViewer)viewer)).crate.getRewards());
        autoFill.setItemCreator(reward -> NightItem.fromItemStack((ItemStack)reward.getPreviewItem()).hideAllComponents().localized(LOCALE_REWARD).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_GENERIC_OVERVIEW, !reward.hasProblems())).replace(reward.replacePlaceholders())));
        autoFill.setItemClick(reward -> (viewer1, event) -> {
            Data data = (Data)this.getLink(viewer1);
            Crate crate = data.crate;
            if (data.arrangeMode) {
                if (!event.isLeftClick() && !event.isRightClick()) {
                    return;
                }
                ArrayList<Reward> all = new ArrayList<Reward>(crate.getRewards());
                int index = all.indexOf(reward);
                int allSize = all.size();
                if (event.isLeftClick()) {
                    if (index + 1 >= allSize) {
                        return;
                    }
                    all.remove(index);
                    all.add(index + 1, (Reward)reward);
                } else if (event.isRightClick()) {
                    if (index == 0) {
                        return;
                    }
                    all.remove(index);
                    all.add(index - 1, (Reward)reward);
                }
                crate.setRewards(all);
                crate.markDirty();
                this.runNextTick(() -> this.flush(viewer));
                return;
            }
            if (event.isLeftClick()) {
                this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openRewardOptions(viewer1.getPlayer(), (Reward)reward));
            }
        });
        return autoFill.build();
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Data data = (Data)this.getLink(viewer);
        viewer.addItem(NightItem.fromType((Material)Material.DROPPER).localized(LOCALE_MASS_MODE).replacement(replacer -> replacer.replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(data.massMode)).replace("%type%", () -> Lang.REWARD_TYPE.getLocalized((Enum)data.massModeType))).toMenuItem().setSlots(new int[]{36}).setHandler((viewer1, event) -> {
            if (event.isLeftClick()) {
                this.runNextTick(() -> this.open(viewer.getPlayer(), data.crate, data.massModeType, !data.massMode, data.arrangeMode));
            } else if (event.isRightClick()) {
                this.runNextTick(() -> this.open(viewer.getPlayer(), data.crate, (RewardType)Lists.next((Enum)data.massModeType), data.massMode, data.arrangeMode));
            }
        }).build());
        viewer.addItem(NightItem.fromType((Material)Material.PISTON).localized(LOCALE_ARRANGE_MODE).replacement(replacer -> replacer.replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(data.arrangeMode))).toMenuItem().setSlots(new int[]{44}).setHandler((viewer1, event) -> this.runNextTick(() -> this.open(viewer.getPlayer(), data.crate, data.massModeType, data.massMode, !data.arrangeMode))).build());
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void onClick(@NotNull MenuViewer viewer, @NotNull ClickResult result, @NotNull InventoryClickEvent event) {
        super.onClick(viewer, result, event);
        if (!result.isInventory()) {
            return;
        }
        Data data = (Data)this.getLink(viewer);
        if (!data.massMode) {
            event.setCancelled(false);
            return;
        }
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null || itemStack.getType().isAir()) {
            return;
        }
        AdaptedItem adapt = ItemHelper.adapt(itemStack, true);
        Reward reward = RewardFactory.wizardCreation((CratesPlugin)this.plugin, data.crate, itemStack, data.massModeType, adapt);
        data.crate.addReward(reward);
        data.crate.markDirty();
        this.runNextTick(() -> this.flush(viewer));
    }

    public record Data(@NotNull Crate crate, @NotNull RewardType massModeType, boolean massMode, boolean arrangeMode) {
    }
}

