/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.crate;

import java.util.stream.IntStream;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.config.Config;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.CrateDialogs;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.dialog.DialogRegistry;
import su.nightexpress.excellentcrates.dialog.generic.GenericItemDialog;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.click.ClickResult;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.Players;
import su.nightexpress.nightcore.util.StringUtil;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrapper;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;
import su.nightexpress.nightcore.util.time.TimeFormats;

public class CrateOptionsMenu
extends LinkedMenu<CratesPlugin, Crate>
implements LangContainer {
    private static final IconLocale LOCALE_DELETE = LangEntry.iconBuilder((String)"Editor.Button.Crate.Delete").accentColor((TagWrapper)TagWrappers.RED).name("Delete Crate").appendInfo(new String[]{"Permanently deletes the crate."}).br().appendClick("Press [" + (String)TagWrappers.KEY.apply("key.drop") + "] to delete").build();
    private static final IconLocale LOCALE_NAME = LangEntry.iconBuilder((String)"Editor.Button.Crate.DisplayName").name("Name").appendCurrent("Current", "%crate_name%").br().appendInfo(new String[]{"Sets crate display name."}).br().appendClick("Click to change").build();
    private static final IconLocale LOCALE_DESCRIPTION = LangEntry.iconBuilder((String)"Editor.Button.Crate.Description").name("Description").rawLore(new String[]{"%crate_description%", "%empty-if-above%"}).appendInfo(new String[]{"Sets crate description."}).br().appendClick("Click to edit").build();
    private static final IconLocale LOCALE_ITEM = LangEntry.iconBuilder((String)"Editor.Button.Crate.Item").name("Crate Item").appendCurrent("Status", "%inspection%").appendCurrent("Stackable", "%state%").br().appendInfo(new String[]{"Drop an item on " + TagWrappers.SOFT_YELLOW.wrap("this") + " button", "to replace the crate's item."}).br().appendClick("Click to toggle stacking").build();
    private static final IconLocale LOCALE_PREVIEW_SET = LangEntry.iconBuilder((String)"Editor.Button.Crate.Preview.Set").name("Preview GUI").appendCurrent("Status", "%inspection%").appendCurrent("Preview ID", "%value%").br().appendInfo(new String[]{"Sets preview GUI for the crate."}).br().appendClick("Click to change").build();
    private static final IconLocale LOCALE_PREVIEW_UNSET = LangEntry.iconBuilder((String)"Editor.Button.Crate.Preview.Unset").name("Preview GUI").appendCurrent("Status", TagWrappers.RED.wrap("Disabled")).br().appendInfo(new String[]{"Sets preview GUI for this crate."}).br().appendClick("Click to change").build();
    private static final IconLocale LOCALE_OPENING_SET = LangEntry.iconBuilder((String)"Editor.Button.Crate.Opening.Set").name("Opening Animation").appendCurrent("Status", "%inspection%").appendCurrent("Preview ID", "%value%").br().appendInfo(new String[]{"Sets opening animation for the crate."}).br().appendClick("Click to change").build();
    private static final IconLocale LOCALE_OPENING_UNSET = LangEntry.iconBuilder((String)"Editor.Button.Crate.Opening.Unset").name("Opening Animation").appendCurrent("Status", TagWrappers.RED.wrap("Disabled")).br().appendInfo(new String[]{"Sets opening animation for the crate."}).br().appendClick("Click to change").build();
    private static final IconLocale LOCALE_LINKED_BLOCKS = LangEntry.iconBuilder((String)"Editor.Button.Crate.LinkedBlocks").name("Linked Block").rawLore(new String[]{TagWrappers.DARK_GRAY.wrap("Press " + TagWrappers.GOLD.wrap("[" + (String)TagWrappers.KEY.apply("key.drop") + "]") + " to unlink.")}).br().appendCurrent("Linked", "%state%").br().appendInfo(new String[]{"Link the crate to a block by", "using the link tool."}).br().appendInfo(new String[]{"Interacting with the linked block", "will preview and open the crate."}).br().appendClick("Click to get link tool").build();
    private static final IconLocale LOCALE_BLOCK_PUSHBACK = LangEntry.iconBuilder((String)"Editor.Button.Crate.BlockPushback").name("Block Pushback").appendCurrent("Status", "%state%").br().appendInfo(new String[]{"Pushes players back from the crate", "if they don't met the requirements."}).br().appendClick("Click to toggle").build();
    private static final IconLocale LOCALE_COST_OPTIONS = LangEntry.iconBuilder((String)"Editor.Button.Crate.CostOptions").name("Cost Options").appendInfo(new String[]{"Here you can set the " + TagWrappers.SOFT_YELLOW.wrap("'cost'"), "required to open the crate - ", "it can be " + TagWrappers.SOFT_YELLOW.wrap("keys") + ", " + TagWrappers.SOFT_YELLOW.wrap("currency") + ", or both."}).br().appendInfo(new String[]{"You can add multiple cost options,", "allowing players to choose how", "they want to open the crate."}).br().appendClick("Click to open").build();
    private static final IconLocale LOCALE_PERMISSION_REQUIREMENT = LangEntry.iconBuilder((String)"Editor.Button.Crate.Permission").name("Permission Requirement").appendCurrent("Status", "%state%").appendCurrent("Permission", "%value%").br().appendInfo(new String[]{"Controls whether permission is", "required to open the crate."}).br().appendClick("Click to toggle").build();
    private static final IconLocale LOCALE_OPEN_LIMITS = LangEntry.iconBuilder((String)"Editor.Button.Crate.OpeningCooldown").name("Open Limits").appendCurrent("Status", "%state%").appendCurrent("Cooldown", "%value%").appendCurrent("Limit Amount", "%amount%").br().appendInfo(new String[]{"Limits amount of crates", "can be opened per player", "for a time frame."}).br().appendClick("Click to edit").build();
    private static final IconLocale LOCALE_EFFECT = LangEntry.iconBuilder((String)"Editor.Button.Crate.Effect").name("Crate Effect").appendCurrent("Model", "%type%").appendCurrent("Particle", "%value%").br().appendInfo(new String[]{"Sets effect for the crate block(s)."}).br().appendClick("Click to edit").build();
    public static final IconLocale LOCALE_HOLOGRAM = LangEntry.iconBuilder((String)"Editor.Button.Crate.Hologram").name("Crate Hologram").appendCurrent("Status", "%inspection%").appendCurrent("State", "%state%").appendCurrent("Template", "%value%").br().appendInfo(new String[]{"Auto-manageable hologram above", "the linked crate block."}).br().appendClick("Click to edit").build();
    private static final IconLocale LOCALE_REWARDS = LangEntry.iconBuilder((String)"Editor.Button.Crate.Rewards").name("Rewards").appendCurrent("Status", "%inspection%").appendCurrent("Rewards", "%amount%").br().appendInfo(new String[]{"Add and manage crate's rewards!"}).br().appendClick("Click to open").build();
    private static final IconLocale LOCALE_MILESTONES = LangEntry.iconBuilder((String)"Editor.Button.Crate.Milestones").name("Milestones").appendCurrent("Milestones", "%amount%").br().appendInfo(new String[]{"Create custom milestones with", "rewards for the crate!"}).br().appendClick("Click to open").build();
    private static final IconLocale LOCALE_POST_OPEN_COMMANDS = LangEntry.iconBuilder((String)"Editor.Button.Crate.Post-Open-Commands").name("Post-Open Commands").appendCurrent("Status", "%inspection%").appendCurrent("Commands", "%amount%").br().appendInfo(new String[]{"Runs listed commands", "when the crate is opened."}).br().appendClick("Click to edit").build();
    private final DialogRegistry dialogs;

    public CrateOptionsMenu(@NotNull CratesPlugin plugin, @NotNull DialogRegistry dialogs) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X6, Lang.EDITOR_TITLE_CRATE_SETTINGS.text());
        this.dialogs = dialogs;
        ((CratesPlugin)this.plugin).injectLang(this);
        this.addItem(MenuItem.buildReturn((Menu)this, (int)49, (viewer, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openCrateList(viewer.getPlayer()))));
        this.addItem(MenuItem.background((Material)Material.BLACK_STAINED_GLASS_PANE, (int[])IntStream.range(45, 54).toArray()));
        this.addItem(MenuItem.background((Material)Material.GLASS_PANE, (int[])IntStream.range(19, 26).toArray()));
    }

    protected void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        Player player = viewer.getPlayer();
        Crate crate = (Crate)this.getLink(player);
        Runnable flush = () -> this.flush(player);
        viewer.addItem(NightItem.fromType((Material)Material.NAME_TAG).localized(LOCALE_NAME).replacement(replacer -> replacer.replace(crate.replacePlaceholders())).toMenuItem().setSlots(new int[]{10}).setHandler((viewer1, event) -> this.dialogs.show(player, CrateDialogs.CRATE_NAME, crate, flush)).build());
        viewer.addItem(NightItem.fromType((Material)Material.WRITABLE_BOOK).localized(LOCALE_DESCRIPTION).replacement(replacer -> replacer.replace(crate.replacePlaceholders())).toMenuItem().setSlots(new int[]{11}).setHandler((viewer1, event) -> this.dialogs.show(player, CrateDialogs.CRATE_DESCRIPTION, crate, flush)).build());
        viewer.addItem(NightItem.fromItemStack((ItemStack)crate.getItemStack()).localized(LOCALE_ITEM).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_GENERIC_ITEM, crate.getItem().isValid())).replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(crate.isItemStackable()))).toMenuItem().setSlots(new int[]{12}).setHandler((viewer1, event) -> {
            ItemStack cursor = event.getCursor();
            if (cursor == null || cursor.getType().isAir()) {
                if (event.isLeftClick()) {
                    crate.setItemStackable(!crate.isItemStackable());
                    crate.markDirty();
                    this.runNextTick(flush);
                }
                return;
            }
            ItemStack clean = CrateUtils.removeCrateTags(new ItemStack(cursor));
            Players.addItem((Player)player, (ItemStack[])new ItemStack[]{cursor});
            event.getView().setCursor(null);
            this.dialogs.show(player, CrateDialogs.CRATE_ITEM, new GenericItemDialog.Data<Crate>(crate, clean), flush);
        }).build());
        viewer.addItem(NightItem.fromType((Material)Material.PAINTING).localized(crate.isPreviewEnabled() ? LOCALE_PREVIEW_SET : LOCALE_PREVIEW_UNSET).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_CRATE_PREVIEW, crate.isPreviewValid())).replace("%value%", crate::getPreviewId)).toMenuItem().setSlots(new int[]{13}).setHandler((viewer1, event) -> this.dialogs.show(player, CrateDialogs.CRATE_PREVIEW, crate, flush)).build());
        viewer.addItem(NightItem.fromType((Material)Material.GLOW_ITEM_FRAME).localized(crate.isOpeningEnabled() ? LOCALE_OPENING_SET : LOCALE_OPENING_UNSET).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_CRATE_OPENING, crate.isOpeningValid())).replace("%value%", crate::getOpeningId)).toMenuItem().setSlots(new int[]{14}).setHandler((viewer1, event) -> this.dialogs.show(player, CrateDialogs.CRATE_OPENING, crate, flush)).build());
        viewer.addItem(NightItem.fromType((Material)Material.BEACON).localized(LOCALE_LINKED_BLOCKS).replacement(replacer -> replacer.replace("%state%", () -> CoreLang.STATE_YES_NO.get(!crate.getBlockPositions().isEmpty()))).toMenuItem().setSlots(new int[]{15}).setHandler((viewer1, event) -> {
            if (event.getClick() == ClickType.DROP) {
                crate.removeHologram();
                crate.clearBlockPositions();
                crate.markDirty();
                this.runNextTick(flush);
                return;
            }
            ((CratesPlugin)this.plugin).getCrateManager().giveLinkTool(player, crate);
            this.runNextTick(() -> ((Player)player).closeInventory());
        }).build());
        viewer.addItem(NightItem.fromType((Material)Material.SLIME_BLOCK).localized(LOCALE_BLOCK_PUSHBACK).replacement(replacer -> replacer.replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(crate.isPushbackEnabled()))).toMenuItem().setSlots(new int[]{16}).setHandler((viewer1, event) -> {
            crate.setPushbackEnabled(!crate.isPushbackEnabled());
            crate.markDirty();
            this.runNextTick(flush);
        }).build());
        viewer.addItem(NightItem.fromType((Material)Material.TRIAL_KEY).localized(LOCALE_COST_OPTIONS).toMenuItem().setSlots(new int[]{28}).setHandler((viewer1, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openCosts(viewer.getPlayer(), crate))).build());
        viewer.addItem(NightItem.fromType((Material)(crate.isPermissionRequired() ? Material.REDSTONE : Material.GUNPOWDER)).localized(LOCALE_PERMISSION_REQUIREMENT).replacement(replacer -> replacer.replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(crate.isPermissionRequired())).replace("%value%", crate::getPermission)).toMenuItem().setSlots(new int[]{29}).setHandler((viewer1, event) -> {
            crate.setPermissionRequired(!crate.isPermissionRequired());
            crate.markDirty();
            this.runNextTick(flush);
        }).build());
        viewer.addItem(NightItem.fromType((Material)Material.CLOCK).localized(LOCALE_OPEN_LIMITS).replacement(replacer -> replacer.replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(crate.isOpeningCooldownEnabled())).replace("%value%", () -> {
            if ((long)crate.getOpeningCooldownTime() < 0L) {
                return CoreLang.OTHER_ONE_TIMED.text();
            }
            return TimeFormats.toLiteral((long)((long)crate.getOpeningCooldownTime() * 1000L));
        }).replace("%amount%", () -> String.valueOf(crate.getOpeningLimitAmount()))).toMenuItem().setSlots(new int[]{30}).setHandler((viewer1, event) -> this.dialogs.show(player, CrateDialogs.CRATE_OPENING_LIMITS, crate, flush)).build());
        viewer.addItem(NightItem.fromType((Material)Material.BLAZE_POWDER).localized(LOCALE_EFFECT).replacement(replacer -> replacer.replace("%type%", () -> StringUtil.capitalizeUnderscored((String)crate.getEffectType())).replace("%value%", () -> Lang.PARTICLE.getLocalized((Keyed)crate.getEffectParticle().getParticle()))).toMenuItem().setSlots(new int[]{31}).setHandler((viewer1, event) -> this.dialogs.show(player, CrateDialogs.CRATE_EFFECT, crate, flush)).build());
        if (((CratesPlugin)this.plugin).hasHolograms()) {
            viewer.addItem(NightItem.fromType((Material)Material.ARMOR_STAND).localized(LOCALE_HOLOGRAM).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_CRATE_HOLOGRAM, crate.isHologramTemplateValid())).replace("%state%", () -> CoreLang.STATE_ENABLED_DISALBED.get(crate.isHologramEnabled())).replace("%value%", crate::getHologramTemplateId)).toMenuItem().setSlots(new int[]{32}).setHandler((viewer1, event) -> this.dialogs.show(player, CrateDialogs.CRATE_HOLOGRAM, crate, flush)).build());
        }
        viewer.addItem(NightItem.fromType((Material)Material.VAULT).localized(LOCALE_REWARDS).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_GENERIC_OVERVIEW, crate.getRewards().stream().noneMatch(Reward::hasProblems))).replace("%amount%", () -> CoreLang.formatEntry((String)String.valueOf(crate.countRewards()), (crate.countRewards() > 0 ? 1 : 0) != 0))).toMenuItem().setSlots(new int[]{33}).setHandler((viewer1, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openRewardList(viewer.getPlayer(), crate))).build());
        if (Config.isMilestonesEnabled()) {
            viewer.addItem(NightItem.fromType((Material)Material.CAMPFIRE).localized(LOCALE_MILESTONES).replacement(replacer -> replacer.replace("%amount%", () -> String.valueOf(crate.countMilestones()))).toMenuItem().setSlots(new int[]{34}).setHandler((viewer1, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openMilestones(viewer.getPlayer(), crate))).build());
        }
        viewer.addItem(NightItem.fromType((Material)Material.BARRIER).localized(LOCALE_DELETE).toMenuItem().setSlots(new int[]{53}).setHandler((viewer1, event) -> {
            if (event.getClick() != ClickType.DROP) {
                return;
            }
            ((CratesPlugin)this.plugin).getCrateManager().delete(crate);
            this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openCrateList(player));
        }).build());
        viewer.addItem(NightItem.fromType((Material)Material.COMMAND_BLOCK).localized(LOCALE_POST_OPEN_COMMANDS).replacement(replacer -> replacer.replace("%inspection%", () -> Lang.inspection(Lang.INSPECTIONS_GENERIC_COMMANDS, crate.getPostOpenCommands().stream().allMatch(CrateUtils::isValidCommand))).replace("%amount%", () -> String.valueOf(crate.getPostOpenCommands().size()))).toMenuItem().setSlots(new int[]{40}).setHandler((viewer1, event) -> this.dialogs.show(player, CrateDialogs.CRATE_POST_OPEN_COMMANDS, crate, flush)).build());
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }

    public void onClick(@NotNull MenuViewer viewer, @NotNull ClickResult result, @NotNull InventoryClickEvent event) {
        super.onClick(viewer, result, event);
        if (result.isInventory() && !event.isShiftClick()) {
            event.setCancelled(false);
        }
    }
}

