/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.excellentcrates.editor.crate;

import java.util.Comparator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.excellentcrates.CratesPlugin;
import su.nightexpress.excellentcrates.api.crate.Reward;
import su.nightexpress.excellentcrates.config.Lang;
import su.nightexpress.excellentcrates.crate.impl.Crate;
import su.nightexpress.excellentcrates.crate.impl.Milestone;
import su.nightexpress.excellentcrates.util.CrateUtils;
import su.nightexpress.nightcore.NightPlugin;
import su.nightexpress.nightcore.core.config.CoreLang;
import su.nightexpress.nightcore.locale.LangContainer;
import su.nightexpress.nightcore.locale.LangEntry;
import su.nightexpress.nightcore.locale.entry.IconLocale;
import su.nightexpress.nightcore.ui.dialog.Dialog;
import su.nightexpress.nightcore.ui.menu.Menu;
import su.nightexpress.nightcore.ui.menu.MenuViewer;
import su.nightexpress.nightcore.ui.menu.data.Filled;
import su.nightexpress.nightcore.ui.menu.data.MenuFiller;
import su.nightexpress.nightcore.ui.menu.item.MenuItem;
import su.nightexpress.nightcore.ui.menu.type.LinkedMenu;
import su.nightexpress.nightcore.util.bukkit.NightItem;
import su.nightexpress.nightcore.util.text.night.wrapper.TagWrappers;

public class CrateMilestonesMenu
extends LinkedMenu<CratesPlugin, Crate>
implements Filled<Milestone>,
LangContainer {
    private static final IconLocale MILESTONE_CREATE = LangEntry.iconBuilder((String)"Editor.Button.Milestone.Create").name("New Milestone").build();
    private static final IconLocale MILESTONE_OBJECT = LangEntry.iconBuilder((String)"Editor.Button.Milestone.Object").name("Milestone: %milestone_openings%").appendCurrent("Status", "%inspection%").appendCurrent("Openings", "%milestone_openings%").appendCurrent("Reward Id", "%milestone_reward_id%").br().appendClick("Left-Click to change openings").appendClick("Right-Click tochange reward").appendClick("Shift-Right delete " + TagWrappers.SOFT_RED.wrap("(no undo)")).build();

    public CrateMilestonesMenu(@NotNull CratesPlugin plugin) {
        super((NightPlugin)plugin, (MenuType)MenuType.GENERIC_9X5, Lang.EDITOR_TITLE_CRATE_MILESTONES.text());
        ((CratesPlugin)this.plugin).injectLang(this);
        this.addItem(MenuItem.buildReturn((Menu)this, (int)39, (viewer, event) -> this.runNextTick(() -> ((CratesPlugin)this.plugin).getEditorManager().openOptionsMenu(viewer.getPlayer(), (Crate)this.getLink(viewer)))));
        this.addItem(MenuItem.buildNextPage((Menu)this, (int)44));
        this.addItem(MenuItem.buildPreviousPage((Menu)this, (int)36));
        this.addItem(Material.ANVIL, MILESTONE_CREATE, 41, (viewer, event, crate) -> {
            Milestone milestone = new Milestone((Crate)crate, "null", 0);
            crate.getMilestones().add(milestone);
            crate.markDirty();
            this.runNextTick(() -> this.flush(viewer));
        });
    }

    @NotNull
    public MenuFiller<Milestone> createFiller(@NotNull MenuViewer viewer) {
        MenuFiller.Builder autoFill = MenuFiller.builder((Filled)this);
        autoFill.setSlots(IntStream.range(0, 36).toArray());
        autoFill.setItems(((Crate)this.getLink(viewer)).getMilestones().stream().sorted(Comparator.comparing(Milestone::getOpenings)).toList());
        autoFill.setItemCreator(milestone -> {
            Reward reward = milestone.getReward();
            return NightItem.fromItemStack((ItemStack)(reward == null ? CrateUtils.getQuestionStack() : reward.getPreviewItem())).localized(MILESTONE_OBJECT).hideAllComponents().replacement(replacer -> replacer.replace("%inspection%", () -> CoreLang.formatEntry((String)milestone.getRewardId(), (reward != null ? 1 : 0) != 0)).replace(milestone.replacePlaceholders()));
        });
        autoFill.setItemClick(milestone -> (viewer1, event) -> {
            Crate crate = (Crate)this.getLink(viewer1);
            if (event.isShiftClick() && event.isRightClick()) {
                crate.getMilestones().remove(milestone);
                crate.markDirty();
                this.runNextTick(() -> this.flush(viewer));
                return;
            }
            if (event.isLeftClick()) {
                this.handleInput(Dialog.builder((MenuViewer)viewer1, (String)Lang.EDITOR_ENTER_AMOUNT.text(), input -> {
                    milestone.setOpenings(input.asInt(0));
                    crate.markDirty();
                    return true;
                }));
            } else if (event.isRightClick()) {
                this.handleInput(Dialog.builder((MenuViewer)viewer1, (String)Lang.EDITOR_ENTER_REWARD_ID.text(), input -> {
                    milestone.setRewardId(input.getTextRaw());
                    crate.markDirty();
                    return true;
                }).setSuggestions(crate.getRewardIds(), true));
            }
        });
        return autoFill.build();
    }

    public void onPrepare(@NotNull MenuViewer viewer, @NotNull InventoryView view) {
        this.autoFill(viewer);
    }

    protected void onReady(@NotNull MenuViewer viewer, @NotNull Inventory inventory) {
    }
}

